import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Random;
import org.gamora.*;

public class FreeSim extends GThread implements WindowListener {
    JScrollingTextArea tArea;
    GraphPane p;
    Gamora simulator;
    CoreController cc;

    public static void main(String[] args) {
	new FreeSim().start();
    }

    public FreeSim() {
	simulator=new Gamora();
	simulator.startup();
	cc=simulator.getCoreController();

	tArea=new JScrollingTextArea();
	tArea.setEditable(false);
	
	tArea.append("Welcome to FreeSim\n(C) 2000 Scott G. Miller\n");
	tArea.append("Key help:\n[INSERT]\t- Add a new node at the current ");
	tArea.append("mouse position\n");
	tArea.append("[DELETE]\t- Delete selected elements\n");
	tArea.append("L\t- Add edges for all selected elements\n");
	tArea.append("Mouse\t- Select a single element\n");
	tArea.append("Mouse+SHIFT\t- Add an element to the selection\n");
	tArea.append("Mouse+CTRL\t- Remove an element from the selection\n");
	
	p=new GraphPane(this, cc);
	
	JFrame f=new JFrame("FreeSim");
	f.setSize(new Dimension(800,600));
	Container c=f.getContentPane();

	p.setBackground(new Color(0,0,50));



	JSplitPane sp=new JSplitPane(JSplitPane.VERTICAL_SPLIT,
				     p, tArea);
	sp.setOneTouchExpandable(true);

	c.add(sp);

	f.addWindowListener(this);
	f.show();
	p.requestFocus();
	//	new Timer(60, top).start();
	sp.setDividerLocation(0.60);
    }

    public void run() {
	int id=0;

	Node last=new Node(cc, Integer.toString(id++),100,200);
	Random r=new Random();
	p.add(last);
	for (int i=0; i<10; i++) {
	    Node next=new Node(cc, Integer.toString(p.id++),r.nextInt(800), r.nextInt(400));
	    p.add(next);
	    last=next;
	}
    }

    public void windowClosed(WindowEvent e) {}
    public void windowDeiconified(WindowEvent e) {}
    public void windowIconified(WindowEvent e) {}
    public void windowActivated(WindowEvent e) {}
    public void windowDeactivated(WindowEvent e) {}
    public void windowOpened(WindowEvent e) {}
    
    public void windowClosing(WindowEvent e) {
	System.exit(0);
    }



}


