import java.awt.*;
import javax.swing.*;
import org.gamora.*;

public abstract class GraphComponent extends JComponent implements BusObject {
    public static final int[] _BUSOBJECT= {BUSOBJECT};

    public Color col=Color.gray;
    public Point location;

    protected CoreController coreController;
    protected Bus onBus;
    protected BusObjectDescriptor desc;

    public GraphComponent(CoreController cc) {
	coreController=cc;
	//Request the BusObjectDescriptor
	desc=cc.requestBusObjectDescriptor(_BUSOBJECT);
    }

    public abstract boolean contains(int x, int y);

    public void setColor(Color c) {
	col=c;
    }

    public void paint(Graphics g) {
	g.setColor(col);
    }

    public int getX() {
	return location.x;
    }

    public int getY() {
	return location.y;
    }

    public int getWidth() {
	return getSize().width;
    }

    public int getHeight() {
	return getSize().height;
    }

    public void setLocation(Point p) {
	location=p;
    }

    public Point getLocation(Point rv) {
	rv.x=location.x;
	rv.y=location.y;
	return rv;
    }

    public static double distance(double x1, double y1, double x2, double y2) {
	double xd=x1-x2;
	double yd=y1-y2;
	return Math.sqrt((xd*xd)+(yd*yd));
    }

    public void connect(Bus b) {
        onBus = b;
        desc.fqp = coreController.getFQP(this);
    }

    public void disconnect(Bus b) {
	if (onBus==b) onBus=null;
	desc.fqp="";
    }

    public void activate() {}

    public void deactivate() {}

    public Bus queryBus() {
        return onBus;
    }

    public BusObjectDescriptor queryDescriptor() {
        return desc;
    }

    public void busSuspend() {
        setState(SUSPENDED);
    }

    public void busResume() {
        setState(NOSTATE);
    }

    public void setState(int state) {
        desc.state = state;
    }

    public String toString() {
	return desc.fqp;
    }
}

