import javax.swing.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;
import org.gamora.*;

public class GraphPane extends JPanel 
    implements MouseListener, MouseMotionListener, KeyListener {
    
    int id;
    Point currentMouse;
    HashSet selected, keys;
    GraphComponent clicked;
    FreeSim parent;
    CoreController coreController;

    public GraphPane(FreeSim f, CoreController cc) {
	parent=f;
	coreController=cc;
	selected=new HashSet();
	keys=new HashSet();
	addMouseListener(this);
	addMouseMotionListener(this);
	addKeyListener(this);
    }

    public void paint(Graphics g) {
	super.paint(g);
	
	Component[] c=getComponents();
	for (int i=0; i<c.length; i++) 
	    if (c[i] instanceof Edge)
		c[i].paint(g);
	for (int i=0; i<c.length; i++) 
	    if (c[i] instanceof Vertex)
		c[i].paint(g);
	for (int i=0; i<c.length; i++) 
	    if (!(c[i] instanceof Edge ||
		  c[i] instanceof Vertex))
		c[i].paint(g);
    }

    public GraphComponent affected(int x, int y) {
	Component[] c=getComponents();
	for (int i=0; i<c.length; i++) 
	    if (c[i].contains(x,y))
		return (GraphComponent)c[i];
	return null;
    }

    static final Integer CTRL=new Integer(KeyEvent.VK_CONTROL);
    static final Integer SHIFT=new Integer(KeyEvent.VK_SHIFT);

    public void mouseClicked(MouseEvent e) {
	GraphComponent c=affected(e.getX(), e.getY());
	if (c!=null) {
	    if (keys.contains(CTRL)) 
		removeFromSelection(c);
	    else if (keys.contains(SHIFT))
		addToSelection(c);
	    else setSelection(c);
	}
    }

    public void deleteSelected() {
	Component[] c=getComponents();
	for (int i=0; i<c.length; i++) {
	    if (selected.contains(c[i])) {
		parent.tArea.append("Removing "+c[i]+'\n');
		remove(c[i]);
	    } else if (c[i] instanceof Edge) {
		Edge e=(Edge)c[i];
		for (int j=0; j<e.connections.length; j++) {
		    if (selected.contains(e.connections[j])) {
			parent.tArea.append("Removing "+c[i]+'\n');
			remove(e);
			break;
		    }
		}
	    }
	}
	repaint();
    }
    
    public boolean linked(Vertex one, Vertex two) {
	Component[] c=getComponents();
	for (int i=0; i<c.length; i++) {
	    if (c[i] instanceof Edge &&
		((Edge)c[i]).connects(one) &&
		((Edge)c[i]).connects(two))
		return true;
	}
	return false;
    }
		
    public void linkSelected() {
	Object[] selectedNodes=selected.toArray();
	for (int i=0; i<selectedNodes.length; i++) {
	    for (int j=i; j<selectedNodes.length; j++) {
		if (selectedNodes[i]!=selectedNodes[j] &&
		    selectedNodes[i] instanceof Node &&
		    selectedNodes[j] instanceof Node &&
		    !linked((Node)selectedNodes[i], (Node)selectedNodes[j])) {
		    Link e=new Link(coreController,
				    (Node)selectedNodes[i],
				    (Node)selectedNodes[j]);
		    parent.tArea.append("Adding "+e+'\n');
		    add(e);
		}
	    }
	}
	repaint();
    }

    public void setSelection(GraphComponent c) {
	parent.tArea.append("Selected " + c + '\n');
	for (Iterator i=selected.iterator(); i.hasNext();) {
	    GraphComponent cn=(GraphComponent)i.next();
	    cn.setColor(Color.gray);
	}
	selected.clear();
	selected.add(c);
	c.setColor(Color.yellow);
	repaint();
    }

    public void addToSelection(GraphComponent c) {
	parent.tArea.append("Added " + c + " to selection\n");
	selected.add(c);
	c.setColor(Color.yellow);
	repaint();
    }

    public void removeFromSelection(GraphComponent c) {
	parent.tArea.append("Removed " + c + " from selection\n");
	selected.remove(c);
	c.setColor(Color.gray);
	repaint();
    }

    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mousePressed(MouseEvent e) {
	requestFocus();
	clicked=affected(e.getX(), e.getY());
    }

    public void mouseReleased(MouseEvent e) {
	clicked=null;
    }

    public void mouseMoved(MouseEvent e) {
	currentMouse=e.getPoint();
    }

    public void mouseDragged(MouseEvent e) {
	if (clicked!=null) 
	    clicked.setLocation(new Point(e.getX(), e.getY()));
	repaint();
    }

    public void keyPressed(KeyEvent e) {
	int keyCode=e.getKeyCode();
	keys.add(new Integer(keyCode));
	switch (keyCode) {
	case e.VK_INSERT:
	    add(new Node(coreController,
			 Integer.toString(id++), currentMouse.x, 
			 currentMouse.y));
	    repaint();
	    break;
	}
    }

    public void keyReleased(KeyEvent e) {
	int keyCode=e.getKeyCode();
	keys.remove(new Integer(keyCode));
    }

    public void keyTyped(KeyEvent e) {
	switch (e.getKeyChar()) {
	case 'L': case 'l':
	    linkSelected();
	    break;
	case e.VK_DELETE: 
	    deleteSelected();
	    break;
	}
    }
}

