import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import org.gamora.CoreController;

public class Vertex extends GraphComponent {
    public static final int SIZE=11;
    private static Dimension DIM=new Dimension(SIZE, SIZE);

    public Vertex(CoreController cc, Point p) {
	super(cc);
	location=p;
    }

    public Vertex(CoreController cc, int x, int y) {
	this(cc, new Point(x, y));
    }

    public boolean contains(int x, int y) {
	return distance(location.x, location.y, x, y) < SIZE;
    }

    public Dimension getMinimumSize() { return DIM; }
    public Dimension getMaximumSize() { return DIM; }
    public Dimension getSize() { return DIM; }
    public Dimension getPreferredSize() { return DIM; }

    public void paint(Graphics g) {
	super.paint(g);
	g.fillOval(location.x-(SIZE/2), location.y-(SIZE/2), SIZE, SIZE);
    }
}
