package Freenet.support;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke.
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

  Explanation of Code Versions:
    0.0.0      = Initial Description
    0.0.1      = API Specified
    0.x (x>0)  = Partial Implementation
    x.0 (x>0)  = Operational

  Requires Classes: Class (version)
                    Class (version)
                    ...
 */

/**
 * This class represents a simple binary search tree.
 *
 * @version 1.0
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 **/

public class BinaryTree
{
  public String toString()
    {
      return tree.toString();
    }

  public Branch tree = null;
  protected int size = 0;

  /**
   * Add the given key/value pair to this BinaryTree.
   * <p>
   * Note that if a key is given which is already present, the new key is
   * considered "greater" than the original key, but can only be retrieved
   * through finding the original key and then getting its successor, which
   * can't be done through BinaryTree's public interface anyway.
   *
   * @param key the key to put
   * @param value the value associated with the key to put
   *
   */
  public void put(long key, Object value)
    {
      size++;
      if (tree == null)
	{
	  tree = new Branch(key, value, null);
	}
      else
	{
	  tree.put(key, value);
	}
    }

  /**
   * Remove the given key from this BinaryTree. The tree is unchanged if the
   * key wasn't present.
   *
   * @param key the key to remove
   */
  public void delete(long key)
    {
      Branch x,y,z;
      z=tree.get(key);
      if ((z.left == null) || (z.right == null))
	y=z;
      else
	y=z.successor();
      if (y.left != null)
	x = y.left;
      else
	x = y.right;
      if (x != null)
	x.parent = y.parent;
      if (y.parent == null)
	tree = x;
      else
	if (y == y.parent.left)
	  y.parent.left = x;
	else
	  y.parent.right = x;
      if (y != z)
	{
	  z.key = y.key;
	  z.value = y.value;
	}
    }

  /**
   * Get the value associated with the given key in this BinaryTree.
   *
   * @param key the key to search for
   * @return the value associated with the key, or null if the key was not
   * found.
   */
  public Object get(long key)
    {
      if (tree == null)
	return null;
      else
	{
	  Branch r = tree.get(key);
	  if (r == null)
	    return null;
	  else
	    return r.value;
	}
    }
}

/**
 * A node on a {@ref BinaryTree BinaryTree}.
 */

class Branch
{
  /**
   * The left child node.
   */
  public Branch left = null;

  /**
   * The right child node.
   */
  public Branch right = null;

  /**
   * The parent node.
   */
  public Branch parent;

  /**
   * The key for this node.
   */
  public long key;

  /**
   * The value of this node.
   */
  public Object value;

  /**
   * Construct a Branch with no children.
   *
   * @param key the key for the new node
   * @param value the value for the new node
   * @param parent the parent of the new node
   */

  public Branch(long key, Object value, Branch parent)
    {
      this.key = key;
      this.value = value;
      this.parent = parent;
    }

  /**
   * Returns a string representation of this Branch.
   *
   * @return a string representation of this Branch.
   */
  public String toString()
    {
      return "(Key:"+key+" Left:"+left+" Right:"+right+")";
    }

  /**
   * Add the given key/value pair as a new node to this Branch.
   * Descends the children (left or right depending on the relative
   * values of the keys) until a Branch is reached
   * which has an available child (again, left or right depending). A
   * new Branch is created and placed there.
   * <p>
   * Note that if a key is given which is already present, the new key is
   * considered "greater" than the original key, but can only be retrieved
   * through finding the original key and then getting its successor. In addition,
   * the new key's node could never get a right child node, since there is no possible
   * key between identical keys. Generally this doesn't matter, since BinaryTrees
   * aren't balanced anyway.
   *
   * @param key the key to put
   * @param value the value associated with the key to put
   */
  public void put (long key, Object value)
    {
      if (key<this.key)
	{
	  if (left == null)
	    {
	      left=new Branch(key,value,this);
	    }
	  else
	    left.put(key, value);
	}
      else
	{
	  if (right == null)
	    right=new Branch(key, value, this);
	  else
	    right.put(key, value);
	}
    }

  /**
   * Search the binary tree starting at this Branch for the given key.
   * Descends the children (left or right depending on the relative values
   * of the keys) until a Branch is reached which has the correct key value.
   *
   * @param key the key to search for
   * @return the Branch associated with the key if found, or null if not found.
   */
  public Branch get(long key)
    {
      if (this.key == key)
	return this;
      else
	{
	  if (key < this.key)
	    {
	      if (left == null)
		return null;
	      else
		return left.get(key);
	    }
	  else
	    {
	      if (right == null)
		return null;
	      else
		return right.get(key);
	    }
	}
    }

  /**
   * Returns the Branch associated with the next highest key starting from
   * this Branch.
   *
   * @return the Branch associated with the next highest key starting from
   * this Branch.
   */
  public Branch successor()
    {
      if (right != null)
	return right.minimum();
      else
	{
	  Branch y = this;
	  while((y != null) && (y.parent.left != this))
	    {
	      y = y.parent;
	    }
	  if (y == null)
	    return null;
	  else
	    return y.parent;
	}
    }

  /**
   * Returns the Branch associated with the smallest key starting from
   * this Branch.
   *
   * @return the Branch associated with the smallest key starting from this Branch.
   */
  public Branch minimum()
    {
      if (left == null)
	return this;
      else
	return left.minimum();
    }
}





