package Freenet.support;

import java.util.*;

/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
*/

/**
 * Implements a thread-safe Blocking Queue. A BlockingQueue
 * is a FIFO (First In First Out) buffer
 * with the property that calls to dequeue() on an empty queue will block
 * until an element becomes available to dequeue.
 *
 * @author Scott G. Miller <scgmille@indiana.edu>
 */
public class BlockingQueue {
    private Vector queue;

    /**
     * Construct an empty BlockingQueue.
     *
     *
     */
    
    public BlockingQueue() {
	queue=new Vector();
    }

    /**
     * Queues an object onto this BlockingQueue.
     *
     * @param o the object to enqueue
     */
    public void enqueue(Object o) {
	synchronized(queue) {
	    queue.addElement(o);
	    queue.notify();
	}
    }

    /**
     * Dequeues an object from this BlockingQueue.  This method will return the
     * next element in this BlockingQueue, or block until one is available.
     *
     * @return the object on the top of this BlockingQueue
     * @throws InterruptedException if this thread is blocked in this method 
     * and something interrupts this thread.
     */
    public Object dequeue() throws InterruptedException {
	synchronized(queue) {
	    if (queue.isEmpty()) {
		synchronized(queue) {
		    queue.wait();
		}
		return dequeue();
	    } else {
		Object tmp=queue.firstElement();
		queue.removeElementAt(0);
		return tmp;
	    }
	}
    }


    /**
     * Returns the empty status of this BlockingQueue.
     *
     * @return true if this BlockingQueue is empty, false otherwise.
     */
    
    public boolean isEmpty() {
	return queue.isEmpty();
    }
    
    /**
     * Returns the number of objects in this BlockingQueue.
     *
     * @return the number of objects in this BlockingQueue.
     */

    public int size() {
	return queue.size();
    }
}
    
