package Freenet.support;

/**
 * An interface used in {@ref CounterFilterInputStream CounterFilterInputStream}
 * and {@ref CounterFilterOutputStream CounterFilterOutputStream} used to count bytes.
 */

public interface ByteCounter 
{
    /**
     * This method is called when bytes are to be counted.
     * 
     * @param n the number of bytes to be counted.
     */
    
    public void count(int n);
    
    /**
     * This method is called to initialize the counter.
     *
     * @param val the number of bytes counted to start with.
     * @param name an optional name for this counter.
     */
    
    public void start(long val, String name);
    
    /**
     * This method is called when there are no more bytes
     * to be counted.
     */
    
    public void finished();
}
