package Freenet.support;

/**
 * This class contains static methods used for parsing 
 * boolean and unsigned long fields in Freenet messages.
 *
 * @author oskar
 **/

public abstract class Fields {

    /**
     * Converts an unsigned hex string into a long.
     * @param hex A string in capital or lower case hex, of no more then 16 
     *            characters.
     * @throws NumberFormatException if the string is more than 16 characters
     * long, or if any character is not in the set [0-9a-fA-f].
     **/

    /* I know, you're thinking Brandon, why don't you use Long.valueOf(hex,
       16). Well, because Long.toHexString() generates unsigned values and
       Long.valueOf expects a signed value. So if you know the elegant way 
       to do this, please tell me. It's one line in C and Python. 
       -- More sane version -sgm
       -- moved to here - oskar
    */
    public static long stringToLong(String hex) throws NumberFormatException {
	long l=0;
	char c;

	int len=hex.length();

	if (len > 16)
	    throw new NumberFormatException();
	
	for (int i=0; i<len; i++) {
	    l<<=4;
	    c=hex.charAt(i);
	    if (c>='0' && c<='9') l+=(c-'0');
	    else if (c>='a' && c<='f') l+=(c-'a'+10);
	    else if (c>='A' && c<='F') l+=(c-'A'+10);
	    else throw new NumberFormatException();
	}
	return l;
    }

    /**
     * Converts an unsigned long into a hex String. Equivalent to Long.toHexString().
     *
     * @param l the unsigned long value to convert.
     * @returns A hex String.
     **/
    public static String longToString(long l) {
	return Long.toHexString(l);
    }

    /**
     * Finds the boolean value of the field, by doing a caseless match
     * with the strings "true" and "false".
     * @param s   The string
     * @param def The default value if the string can't be parsed. If the default
     *            is true, it checks that the
     *            string is not "false"; if it is false, it checks whether
     *            the string is "true".
     * @returns the boolean field value or the default value if the field value
     * couldn't be parsed.
     **/
    /* wooo, rocket science! (this is purely abstraction people) */
    public static boolean stringToBool(String s, boolean def) {
	return def ? !s.equalsIgnoreCase("false") : s.equalsIgnoreCase("true");
    }

    /**
     * Converts a boolean to a String of either "true" or "false".
     *
     * @param b the boolean value to convert.
     * @returns A "true" or "false" String.
     */
    public static String  boolToString(boolean b) {
	return b ? "true" : "false";
    }


    /**
     * Converts a String of hex characters into an array of bytes.
     * @param s A string of hex characters (upper case or lower) of
     *          even length.
     * @param out  A byte array of length at least s.length()/2 + off
     * @param off  The first byte to write of the array
     **/
    public static void hexToBytes(String s, byte[] out, int off) 
        throws NumberFormatException, IndexOutOfBoundsException {

        if ((s.length() % 2) != 0) {
            throw new NumberFormatException();
        }
        if (out.length < s.length()/2 + off) {
            throw new IndexOutOfBoundsException();
        }
        byte b;
        for (int i=0; i < s.length(); i++) {
            char c = s.charAt(i);
            if (!((c >= 'A' && c <= 'F') ||
                  (c >= 'a' && c <= 'f') ||
                  (c >= '0' && c <='9')))
                throw new NumberFormatException();
            b = (byte) (c >= 'A' && c <='F' ? 
                        c - 'A' + 10 : 
                        (c >= 'a' && c <= 'f' ? 
                         c - 'a' + 10 :
                         c - '0'));

            if (i%2 == 0) {
                out[off + i/2] = (byte) (b << 4);
            } else {
                out[off + (i-1)/2] = (byte) (out[off + (i-1)/2] | b);
            }
        }
    }

    /**
     * Converts a byte array into a string of upper case hex chars.
     * @param bs      A byte array
     * @param offset  The index of the first byte to read
     * @param length  The number of bytes to read.
     * @returns the string of hex chars.
     **/
    public static String bytesToHex(byte[] bs, int off, int length) {

        StringBuffer sb = new StringBuffer();
        for (int i = off; i < (off + length) && i < bs.length; i++) {
            char c1, c2;
                
            c1 = (char) ((bs[i] >>> 4) & 0xf);
            c2 = (char) (bs[i] & 0xf);
            c1 = (char) ((c1 > 9) ? 'a' + (c1 - 10) : '0' + c1);
            c2 = (char) ((c2 > 9) ? 'a' + (c2 - 10) : '0' + c2);
            sb.append(c1);
            sb.append(c2);
        }
        return sb.toString();
    }

}







