package Freenet.support;
import Freenet.Core;
import java.io.*;

/**
 * A file Bucket is an implementation of Bucket that writes to a file.
 * 
 * @author oskar
 **/
public class FileBucket implements Bucket {

    protected File file;
    protected boolean restart = true;
    protected boolean newFile;	// hack to get around deletes

    protected static String tempDir = null;

    /**
     * Creates a new FileBucket.
     * @param file  The File to read and write to.
     **/
    public FileBucket(File file) {
	this.file = file;
	this.newFile = false;
    }

    /**
     * Creates a new FileBucket in a random temporary file in the temporary directory.
     */

    public FileBucket() {
	file = new File(tempDir, "t" + Fields.longToString(Math.abs(Core.randSource.nextInt())));
	newFile = true;
        OnExitCleanUp.deleteOnExit(file);
    }

    public OutputStream getOutputStream() throws IOException {
	boolean append = !restart;
	restart = false;
	return new FileOutputStream(file.getPath(),append);
    }

    public InputStream getInputStream() throws IOException {
	return (file.exists() ?
		new FileInputStream(file) :
		null);
    }

    public void resetWrite() {
	restart = true;
    }

    public long size() {
	return file.length();
    }

    /**
     * Returns the file object this buckets data is kept in.
     **/
    public File getFile() {
	return file;
    }

    public void finalize() throws Throwable
    {
	if(newFile && file.exists()) {
	    Core.logger.log(this, "Deleting bucket "+file.getName(), Logger.DEBUGGING);
	    if(!file.delete()) {
		Core.logger.log(this, "Delete failed on bucket "+file.getName(), Logger.MINOR);
	    }
	}
    }

    // determine the temp directory in one of several ways

    static {
	// Try the Java property (1.2 and above)
	tempDir = System.getProperty("java.io.tmpdir");

	// Deprecated calls removed.

	// Try TEMP and TMP
	//	if (tempDir == null) {
	//	    tempDir = System.getenv("TEMP");
	//	}

	//	if (tempDir == null) {
	//	    tempDir = System.getenv("TMP");
	//	}

	// make some semi-educated guesses based on OS.

	if (tempDir == null) {
	    String os = System.getProperty("os.name");
	    if (os != null) {

		String[] candidates = null; 

		// XXX: Add more possible OSes here.
		if (os.equalsIgnoreCase("Linux")) {
		    String[] linuxCandidates = { "/tmp", "/var/tmp" };
		    candidates = linuxCandidates;
		} else if (os.equalsIgnoreCase("Windows")) {
		    String[] windowsCandidates = { "C:\\TEMP", "C:\\WINDOWS\\TEMP" };
		    candidates = windowsCandidates;
		}

		if (candidates != null) {
		    for (int i = 0; i < candidates.length; i++) {
			File path = new File(candidates[i]);
			if (path.exists() &&
			    path.isDirectory() &&
			    path.canWrite())
			{
			    tempDir = candidates[i];
			    break;
			}
		    }
		}
	    }
	}

	// last resort -- use current working directory

	if (tempDir == null) {
	    // This can be null -- but that's OK, null => cwd for File constructor, anyways.
	    tempDir = System.getProperty("user.dir");
	}
    }
}
