package Freenet.support;

import java.io.*;
import java.util.*;
import java.text.*;


/**
 * Logs messages using HTML markup.
 */
public class HtmlLogger extends StandardLogger {
    /**
     * Create a Logger to append to the given file. If the file does not
     * exist it will be created.
     *
     * @param filename  the name of the file to log to.
     * @param verb      The verbosity setting.
     * @param thresh    The lowest priority to print.
     * @exception IOException if the file couldn't be opened for append.
     */
    public HtmlLogger(String filename, int verb,
		      int thresh) throws IOException {
	super(filename, verb, thresh);
    }
    
    /**
     * Create a Logger to send log output to the given OutputStream.
     *
     * @param stream the OutputStream to send log output to.
     * @param verb   The verbosity setting.
     * @param thresh    The lowest priority to print.
     * @exception    IOException if a PrintStream could not be 
     *               attached to the given OutputStream.
     */
    public HtmlLogger(OutputStream stream, int verb,
			  int thresh) throws IOException {
	super(stream, verb, thresh);
    }
    
    /**
     * Create a Logger to send log output to the given PrintStream.
     *
     * @param stream the PrintStream to send log output to.
     * @param verb   The verbosity setting.
     * @param thresh    The lowest priority to print.
     */
    public HtmlLogger(PrintStream stream, int verb, int thresh) {
	super(stream, verb, thresh);
    }
  
    /**
     * Log a message
     * @param source  The source object where this message was
     *                 generated
     * @param message A clear and verbose message describing the event
     * @param priority The priority of the mesage, one of Logger.ERROR,
     *                 Logger.NORMAL, Logger.MINOR, or Logger.DEBUGGING.
     **/
    public void log(Object source, String message, int priority)
    { 
	// At a later date this could be enhanced with a hack employing
	// the exception traceback mechanism to give details of line number
	// and class automatically
	if (priority >= threshold) {
	    String pri = priorityOf(priority);
	    if (pri == null)
		pri = "";
	    String str = "";
	    if (verbosity > DETAILED)
		str += df.format(new Date()) + ":";
	    if (verbosity > SPARSE)
		str += source == null ? "" : source.getClass().getName() + ":";
	    if (verbosity > COMPLETE) 
		str += source == null ? "" : source.hashCode() + ":";
	    if (verbosity > SPECIFIED)
		str += pri + ":";
	    str += message;

	    // set color
	    String color = "black";
	    if (priority == Logger.ERROR)     { color = "red";   }
	    if (priority == Logger.NORMAL)    { color = "blue";  }
	    if (priority == Logger.MINOR)     { color = "black"; }
	    if (priority == Logger.DEBUGGING) { color = "green"; }
	    lout.print("<font color=\"" + color + "\">");

	    if (verbosity > LOUD ||
		(verbosity > COMPLETE && (priority >= Logger.ERROR))) {
		lout.println("<pre>");
		lout.flush();
		(new Exception(str)).printStackTrace(lout);
		lout.print("</pre>");
	    } else {
		lout.print(str);
	    }
	    lout.println("</font><br>");
	    lout.flush();
	}
    }
}



