package Freenet.support;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.

  Explanation of Code Versions: 
    0.0.0      = Initial Description
    0.0.1      = API Specified
    0.x (x>0)  = Partial Implementation
    x.0 (x>0)  = Operational
		
  Requires Classes: Class (version)
                    Class (version)
                    ...
 */

/**
 * This class represents a binary tree of limited size which uses integers
 * as keys.  If the tree is full and a new value is added, then the oldest
 * value is removed.
 *
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 **/

public class LimitedBinaryTree extends BinaryTree
{
  protected CyclicArray ca;

  /**
   * Constructs a LimitedBinaryTree with the given maximum size.
   *
   * @param size the maximum number of key/value pairs allowable in
   * this LimitedBinaryTree.
   */

  public LimitedBinaryTree(int size)
    {
      super();
      ca = new CyclicArray(size);
    }

  /**
   * Add the given key/value pair to this LimitedBinaryTree. If this tree
   * is already full, then the key/value pair most distantly added to this
   * tree is quietly deleted before adding the new key/value pair.
   *
   * @param key the key to put
   * @param value the value associated with the key to put
   *
   */
  public void put(long key, Object data)
    {
      Long prev = (Long) ca.put(new Long(key));
      if (prev != null)
	{
	  super.delete(prev.longValue());
	}   
      super.put(key, data);
    }

  /**
   * Remove the given key from this LimitedBinaryTree. The tree is unchanged if the
   * key wasn't present.
   *
   * @param key the key to remove
   */
  public void delete(long key)
    {
      for(int x=0; x<ca.length(); x++)
	{
          Long l=(Long)ca.get(x);
          if(l!=null)
	    if (l.intValue() == key)
	    {
	      ca.remove(x);
	    }
	}
      super.delete(key);
    }
}

