package Freenet.support;
import Freenet.Core;
import java.io.PrintStream;

/**
 * A class which can log messages to an OutputStream. All members of this class
 * are static; there is only one Logger.
 */
public abstract class Logger
{

    /**
     * The old log call. Please use the nonstatic log(Object,String, int)
     * on a real implementation instead.
     * deprecated Use the nonstatic call instead.
     **/
    // I had to remove this because Core.logger.log(null,string,int) ended up
    // here instead of below (duh).
    /*   public static void log(String file, String message, int priority) {
	 Core.logger.log(null,file + " - " + message,priority);
	 Core.logger.log(null,"Using deprecated log method, please fix!",
	 Logger.ERROR);
    }
    */

    /** These indicate the verbosity levels for calls to log() **/
    
    /** This message indicates an error which prevents correct functionality**/
    public static int ERROR = 3;
    /** A normal level occurance **/
    public static int NORMAL = 2;
    /** A minor occurance that wouldn't normally be of interest **/
    public static int MINOR = 1;
    /** An occurance which would only be of interest during debugging **/
    public static int DEBUGGING = 0;
    public static int DEBUG = DEBUGGING;
  
    public int verbosity;
    public int threshold;

    /**
     * Log a message
     * @param source   The source object where this message was generated
     * @param message A clear and verbose message describing the event
     * @param priority The priority of the mesage, one of Logger.ERROR,
     *                 Logger.NORMAL, Logger.MINOR, or Logger.DEBUGGING.
     **/
    public abstract void log(Object source, String message, int priority);

    /**
     * Returns a stream to which general data (such as exception stacktraces
     * can be written to this logger).
     */
    public abstract PrintStream getOut();

    /**
     * Set the stream which the logger writes to.
     */
    public abstract void setOut(PrintStream newout);
}










