package Freenet.support;
import Freenet.MessageObject;

/**
 * A simple linked Queue for delaying message handeling
 */

public class MessageQueue {

    private Container first;
    private Container last;
    public int limit;       // java 1.1 compatibility hack -- removed final
    private int size = 0;
    /**
     * Create a new MessageQueue
     * @param limit  The maximum number of messages to hold in the queue, 
     *               when this is full new messages will be lost.
     */
    public MessageQueue(int limit) {
	this.limit = limit;
    }

    /**
     * Add a MessageObject to the queue.
     * @param  mo  The MessageObject to add last.
     * @exception IndexOutofBoundsException if the queue is full.
     */
    public void enqueue(MessageObject mo) {
	if (size == limit) {
	    throw new IndexOutOfBoundsException("MessageQueue full");
	} else {
	    Container newc = new Container(mo);
	    if (last != null)
		last.next = newc;
	    last = newc;
	    if (first == null)
		first = newc;
	    size++;
	}
    }

    /**
     * Take a MessageObject off the queue.
     * @return  The first MessageObject. Null if the queue is empty.
     */
    public MessageObject dequeue() {
	if (size == 0) {
	    return null;
	} else {
	    Container ret = first;
	    first = first.next;
	    size--;
	    return ret.mo;
	}
    }

    /**
     * Whether the queue is empty.
     * @return Whether the queue is empty.
     */
    public boolean isEmpty() {
	return size == 0;
    }

    /**
     * The size of the queue.
     * @return  The size of the queue.
     */
    public int size() {
	return size;
    }
    
    private class Container {
	public Container(MessageObject mo) {
	    this.mo = mo;
	}
	public Container next;
	public MessageObject mo;
    }
}
