package Freenet.support;

import java.io.File;
import java.util.Vector;
import java.util.Enumeration;

/**
 * This class replaces File.deleteOnExit() to allow us to support JDK1.1.
 *
 * @author Stephen Blackheath
 */
public class OnExitCleanUp
{
  private static Vector thingsToDelete = new Vector();

  /**
   * Call this when you have a file that you would like cleaned up on
   * program exit.
   */
  public static void deleteOnExit(File file)
  {
    thingsToDelete.addElement(file);
  }

  /**
   * Call this method when the program exits to perform the cleanup.
   */
  public static void doCleanUp()
  {
    Enumeration enum = thingsToDelete.elements();
    while (enum.hasMoreElements())
	((File)enum.nextElement()).delete();

    thingsToDelete.removeAllElements();
  }
}
