package Freenet.support;
import java.io.*;

public class PipedBucket implements Bucket
{
    public PipedInputStream in;
    public PipedOutputStream out;

    static public void main(String[] args) throws IOException
    {
      PipedBucket pb=new PipedBucket();
      InputStream i=pb.getInputStream();
      OutputStream o=pb.getOutputStream();
      BufferedReader br=new BufferedReader(new InputStreamReader(i));
      PrintWriter pw=new PrintWriter(o);
      pw.println("hi");
      pw.flush();
      String s=br.readLine();
      System.out.println(s);
    }

    public PipedBucket()
    {
      in=new PipedInputStream();
      try { out=new PipedOutputStream(in); }
      catch(IOException e) {out=null;}
    }

    /**
     * Returns an OutputStream that is used to put data in this Bucket.
     **/
    public OutputStream getOutputStream() {return out;}

    /**
     * Returns an InputStream that reads data from this Bucket. If there is
     * no data in this bucket, null is returned.
     **/
    public InputStream getInputStream() {return in;}

    /**
     * If resetWrite() is called on the object, the next getOutputStream
     * should overwrite any other data in the bucket from the beginning,
     * otherwise it should append it.
     **/
    public void resetWrite()
    {
      in=new PipedInputStream();
      try { out=new PipedOutputStream(in); }
      catch(IOException e) {out=null;}
    }

    /**
     * Returns the amount of data currently in this bucket.
     **/
    public long size() {return -1;}

}
