package Freenet.support;

import java.io.Serializable;
import java.util.*;
import java.io.*;
import Freenet.Core;
import Freenet.support.Logger;

/**
 * @author <a href=mailto:blanu@uts.cc.utexas.edu>Brandon Wiley</a>
 **/

public class PriorityHashtable implements Serializable
{
  int size;
  int maxSize;
  Object[] array;
  Hashtable refs, data;

  static public void main(String[] args) throws IOException
  {
    PriorityHashtable ph=new PriorityHashtable(10);
    ph.put("a", new Hashtable());
    ph.print();
    System.out.println(ph.get("a"));
  }

  public PriorityHashtable(int maxSize)
    {
      size=0;
      this.maxSize=maxSize;
      array=new Object[maxSize];
      refs=new Hashtable(maxSize);
      data=new Hashtable(maxSize);
    }

  /**
   * Obtain the length of this LinkedList
   * @return Length of array
   **/
  public int length()
    {
      return size;
    }

  public void put(Object key, Object value)
    {
      Core.logger.log(this, "adding "+key+":"+value+" ("+size+"/"+(maxSize-1)+")", Logger.DEBUGGING);
      Object o=data.get(key);
      if(o!=null) return;
      trim();
      array[size]=key;
      data.put(key, value);
      Integer ref=new Integer(size);
      refs.put(key, ref);
      ++size;
    }

  public Object get(Object key)
  {
    return data.get(key);
  }

  public void promote(Object o)
  {
    System.out.println("promoting "+o);
    Object temp;
    Integer i=(Integer)refs.get(o);
    System.out.println("ref is "+i);
    if(i==null) return;
    int x=i.intValue();
    if(x==0) return;
    if(array[x]!=null && array[x-1]!=null)
    {
      refs.remove(array[x]);
      refs.remove(array[x-1]);

      temp=array[x-1];
      array[x-1]=array[x];
      array[x]=temp;

      refs.put(array[x], new Integer(x));
      refs.put(array[x-1], new Integer(x-1));
    }
  }

  public void trim()
  {
    if(size<maxSize) return;
    Object key=array[maxSize-1];
    data.remove(key);
    refs.remove(key);
    --size;
  }

  public void print()
  {
    Enumeration iterator=elements();
    while(iterator.hasMoreElements())
    {
      Object key=iterator.nextElement();
      System.out.println(key+" - "+data.get(key));
    }
  }

  public Enumeration elements()
  {
    return new PriorityEnumeration();
  }

  private class PriorityEnumeration implements Enumeration
  {
    int i;

    public PriorityEnumeration()
    {
      i=0;
    }

    public boolean hasMoreElements()
    {
      return i<=size-1;
    }

    public Object nextElement()
    {
      return array[i++];
    }
  }
}

