package Freenet.support;
import java.io.*;
import java.util.*;
import java.text.*;

public class StandardLogger extends Logger {
    /** Verbosity levels **/
    /**
     * "date:class:hashcode:priority:message"
     * and StackTrace on all
     **/
    public static int TRACE = 7;
    /**
     * "date:class:hashcode:priority:message" 
     * and print StackTrace on error
     **/
    public static int LOUD = 5;
    /** "date:class:priority:message" **/
    public static int COMPLETE = 4;
    /** "class:priority:message" **/
    public static int DETAILED = 3;
    /** "class:message" **/
    public static int SPECIFIED = 2;
    /** "message" **/
    public static int SPARSE = 1;
  
    protected static DateFormat df = DateFormat.getDateTimeInstance();

    /**
     * The printstream the StandardLogger writes too.
     **/
    public PrintStream lout;


    /**
     * Create a Logger to append to the given file. If the file does not
     * exist it will be created.
     *
     * @param filename  the name of the file to log to.
     * @param verb      The verbosity setting.
     * @param thresh    The lowest priority to print.
     * @exception IOException if the file couldn't be opened for append.
     */
    public StandardLogger(String filename, int verb, 
			  int thresh) throws IOException {
	lout = new PrintStream(new FileOutputStream(filename, true));
	this.verbosity = verb;
	this.threshold = thresh;
    }
    
    /**
     * Create a Logger to send log output to the given OutputStream.
     *
     * @param stream the OutputStream to send log output to.
     * @param verb   The verbosity setting.
     * @param thresh    The lowest priority to print.
     * @exception    IOException if a PrintStream could not be 
     *               attached to the given OutputStream.
     */
    public StandardLogger(OutputStream stream, int verb,
			  int thresh) throws IOException {
	lout = new PrintStream(stream);
	this.verbosity = verb;
	this.threshold = thresh;
    }
    
    /**
     * Create a Logger to send log output to the given PrintStream.
     *
     * @param stream the PrintStream to send log output to.
     * @param verb   The verbosity setting.
     * @param thresh    The lowest priority to print.
     */
    public StandardLogger(PrintStream stream, int verb, int thresh) {
	lout = stream;
	this.verbosity = verb;
	this.threshold = thresh;
    }
  
    /**
     * Log a message
     * @param source  The source object where this message was
     *                 generated
     * @param message A clear and verbose message describing the event
     * @param priority The priority of the mesage, one of Logger.ERROR,
     *                 Logger.NORMAL, Logger.MINOR, or Logger.DEBUGGING.
     **/
    public void log(Object source, String message, int priority)
    { 
	// At a later date this could be enhanced with a hack employing
	// the exception traceback mechanism to give details of line number
	// and class automatically
	if (priority >= threshold) {
	    String pri = priorityOf(priority);
	    if (pri == null)
		pri = "";
	    String str="";
	    if(verbosity> DETAILED)
		str += df.format(new Date()) + ":";
	    if(verbosity > SPARSE)
		str += source == null ? "" : 
		source.getClass().getName() + ":";
	    if (verbosity > COMPLETE) 
		str += source == null ? "" : source.hashCode() + ":";
	    if(verbosity > SPECIFIED)
		str += pri + ":";
	    str += message;

	    if (verbosity > LOUD || (verbosity > COMPLETE 
				     && (priority >= Logger.ERROR))) {
		(new Exception(str)).printStackTrace(lout);
	    } else {
		lout.println(str);
		lout.flush();
	    }
	}
    }

    public PrintStream getOut() {
	return lout;
    }

    public void setOut(PrintStream newout) {
	lout = newout;
    }

    /**
     * Returns the priority level matching the string. If no priority
     * matches, Logger.NORMAL is returned.
     * @param s  A string matching one of the logging priorities, case
     *           insensitive.
     **/
    public static int priorityOf(String s) {
	if (s.equalsIgnoreCase("error"))
	    return Logger.ERROR;
	else if (s.equalsIgnoreCase("normal"))
	    return Logger.NORMAL;
	else if (s.equalsIgnoreCase("minor"))
	    return Logger.MINOR;
	else if (s.equalsIgnoreCase("debugging"))
	    return Logger.DEBUGGING;
	else if (s.equalsIgnoreCase("debug"))
	    return Logger.DEBUGGING;
	else 
	    return Logger.NORMAL;
    }

    /**
     * Returns the name of the priority matching a number, null if none do
     */
    public static String priorityOf(int priority) {
	String pri = null;
	if (priority == Logger.ERROR)
	    pri = "Error";
	if (priority == Logger.NORMAL)
	    pri = "Normal";
	if (priority == Logger.MINOR)
	    pri = "Minor";
	if (priority == Logger.DEBUGGING)
	    pri = "Debug";
	return pri;
    }

}



