package Freenet.support;

import java.util.*;

/**
 * A bunch of nifty utilities for Strings.
 *
 * @author <a href=mailto:blanu@uts.cc.utexas.edu>Brandon Wiley</a>
 **/

public class StringUtils
{
  /**
   * A test main method. It will perform a {@ref #split split} on the
   * first argument and print out the result, which is a Vector.
   */
  static public void main(String[] args)
  {
    System.out.println(StringUtils.split(args[0],'.'));
  }

  /**
   * Split a String at the delimiter.
   *
   * @param path the String to split.
   * @param delim the delimiter character to split at.
   * @returns a Vector of Strings consisting of the tokens
   * between the delimiters in the original String. The Vector
   * will be empty if the original String is null or has zero length.
   */

  static public Vector split(String path, char delim)
  {
  int i;
  Vector parts=new Vector();

  if(path==null) return parts;
  while(path.length()>0)
   {
    i=path.indexOf(delim);
    if(i==-1)
    {
      parts.addElement(path);
      break;
    }
    else
    {
      parts.addElement(path.substring(0,i));
      path=path.substring(i+1);
    }
   }
   return parts;
  }
}


