package Freenet.support;
import java.util.*;
import Freenet.node.*;

/*
TODO:
  Test this properly
  Make this serialisable so that it can be saved to disk
  Improve method of incorporating new information to take into-account
    previous information (giving more weight to information gathered
    while transferring longer files)
 */

/**
 * Allows information about throughput performance of other nodes to be
 * recorded for future use.
 **/

public class ThroughputTracker
{
    Hashtable data = new Hashtable();

    public static final int SEND = 0;
    public static final int RECEIVE = 1;

    /**
     * Record information about a given address
     * @param address The address to which this information applies
     * @param bytes The number of bytes transferred
     * @param seconds The number of seconds required to transfer the information
     * @param direction SEND or RECEIVE
     **/
    public void recordInf(String address, int bytes, float seconds, int direction)
    {
	TPinf tp;
	if ((tp = ((TPinf) data.get(address))) == null)
	    {
		tp = new TPinf();
	    }
	if (direction == SEND)
	    {
		// Disregard data for less than 5k unless this
		// is all we have to go on
		if ((tp.send != 0) && (bytes < 5000))
		    return;
		tp.send = (float) bytes / seconds;
	    }
	else
	    {
		if ((tp.receive != 0) && (bytes < 5000))
		    return;
		tp.receive = (float) bytes / seconds;
	    }
    }

    /**
     * Get the recorded speed of a connection to an address in a given
     * direction.  If no information is available then calculate
     * the average speed for that direction and use it.
     *
     * @param address The address for which information is sought
     * @param direction SEND or RECIEVE
     **/
    public float getInf(String address, int direction)
    {
	TPinf tp = ((TPinf) data.get(address));
	if ((tp == null) || ((direction == SEND) && (tp.send == 0))
	    || ((direction == RECEIVE) && (tp.receive == 0)))
	    {
		float ttl = 0;
		float no = 0;
		TPinf t;
		if (direction == SEND)
		    { // Must calculate an average
			for (Enumeration e = data.elements() ; e.hasMoreElements() ;)
			    {
				t = (TPinf) e.nextElement();
				if (t.send != 0)
				    {
					no++;
					ttl += t.send;
				    }
			    }
			tp.send = ttl / no;
		    }
		else
		    {
			for (Enumeration e = data.elements() ; e.hasMoreElements() ;)
			    {
				t = (TPinf) e.nextElement();
				if (t.receive != 0)
				    {
					no++;
					ttl += t.receive;
				    }
			    }
			tp.receive = ttl / no;
			
		    }
	    }
	if (direction == SEND)
	    {
		return tp.send;
	    }
	else
	    {
		return tp.receive;
	    }
    }

    /**
     * Removes information about nodes which are no-longer
     * referenced in the datastore.
     **/
    public void cleanUp(StandardDataStore ds)
    {
	Hashtable ht = ds.refList();
	Object t;
	for (Enumeration e = data.keys(); e.hasMoreElements();)
	    {
		t = e.nextElement();
		if (ht.get(t) == null)
		    {
			ht.remove(t);
		    }
	    }
	
    }
}

class TPinf
{
    /** The sending throughput in bytes/sec **/
    public float send = 0;
    /** The receiving throughput in bytes/sec **/
    public float receive = 0;
}
