package Freenet.support.io;
import Freenet.support.ByteCounter;
import Freenet.support.Callback;
import java.io.*;

/**
 * An InputStream that counts the number of bytes that have been read.
 */

public class CounterFilterInputStream extends FilterInputStream {
	private ByteCounter c;

        /**
         * Constructs a CounterFilterInputStream.
         *
         * @param in the InputStream to count bytes read from.
         * @param c a ByteCounter which will count the bytes.
         */
        
	public CounterFilterInputStream(InputStream in, ByteCounter c)
	{
		super(in);
		this.c = c;
	}


        /**
         * Reads the next byte of data from this input stream. The value byte is returned
         * as an int in the range 0 to 255. If no byte is available because the end of the 
         * stream has been reached, the value -1 is returned.
         * This method blocks until input data is available, the end of the stream is 
         * detected, or an exception is thrown. 
         *
         * @returns the next byte of data, or -1 if the end of the stream is reached.
         * @throws IOException if an I/O error occurs. 
         */
        
	public int read() throws IOException
	{
		int result = super.read();
		if (result != -1)
			c.count(1);
		else
		    c.finished();
		return result;
	}
        
        /**
         * Reads up to byte.length bytes of data from this input stream into 
         * an array of bytes. This method blocks until some input is available. 
         *
         * @param b the buffer into which the data is read.
         * @returns the total number of bytes read into the buffer, or -1 if there is
         * no more data because the end of the stream has been reached.
         * @throws IOException if an I/O error occurs. 
         */

	public int read(byte[] b) throws IOException
	{
		int result = super.read(b);
		if (result != -1)
			c.count(result);
		else
		    c.finished();
		return result;
	}

        /**
         * Reads up to len bytes of data from this input stream into an array of bytes.
         * This method blocks until some input is available. 
         *
         * @param b the buffer into which the data is read.
         * @param off the start offset of the data.
         * @param len the maximum number of bytes read.
         * @returns the total number of bytes read into the buffer, or -1 if there is
         * no more data because the end of the stream has been reached.
         * @throws IOException if an I/O error occurs. 
         */
        
	public int read(byte b[],int off,int len) throws IOException
	{
		int result = super.read(b,off,len);
		if (result != -1)
			c.count(result);
		else
		    c.finished();
		return result;
	}
}
