package Freenet.support.io;
import Freenet.support.ByteCounter;
import Freenet.support.Callback;
import java.io.*;

/**
 * An OutputStream that counts the number of bytes that have been written.
 */
public class CounterFilterOutputStream extends FilterOutputStream {
	private ByteCounter c;

        /**
         * Constructs a CounterFilterOutputStream.
         *
         * @param out the OutputStream to count bytes written to.
         * @param c a ByteCounter which will count the bytes.
         */
        
	public CounterFilterOutputStream(OutputStream out, ByteCounter c)
	{
		super(out);
		this.c = c;
	}

        /**
         * Writes the specified byte to this output stream. 
         *
         * @param i the byte.
         * @throws IOException if an I/O error occurs.
         */
        
	public void write(int i) throws IOException
	{
		super.write(i);
		c.count(1);
	}

        /**
         * Writes b.length bytes to this output stream.  
         *
         * @param b the data to be written.
         * @throws IOException if an I/O error occurs.
         */
        
	public void write(byte[] b) throws IOException
	{
		super.write(b);
		c.count(b.length);
	}

        /**
         * Writes <code>len</code> bytes from the specified byte array 
         * starting at offset <code>off</code> to this output stream.  
         *
         * @param b the data to be written.
         * @param off the start offset in the data.
         * @param len the number of bytes to write.
         * @throws IOException if an I/O error occurs.
         */
        
	public void write(byte[] b, int first, int len) throws IOException
	{
		super.write(b,first,len);
		c.count(len);
	}
}
