package Freenet.support.io;
import Freenet.support.ByteCounter;
import Freenet.support.Callback;
import java.io.*;

/**
 * An output stream which counts the number of bytes written to it. The data
 * written to this output stream doesn't actually go anywhere; it's just
 * counted. This output stream implements the {@ref Callback Callback}
 * interface so that it can be called back. Calling this output stream back
 * causes its {@ref ByteCounter ByteCounter}'s finished method to be called.
 *
 * @see CounterFilterOutputStream
 */
public class CounterOutputStream extends OutputStream implements Callback {
    ByteCounter c;

        /**
         * Constructs a CounterOutputStream.
         *
         * @param c a ByteCounter which will count the bytes.
         */
        
    public CounterOutputStream(ByteCounter c) {
	this.c = c;
    }

        /**
         * Writes the specified byte to this output stream. 
         *
         * @param i the byte.
         */
        
    public void write(int i) {
	c.count(1);
    }

        /**
         * Writes b.length bytes to this output stream.  
         *
         * @param b the data to be written.
         */
        
    public void write(byte[] b) {
	c.count(b.length);
    }

        /**
         * Writes <code>len</code> bytes from the specified byte array 
         * starting at offset <code>off</code> to this output stream.  
         *
         * @param b the data to be written.
         * @param off the start offset in the data.
         * @param len the number of bytes to write.
         */
        
    public void write(byte[] b, int first, int len) {
	c.count(len);
    }

    /**
     * Causes the counter to stop counting any more bytes.
     */
    
    public void callback() {
	c.finished();
    }

}
