package Freenet.support.io;

import java.io.*;
import Freenet.support.Logger;
import Freenet.Presentation;
import Freenet.Core;

public class PadOnErrorInputStream extends FilterInputStream {
    protected ControlInputStream parent;

    public PadOnErrorInputStream(InputStream in) {
	super(in);
    }

    public void setCIS(ControlInputStream cis) {
	parent = cis;
    }

    public int read() throws IOException {
	try {
	    int rv=in.read();
	    if (rv == -1) {
		goPadding(new EOFException());
		return read();
	    } else return rv;
	} catch (IOException e) {
	    goPadding(e);
	    return read();
	}
    }

    public int read(byte[] buff) throws IOException {
  	return read(buff, 0, buff.length);
    }
    
    public int read(byte[] buff, int off, int len) throws IOException {
  	try {
	    int rv=in.read(buff, off, len);
	    if (rv==-1) {
		goPadding(new EOFException());
		return read(buff, off, len);
	    } else return rv;
  	} catch (Exception e) {
	    goPadding(e);
	    return read(buff, off, len);
  	}	
    }
    
    protected void goPadding(Exception e) throws IOException {
	Core.logger.log(this, "Exception caught: "+e+
			" padding...", Logger.NORMAL);
	try {
	    in.close();
	} catch (IOException ie) {}
	in=new ZeroInputStream();
	if (parent != null)
	    parent.endWithNextControl(Presentation.CB_RESTARTED);
    }
	
    public void close() throws IOException {
  	in.close();
    }
    
    public int available() throws IOException {
  	return in.available();
    }
    
    public long skip(long bytes) throws IOException {
  	return in.skip(bytes);
    }

    class ZeroInputStream extends InputStream {
	protected boolean closed = false;

	public int read() throws IOException {
	    if (closed) throw new IOException("Stream closed");
	    return 0;
	}

	public int read(byte[] buff, int off, int len) throws IOException {
	    if (closed) throw new IOException("Stream closed");
	    for (int i=off; i<off+len; i++) {
		buff[i]=0;
	    }
	    return len;
	}

	public int available() {
	    return 32768;
	}
    }
}
