package Freenet.support.io;
import java.io.*;
import java.util.*;

/**
 * An OutputStream which sends every byte written to it to all OutputStreams
 * added to it.
 */

public class SplitOutputStream extends OutputStream {
    private Vector outputs;
    
    /**
     * Construct a SplitOutputStream.
     */

    public SplitOutputStream()
    {
	outputs = new Vector();
    }
    /**
     * Add an OutputStream to this SplitOutputStream.
     *
     * @param out the OutputStream to add.
     */
    
    public void addOutput(OutputStream out) {
	outputs.addElement(out);
    }
    
    /**
     * Write a single byte to all OutputStreams added to this SplitOutputStream.
     * The byte is written to the OutputStreams in the order in which they were
     * added. If there is an IOException on an OutputStream then its corresponding
     * Callback, if there is one, is called back, and that OutputStream is removed
     * from the list.
     *
     * @param c the byte to write.
     */

    public void write(int c) throws IOException {

	OutputStream current;
	int len = outputs.size();
	IOException toThrow = null;
	for(int x = 0 ; x < len ;) {
	    current=(OutputStream)outputs.elementAt(x);
	    try {
		current.write(c); 
		x++;
	    }
	    catch(IOException e) {
		outputs.removeElementAt(x); 
		len--;
		toThrow = e;
	    }
	}

	if (toThrow != null)
	    throw toThrow;
    }

    /**
     * Write an array of bytes to all OutputStreams added to this SplitOutputStream.
     * Note that this method simply calls write(c, 0, c.length).
     *
     * @param c the array of bytes to write.
     */
    public void write(byte[] c) throws IOException {
	write(c,0,c.length); 
    } 

    /**
     * Write an array of bytes to all OutputStreams added to this SplitOutputStream.
     * Note that this method calls write() multiple times.
     *
     * @param c the array of bytes to write.
     * @param offset the offset into the array at which to start.
     * @param length the number of bytes to write.
     */
    public void write(byte[] c,int offset,int length) throws IOException {
	OutputStream current;	
	int len = outputs.size();
	IOException toThrow = null;
	
	for (int x = 0 ; x<len ;) {
	    current=(OutputStream) outputs.elementAt(x);
	    try {
		current.write(c,offset,length); 
		x++;
	    }
	    catch(IOException e) {
		outputs.removeElementAt(x); 
		len--;
		toThrow = e;
	    }
	}

	if (toThrow != null)
	    throw toThrow;
    }


    /**
     * Close this SplitOutputStream. Closes and removes all OutputStreams which
     * have been added to this SplitOutputStream.
     */ 
    public void close() throws IOException {
	for (Enumeration e = outputs.elements() ; e.hasMoreElements() ; ) {
	    ((OutputStream)e.nextElement()).close();
	}
	outputs.removeAllElements();
	
    } 
}







