package Freenet.support.io;

import java.io.*;

/**
 * An InputStream which can time out when there is no data from the InputStream.
 */

public class TimeoutInputStream extends FilterInputStream {

    public static void main(String[] args) throws Exception {
	TimeoutInputStream tis = new TimeoutInputStream(new FileInputStream(args[0]));
	int i = 0, j;
	do {
	    i = tis.read();
	    System.out.print((char) i);
	} while (i != -1);
    }

    private class ReadThread extends Thread {
	private InputStream in;
	public ReadThread(InputStream in) {
	    super("InputStream reading thread for TimeoutInputStream");
	    this.in = in;
	}

	public void run() {
	    read: while (true) {
		if (!available) {
		    IOException ioe = null;
		    int i = -2;
		    try {
			i = in.read();
		    } catch (IOException e) {
			ioe = e;
		    }
		    synchronized (TimeoutInputStream.this) {
			if (ioe != null) {
			    readException = ioe;
			} else {
			    read = i;
			}
			available = true;
			TimeoutInputStream.this.notify();
			if (i == -1) // EOF
			    break read;
		    }
		}
		try {
		    sleep(1000);
		} catch (InterruptedException e) {}
	    }
	}
    }

    private int read;
    private volatile boolean available;
    private int timeOut = 0;
    private IOException readException = null;
    private ReadThread rt;

    /**
     * Construct a TimeoutInputStream using the given InputStream.
     *
     * @param in the InputStream to timeout on.
     */
    
    public TimeoutInputStream(InputStream in) {
	super(in);
	rt = new ReadThread(in);
	rt.start();
    }
    
    /**
     * Read a single byte from this TimeoutInputStream. Blocks until
     * a byte is available, the stream ends, or until the timeout
     * is reached, in which case an InterruptedIOException is thrown.
     *
     * @returns the byte read, or -1 on end-of-stream.
     * @throws IOException on I/O error from the InputStream.
     * @throws InterruptedIOException if waiting for a byte from
     * the InputStream timed out.
     */
    
    public synchronized int read() throws IOException {
	while (true) {
	    if (available) {
		if (readException != null) {
		    IOException e = readException;
		    readException = null;
		    available = false;
		    rt.interrupt();
		    throw e;
		} else {
		    int i = read;
		    if (i != -1) {
			available = false;
			rt.interrupt();
		    }
		    return i;
		}
	    } else {
		try {
		    wait(timeOut);
		} catch (InterruptedException e) {
		    throw new InterruptedIOException();
		}
	    }
	}
    }
    
    /**
     * Set the timeout value in milliseconds for this TimeoutInputStream.
     *
     * @param timeOut the timeout in milliseconds.
     */
    
    public void setTimeout(int timeOut) {
	this.timeOut = timeOut;
    }
}
