package Freenet.support.io;
import java.io.*;

/**
 * This class limits the length of the data on a stream to a specified length.
 * In other words, it makes a section of data on a stream with a specified length
 * look like an entire stream.  (Could it be named better?)
 */
public class VerifyingInputStream extends FilterInputStream {

    protected long dataLength, bytesRead;
    //    protected int last = -1;
    /** Whether the stream has finished **/
    protected boolean finished = false; 
    /** Whether impelementations should strip control 
	characters from output **/
    protected boolean stripControls = false;
    /** If stripControls is true, this will become yes after the second
	to last bytes is read. This is so as to notify implementations that
	only the final control char is left, so they can read, validate, and
	throw it out
    **/
    protected boolean allRead = false;

    public VerifyingInputStream(InputStream in, long length) {
	super(in);
	this.dataLength=length;
    }

    public void stripControls(boolean ns) {
	stripControls = ns;
    }

    public int read() throws IOException, DataNotValidIOException {
	return priv_read();
    }

    private int priv_read() throws IOException, DataNotValidIOException {
	int rv=super.read();
	if (rv!=-1) bytesRead++;
	if (!finished && bytesRead>=dataLength) {
	    finished = true;
	    //	    last=rv;
	    //System.out.write(last);
	    // System.err.println("Signal finish");
	    //	    finish();
	} else if (!finished && stripControls && bytesRead == dataLength -1) {
	    System.err.println("ALL READ");
	    allRead = true;
	}
	return rv;
    }

    public int read(byte[] b, int off, int length) throws IOException, DataNotValidIOException {
	return priv_read(b,off,length);
    }

    private int priv_read(byte[] b, int off, int length) throws IOException, DataNotValidIOException {
	int rv;
	if (finished) {
	    return -1;
	}

          // If this is the last byte, then just read a single byte.

	if (bytesRead == dataLength - 1) {

	    int i = priv_read();
	    if (i == -1)
		return -1;
	    b[off] = (byte) i;
	    rv = 1;

	} else {

	      // If the number of bytes requested is greater than what's
	      // supposed to be left (limited by dataLength), then only read up to
	      // that point.  In actual fact it reads only up to dataLength-1, not
	      // dataLength.  The case above handles that last byte.

	    if (!finished && (length > (dataLength - 1 - bytesRead)))
		length = (int)(dataLength - 1 - bytesRead);
	    rv=super.read(b, off, length);
	    if (rv!=-1) bytesRead+=rv;
	    if (stripControls && bytesRead == dataLength - 1) {
		allRead = true;
	    }
	}
	
	return rv;
    }

    public int available() throws IOException {

          // Lie about bytes available to ensure we don't overrun dataLength.

	  // Wait on!  If stripControls is true and there's only one byte left,
	  // then it'll return 0, right?  Shouldn't it return 1?

	int n = super.available();
	return (n + bytesRead >= dataLength ?
		(stripControls ?
		 (int) (dataLength - bytesRead - 1):
		 (int) (dataLength - bytesRead)) :
		n);
    }
}








