package Freenet.thread;

/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
*/

/**
 * A subclass of Runnable that will be informed of the
 * EThread that has this Runnable as a target once it is assigned
 * a thread.
 */
public interface ERunnable extends Runnable {

    /**
     * Called by an EThread when this ERunnable actually
     * gets a thread and begins executing.  This method will be called
     * just prior to the run method of the Runnable.
     *
     * @param e The EThread which has this Runnable as a target.
     */
    public void setExecutionInstance(EThread e);

}
