package Freenet.thread;

/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
*/

/**
 * Defines the interface for all thread-managers in the extended threads
 * package.  Currently, only thread-pool implements this interface.
 *
 * @author Scott G. Miller
 */
public interface ThreadManager {

    /**
     * Requests that this thread-manager run the given job (a class 
     * implementing the java.lang.Runnable interface).  The exact
     * manner in which the job is run is dependent on the ThreadManager
     * implementation.
     *
     * @param job The job to run
     * @return True if the job was accepted, false if the job cannot
     * be run (due possibly to the thread-manager having been halted).
     */
    public boolean run(Runnable job);

    /**
     * Requests that this thread-manager run the given job (a class 
     * implementing the java.lang.Runnable interface).  The exact
     * manner in which the job is run is dependent on the ThreadManager
     * implementation.
     * 
     * blockingRun() blocks until the job is actually queued, rather 
     * than returning false if it cannot be run.
     *
     * @param job The job to run
     */
    public void blockingRun(Runnable job);

    /**
     * Called by the E-Thread to return itself to this ThreadManager
     * after a completed job.
     *
     * @param e The E-Thread to return.
     */
    public boolean reclaim(EThread e);

    /**
     * Begins operation of this thread-manager.  Should be called
     * shortly after instantiation.
     */
    public void start();

    /**
     * Requests that this thread-manager cease its operations.  Any
     * running threads managed by this ThreadManager will continue
     * to run until completion, but no new jobs will run.  This should
     * probably be preceded by {@link #flush flush()}, otherwise pending jobs may be lost.
     */
    public void halt();

    /**
     * Blocks until all pending jobs have been assigned to threads.  
     * When this method returns, all the jobs that were given to this
     * thread-manager via the {@link #run(Runnable) run(Runnable)} method have either completed
     * or are in currently executing threads (i.e. all pending jobs *will*
     * be run).
     */
    public void flush();
}
    

