package Freenet.transport;
import Freenet.*;
import Freenet.ConnectException;    // we seem to have to import this
                                    // explicitly - why?
import Freenet.support.io.ThrottledOutputStream;
import Freenet.support.io.ThrottledInputStream;
import Freenet.support.Logger;
import java.io.*;
import java.net.*;

public class tcpConnection extends Connection {
    protected Socket sock=null;
    protected boolean privileged = false;
    
    private class ConnectThread extends Thread { 
	public boolean done;
	private boolean abandoned = false;
	public Exception exception = null;
	private tcpAddress tcpaddr;
	
	public ConnectThread(tcpAddress addr) {
	    super();
	    setName("tcpConnectThread");
	    tcpaddr=addr;
	}

	public void run() { 
	    try { 
		sock=new Socket(tcpaddr.host, tcpaddr.port); 
	    } catch(IOException e) { 
		sock = null;
		exception = e;
	    }	    
	    done=true;

	    if (sock != null && abandoned) {
		try {
		    sock.close();
		} catch (IOException e) {}
	    }
	}

	public void timedOut() {
	    abandoned = true;
	}
    }
    
    public String toString() {
	return getPeerAddress().toString();
    }

    public tcpConnection(tcpAddress addr) throws UnknownHostException,
	IOException, ConnectException
    {
      ConnectThread st = new ConnectThread(addr); 
      st.start();
      
      
      for (long r=0; r<Core.connectTimeout && !st.done; r+=100) {
	  try {
	      Thread.sleep(100); 
	  } catch(InterruptedException e) {
	      //interrupted is a good thing here
	      break;
	  }
      }

      if(sock==null) {
	  st.timedOut();
	  if (st.exception == null) {
	      throw new ConnectTimedOutException();
	  }
	  else {
	      // hm, would it be ok to throw st.exception directly?
	      throw new ConnectException(st.exception.toString());
	  }      
      }

      if (sock.getLocalAddress().equals(sock.getInetAddress())) {
	  Core.logger.log(this,
			  "not throttling local connection", Logger.DEBUG);
	  out = sock.getOutputStream();
	  in  = sock.getInputStream();
	  privileged = true;
      } else {
	  out = ThrottledOutputStream.throttledStream(sock.getOutputStream());
	  in  = ThrottledInputStream.throttledStream(sock.getInputStream());
      }
  }

  public tcpConnection(Socket sock) throws IOException {
      this.sock = sock;
      //      sock.setSoLinger(true, 0);
      if (sock.getLocalAddress().equals(sock.getInetAddress())) {
	  Core.logger.log(this,
			  "not throttling local connection", Logger.DEBUG);
	  out = sock.getOutputStream();
	  in  = sock.getInputStream();
	  privileged = true;
      } else {
	  out = ThrottledOutputStream.throttledStream(sock.getOutputStream());
	  in  = ThrottledInputStream.throttledStream(sock.getInputStream());
      }
  }

  public void close()
  {
    try { 
	in.close();
    } catch(Exception e) {}
    in=null;

    try {
	out.close();
    } catch(Exception e) {}
    out=null;

    try {
      sock.close(); 
    } catch(IOException e) {
	// It may have been closed remotely in which case
	// sock.close will throw an exception.  We really don't
	// care though.
      }
  }

    public void setSoTimeout(int timeout) throws IOException {
	if (sock != null)
	    sock.setSoTimeout(timeout);
	else
	    throw new IOException();
    }
    
    public int getSoTimeout() throws IOException {
	return sock.getSoTimeout();
    }

    public Address getMyAddress(ListeningAddress lstaddr)
    {
	return (sock == null)? null : 
	    new Address("tcp",
			new tcpAddress(sock.getLocalAddress(),
				       ((tcpListeningAddress)lstaddr.address).port));
    }

    public Address getMyAddress()
    {
	return (sock == null)? null :
	    new Address("tcp",
			new tcpAddress(sock.getLocalAddress(),
				       sock.getLocalPort()));
    }
    public Address getPeerAddress(ListeningAddress lstaddr)
    {
	return (sock == null)? null :
	    new Address("tcp",
			new tcpAddress(sock.getInetAddress(),
				       ((tcpListeningAddress)lstaddr.address).port));
    }
    public Address getPeerAddress()
    {
	return (sock == null)? null : 
	    new Address("tcp",
			new tcpAddress(sock.getInetAddress(),
				       sock.getPort()));
    }

    public boolean privileged() { return privileged; }
}
