/*
 * $Id: JPEG.xs,v 1.5 2001/07/11 20:43:05 ayla Exp $
 *
 * Modified from the libjpeg example 
 * Modifications Copyright(C) 1998 Tuomas J. Lukka
 * DISTRIBUTED WITH NO WARRANTY, EXPRESS OR IMPLIED.
 * See the license (the file COPYING in the FreeWRL
 * distribution) for details.
 *
 * $Log: JPEG.xs,v $
 * Revision 1.5  2001/07/11 20:43:05  ayla
 *
 *
 * Fixed problem with Plugin/Source/npfreewrl.c, so all debugging info. is turned
 * off.
 *
 * Committing merge between NetscapeIntegration and the trunk.
 *
 * Revision 1.4.8.1  2001/07/11 19:11:44  ayla
 *
 *
 * Made a proper sentence out of error message at line 150.
 *
 * Revision 1.4  2000/09/02 23:57:51  rcoscali
 * Implement the flipping of image directly in reading routine to avoid overhead of flipping after read. Flip occurs if a flip param is given to 1. It does not occur if 0.
 *
 */

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#undef LOCAL
#undef METHODDEF
#include "jpeglib.h"


#include <stdio.h>

#define RETVAL XXX_RETVAL

#include <setjmp.h>

/*
 * IMAGE DATA FORMATS:
 *
 * The standard input image format is a rectangular array of pixels, with
 * each pixel having the same number of "component" values (color channels).
 * Each pixel row is an array of JSAMPLEs (which typically are unsigned chars).
 * If you are working with color data, then the color values for each pixel
 * must be adjacent in the row; for example, R,G,B,R,G,B,R,G,B,... for 24-bit
 * RGB color.
 *
 */

extern JSAMPLE * image_buffer;	/* Points to large array of R,G,B-order data */
extern int image_height;	/* Number of rows in image */
extern int image_width;		/* Number of columns in image */

/******************** JPEG DECOMPRESSION SAMPLE INTERFACE *******************/

/* This half of the example shows how to read data from the JPEG decompressor.
 * It's a bit more refined than the above, in that we show:
 *   (a) how to modify the JPEG library's standard error-reporting behavior;
 *   (b) how to allocate workspace using the library's memory manager.
 *
 * Just to make this example a little different from the first one, we'll
 * assume that we do not intend to put the whole image into an in-memory
 * buffer, but to send it line-by-line someplace else.  We need a one-
 * scanline-high JSAMPLE array as a work buffer, and we will let the JPEG
 * memory manager allocate it for us.  This approach is actually quite useful
 * because we don't need to remember to deallocate the buffer separately: it
 * will go away automatically when the JPEG object is cleaned up.
 */


/*
 * ERROR HANDLING:
 *
 * The JPEG library's standard error handler (jerror.c) is divided into
 * several "methods" which you can override individually.  This lets you
 * adjust the behavior without duplicating a lot of code, which you might
 * have to update with each future release.
 *
 * Our example here shows how to override the "error_exit" method so that
 * control is returned to the library's caller when a fatal error occurs,
 * rather than calling exit() as the standard error_exit method does.
 *
 * We use C's setjmp/longjmp facility to return control.  This means that the
 * routine which calls the JPEG library must first execute a setjmp() call to
 * establish the return point.  We want the replacement error_exit to do a
 * longjmp().  But we need to make the setjmp buffer accessible to the
 * error_exit routine.  To do this, we make a private extension of the
 * standard JPEG error handler object.  (If we were using C++, we'd say we
 * were making a subclass of the regular error handler.)
 *
 * Here's the extended error handler struct:
 */

struct my_error_mgr {
  struct jpeg_error_mgr pub;	/* "public" fields */

  jmp_buf setjmp_buffer;	/* for return to caller */
};

typedef struct my_error_mgr * my_error_ptr;

/*
 * Here's the routine that will replace the standard error_exit method:
 */

METHODDEF(void)
my_error_exit (j_common_ptr cinfo)
{
  /* cinfo->err really points to a my_error_mgr struct, so coerce pointer */
  my_error_ptr myerr = (my_error_ptr) cinfo->err;

  /* Always display the message. */
  /* We could postpone this until after returning, if we chose. */
  (*cinfo->err->output_message) (cinfo);

  /* Return control to the setjmp point */
  longjmp(myerr->setjmp_buffer, 1);
}



MODULE = VRML::JPEG	PACKAGE = VRML::JPEG
PROTOTYPES: ENABLE

int
read_file(filename,sv,dep,hei,wi,flip)
	char *filename
	SV *sv
	int dep
	int hei
	int wi
	int flip
CODE:
for(;;) {
  /* This struct contains the JPEG decompression parameters and pointers to
   * working space (which is allocated as needed by the JPEG library).
   */
  struct jpeg_decompress_struct cinfo;
  /* We use our private extension JPEG error handler.
   * Note that this struct must live as long as the main JPEG parameter
   * struct, to avoid dangling-pointer problems.
   */
  struct my_error_mgr jerr;
  /* More stuff */
  FILE * infile;		/* source file */
  JSAMPARRAY buffer;		/* Output row buffer */
  int row_stride;		/* physical row width in output buffer */
  char *ptr;

  /* In this example we want to open the input file before doing anything else,
   * so that the setjmp() error recovery below can assume the file is open.
   * VERY IMPORTANT: use "b" option to fopen() if you are on a machine that
   * requires it in order to read binary files.
   */

  if ((infile = fopen(filename, "rb")) == NULL) {
    fprintf(stderr, "Can't open %s.\n", filename);
    RETVAL = 0; break;
  }
  /* We set up the normal JPEG error routines, then override error_exit. */
  cinfo.err = jpeg_std_error(&jerr.pub);
  /* XXX */
  /* jerr.pub.error_exit = my_error_exit; */
  /* Establish the setjmp return context for my_error_exit to use. */
  if (setjmp(jerr.setjmp_buffer)) {
    /* If we get here, the JPEG code has signaled an error.
     * We need to clean up the JPEG object, close the input file, and return.
     */
    jpeg_destroy_decompress(&cinfo);
    fclose(infile);
    RETVAL =  0; break;
  }
  /* Now we can initialize the JPEG decompression object. */
  jpeg_create_decompress(&cinfo);
  jpeg_stdio_src(&cinfo, infile);
  (void) jpeg_read_header(&cinfo, TRUE);
  /* Step 4: set parameters for decompression */
  /* In this example, we don't need to change any of the defaults set by
   * jpeg_read_header(), so we do nothing here.
   */
  /* Step 5: Start decompressor */
  (void) jpeg_start_decompress(&cinfo);
  /* We can ignore the return value since suspension is not possible
   * with the stdio data source.
   */
  /* We may need to do some setup of our own at this point before reading
   * the data.  After jpeg_start_decompress() we have the correct scaled
   * output image dimensions available, as well as the output colormap
   * if we asked for color quantization.
   * In this example, we need to make an output work buffer of the right size.
   */ 
  /* JSAMPLEs per row in output buffer */
  SvGROW(sv, cinfo.output_width*cinfo.output_height*cinfo.out_color_components);
  SvCUR_set(sv, cinfo.output_width*cinfo.output_height*cinfo.out_color_components);
  dep = cinfo.out_color_components;
  hei = cinfo.output_height;
  wi = cinfo.output_width;
  /*printf("Reading: w=%d h=%d d=%d\n",cinfo.output_width, cinfo.output_height, cinfo.out_color_components); */
  row_stride = cinfo.output_width * cinfo.out_color_components;
  /* Make a one-row-high sample array that will go away when done with image */
  buffer = (*cinfo.mem->alloc_sarray)
		((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);
  /* Step 6: while (scan lines remain to be read) */
  /*           jpeg_read_scanlines(...); */
  /* Here we use the library's state variable cinfo.output_scanline as the
   * loop counter, so that we don't have to keep track ourselves.
   */
  ptr = SvPV(sv,PL_na);
  ptr += ((flip != 0) ? row_stride * (cinfo.output_height -1) : 0);
  while (cinfo.output_scanline < cinfo.output_height) {
    /* jpeg_read_scanlines expects an array of pointers to scanlines.
     * Here the array is only one element long, but you could ask for
     * more than one scanline at a time if that's more convenient.
     */
    (void) jpeg_read_scanlines(&cinfo, buffer, 1);
    /* Assume put_scanline_someplace wants a pointer and sample count. */
    /* put_scanline_someplace(buffer[0], row_stride); */
    memcpy(ptr, buffer[0], row_stride); 
    ptr += row_stride * ((flip != 0) ? -1 : 1);
  }
  /* Step 7: Finish decompression */
  (void) jpeg_finish_decompress(&cinfo);
  /* We can ignore the return value since suspension is not possible
   * with the stdio data source.
   */
  /* Step 8: Release JPEG decompression object */
  /* This is an important step since it will release a good deal of memory. */
  jpeg_destroy_decompress(&cinfo);
  /* After finish_decompress, we can close the input file.
   * Here we postpone it until after no more JPEG errors are possible,
   * so as to simplify the setjmp error logic above.  (Actually, I don't
   * think that jpeg_destroy can do an error exit, but why assume anything...)
   */
  fclose(infile);
  /* At this point you may want to check to see whether any corrupt-data
   * warnings occurred (test whether jerr.pub.num_warnings is nonzero).
   */
  /* And we're done! */
  RETVAL = 1; break;
  }
OUTPUT:
	RETVAL
	dep
	hei
	wi



#
# This one is not use anymore
# It flip (change Y axis way) an image which pixels are passed 
# as parameters in datio.
# It is still here because perhaps will be usefull ... ?
#
int
flip_image(dep,hei,wi, datio)
	int dep
	int hei
	int wi
        SV* datio
CODE:
	/*
	 * This one is not use anymore
	 * It flip (change Y axis way) an image which pixels are passed 
	 * as parameters in datio.
	 * It is still here because perhaps will be usefull ... ?
	 */
        while ( 1 ) {
          unsigned char* ptrin = SvPV( datio, PL_na );
          unsigned char* ptrout =(unsigned char*)NULL;
          unsigned char* ptr; 
          int xi, yi, xv, yv, d;
          unsigned long size = hei*wi*dep * sizeof(unsigned char); 

          /*
          printf( "JPEG::flip_image -- LEN = %d\n", SvCUR(datio)); 
          printf( "JPEG::flip_image -- SIZE = %d\n", size);
          */
          ptr = ptrout =(unsigned char*)malloc( size );
          if ( (unsigned char*)NULL == ptrout )
            {
              croak( "Not enough memory\n" );
              RETVAL = 0;
              break; 
            }
          /*
          printf( "JPEG::flip_image -- ptrin = 0x%lx    ptrout = 0x%lx\n", ptrin, ptrout );
          */
          for ( yi = hei -1; yi >= 0; yi-- ) 
            for ( xi = 0; xi < wi; xi++ )
              for ( d = 0; d < dep; d++ )
                *ptr++= *((unsigned char *)((unsigned long)ptrin+((yi*wi+xi)*dep+d)));
          /*
          printf( "JPEG::flip_image -- 3\n" );
          */
          sv_setpvn( datio, ptrout, size );
          RETVAL = size;
          /*
          printf( "JPEG::flip_image -- RETVAL = %d\n", RETVAL);
          */
          break;
        }
OUTPUT:
        RETVAL
        datio
