/*
 * Decompiled with CFR 0.152.
 */
import FcpTools.FcpConnection;
import FcpTools.FcpToolsException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class BoardSettingsFrame
extends JDialog {
    static ResourceBundle LangRes = ResourceBundle.getBundle("res.LangRes");
    public boolean exitState;
    public String returnValue;
    public String board;
    JPanel mainPanel = new JPanel(new BorderLayout());
    JPanel radioButtonPanel = new JPanel(new BorderLayout());
    JPanel keyPanel = new JPanel(new GridLayout(3, 1));
    JPanel privateKeyPanel = new JPanel(new BorderLayout());
    JPanel publicKeyPanel = new JPanel(new BorderLayout());
    JPanel buttonPanel = new JPanel(new FlowLayout(2, 10, 10));
    JRadioButton publicBoardRadioButton = new JRadioButton(LangRes.getString("Public board"));
    JRadioButton secureBoardRadioButton = new JRadioButton(LangRes.getString("Secure board"));
    ButtonGroup group = new ButtonGroup();
    JButton okButton = new JButton(LangRes.getString("OK"));
    JButton cancelButton = new JButton(LangRes.getString("Cancel"));
    JButton generateKeyButton = new JButton(LangRes.getString("Generate new keypair"));
    JTextField privateKeyTextField = new JTextField(32);
    JTextField publicKeyTextField = new JTextField(32);

    private void Init() throws Exception {
        this.setTitle(LangRes.getString("Board settings for ") + this.board);
        this.setResizable(false);
        ((Component)this).setSize(new Dimension(680, 480));
        this.publicBoardRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardSettingsFrame.this.radioButton_actionPerformed(actionEvent);
            }
        });
        this.secureBoardRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardSettingsFrame.this.radioButton_actionPerformed(actionEvent);
            }
        });
        this.generateKeyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardSettingsFrame.this.generateKeyButton_actionPerformed(actionEvent);
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardSettingsFrame.this.okButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BoardSettingsFrame.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.mainPanel, null);
        this.group.add(this.publicBoardRadioButton);
        this.group.add(this.secureBoardRadioButton);
        this.radioButtonPanel.add((Component)this.publicBoardRadioButton, "North");
        this.radioButtonPanel.add((Component)this.secureBoardRadioButton, "South");
        this.privateKeyPanel.add((Component)new Label(LangRes.getString("Private key :")), "West");
        this.privateKeyPanel.add((Component)this.privateKeyTextField, "East");
        this.publicKeyPanel.add((Component)new Label(LangRes.getString("Public key :")), "West");
        this.publicKeyPanel.add((Component)this.publicKeyTextField, "East");
        this.privateKeyTextField.setEnabled(false);
        this.publicKeyTextField.setEnabled(false);
        this.generateKeyButton.setEnabled(false);
        this.keyPanel.add(this.privateKeyPanel);
        this.keyPanel.add(this.publicKeyPanel);
        this.keyPanel.add(this.generateKeyButton);
        this.mainPanel.add((Component)this.radioButtonPanel, "North");
        this.mainPanel.add((Component)this.keyPanel, "Center");
        this.mainPanel.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.publicBoardRadioButton.setSelected(true);
        this.loadKeypair();
    }

    private void radioButton_actionPerformed(ActionEvent actionEvent) {
        if (this.publicBoardRadioButton.isSelected()) {
            this.privateKeyTextField.setEnabled(false);
            this.publicKeyTextField.setEnabled(false);
            this.generateKeyButton.setEnabled(false);
        } else {
            this.privateKeyTextField.setEnabled(true);
            this.publicKeyTextField.setEnabled(true);
            this.generateKeyButton.setEnabled(true);
        }
    }

    private void generateKeyButton_actionPerformed(ActionEvent actionEvent) {
        try {
            FcpConnection fcpConnection = new FcpConnection(frame1.nodeAddress, frame1.nodePort);
            try {
                String[] stringArray = fcpConnection.getKeyPair();
                this.privateKeyTextField.setText(stringArray[0]);
                this.publicKeyTextField.setText(stringArray[1]);
            }
            catch (IOException iOException) {
                frame1.displayWarning(actionEvent.toString());
            }
        }
        catch (FcpToolsException fcpToolsException) {
            System.out.println("FcpToolsException " + fcpToolsException);
        }
        catch (IOException iOException) {
            frame1.displayWarning(actionEvent.toString());
        }
    }

    private void okButton_actionPerformed(ActionEvent actionEvent) {
        this.ok();
    }

    private void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.cancel();
    }

    public boolean getExitState() {
        return this.exitState;
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    private void ok() {
        this.exitState = true;
        this.returnValue = "publicBoard";
        String string = this.privateKeyTextField.getText();
        String string2 = this.publicKeyTextField.getText();
        File file = new File(frame1.keypool + this.board + ".key");
        if (this.secureBoardRadioButton.isSelected()) {
            if (string2.startsWith("SSK@") && !string.startsWith("SSK@")) {
                this.returnValue = "readAccess";
            }
            if (string2.startsWith("SSK@") && string.startsWith("SSK@")) {
                this.returnValue = "writeAccess";
            }
        }
        String string3 = System.getProperty("line.separator");
        String string4 = "privateKey=" + string + string3;
        string4 = string4 + "publicKey=" + string2 + string3;
        string4 = string4 + "state=" + this.returnValue + string3;
        FileAccess.writeFile(string4, frame1.keypool + this.board + ".key");
        this.dispose();
    }

    private void cancel() {
        this.exitState = false;
        this.dispose();
    }

    private void loadKeypair() {
        File file = new File(frame1.keypool + this.board + ".key");
        this.privateKeyTextField.setText(LangRes.getString("Not available"));
        this.publicKeyTextField.setText(LangRes.getString("Not available"));
        if (file.isFile() && file.length() > 0L) {
            String string = settings.getValue(file, "privateKey");
            String string2 = settings.getValue(file, "publicKey");
            String string3 = settings.getValue(file, "state");
            if (!string.equals("")) {
                this.privateKeyTextField.setText(string);
            }
            if (!string2.equals("")) {
                this.publicKeyTextField.setText(string2);
            }
            if (string3.equals("writeAccess") || string3.equals("readAccess")) {
                this.privateKeyTextField.setEnabled(true);
                this.publicKeyTextField.setEnabled(true);
                this.generateKeyButton.setEnabled(true);
                this.secureBoardRadioButton.setSelected(true);
            } else {
                this.privateKeyTextField.setEnabled(false);
                this.publicKeyTextField.setEnabled(false);
                this.generateKeyButton.setEnabled(false);
                this.publicBoardRadioButton.setSelected(true);
            }
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    public BoardSettingsFrame(Frame frame, String string) {
        super(frame);
        this.board = string.toLowerCase();
        this.enableEvents(64L);
        try {
            this.Init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.pack();
    }
}

