/*
 * Decompiled with CFR 0.152.
 */
package FcpTools;

import FcpTools.ConnectionException;
import FcpTools.DataNotFoundException;
import FcpTools.FcpKeyword;
import FcpTools.FcpResults;
import FcpTools.FcpToolsException;
import FcpTools.FreenetKey;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class FcpConnection {
    static final int TIMEOUT = 900000;
    static final boolean DEBUG = false;
    private InetAddress host;
    private int port;
    private int defaultHtl;
    private Socket fcpSock;
    private BufferedInputStream fcpIn;
    private PrintStream fcpOut;
    private byte[] header = new byte[]{0, 0, 0, 2};

    public FcpConnection() throws UnknownHostException, IOException, FcpToolsException {
        this("127.0.0.1", 8481);
    }

    public FcpConnection(String string, int n) throws UnknownHostException, IOException, FcpToolsException {
        this(string, n, 40);
    }

    public FcpConnection(String string, String string2) throws UnknownHostException, IOException, FcpToolsException {
        this(string, Integer.parseInt(string2), 40);
    }

    public FcpConnection(String string, int n, int n2) throws UnknownHostException, IOException, FcpToolsException {
        this.defaultHtl = n2;
        this.host = InetAddress.getByName(string);
        this.port = n;
        this.doHandshake();
    }

    public FcpResults getKeyToFile(String string, String string2) throws IOException, FcpToolsException {
        return this.getKeyToFile(string, string2, this.defaultHtl);
    }

    public FcpResults getKeyToFile(String string, String string2, int n) throws IOException, FcpToolsException, InterruptedIOException {
        Object object;
        FcpResults fcpResults = new FcpResults();
        FreenetKey freenetKey = new FreenetKey(string);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        this.fcpSock = new Socket(this.host, this.port);
        this.fcpSock.setSoTimeout(900000);
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpOut.write(this.header, 0, this.header.length);
        this.fcpOut.println("ClientGet");
        this.fcpOut.println("URI=" + freenetKey);
        this.fcpOut.println("HopsToLive=" + n);
        this.fcpOut.println("EndMessage");
        boolean bl = false;
        long l = 0L;
        long l2 = 0L;
        int n2 = 0;
        boolean bl2 = false;
        while (!bl) {
            System.out.print("*");
            if (!bl2) {
                FcpKeyword fcpKeyword = FcpKeyword.getFcpKeyword(this.fcpIn);
                switch (fcpKeyword.getId()) {
                    case 5: {
                        break;
                    }
                    case 6: {
                        l = fcpKeyword.getLongVal();
                        break;
                    }
                    case 9: {
                        bl = true;
                        break;
                    }
                    case 27: {
                        bl = true;
                        break;
                    }
                    case 22: {
                        break;
                    }
                    case 7: {
                        System.out.println("Exception occured - closing streams...");
                        this.fcpSock.close();
                        fileOutputStream.close();
                        this.fcpIn.close();
                        this.fcpOut.close();
                        object = new File(string2);
                        if (((File)object).length() == 0L) {
                            ((File)object).delete();
                        }
                        throw new DataNotFoundException();
                    }
                    case 23: {
                        bl = true;
                        break;
                    }
                    case 28: {
                        bl = true;
                        break;
                    }
                    case -1: {
                        bl = true;
                        break;
                    }
                    case 15: {
                        l2 = fcpKeyword.getLongVal();
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 14: {
                        n2 = (int)fcpKeyword.getLongVal();
                        break;
                    }
                    case 3: {
                        bl2 = true;
                    }
                }
                continue;
            }
            object = new byte[n2];
            int n3 = 0;
            boolean bl3 = false;
            while (n3 < n2) {
                int n4 = this.fcpIn.read((byte[])object, n3, n2 - n3);
                if (n4 < 0) break;
                n3 += n4;
            }
            fileOutputStream.write((byte[])object);
            bl2 = false;
            if ((l -= (long)n3) > 0L) continue;
            bl = true;
        }
        this.fcpSock.close();
        fileOutputStream.close();
        this.fcpIn.close();
        this.fcpOut.close();
        object = new File(string2);
        if (((File)object).length() == 0L) {
            ((File)object).delete();
        }
        return fcpResults;
    }

    public static byte[] readByteArray(String string) {
        return FcpConnection.readByteArray(new File(string));
    }

    public static byte[] readByteArray(File file) {
        try {
            byte[] byArray = new byte[(int)file.length()];
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = 0;
            int n2 = 0;
            int n3 = byArray.length;
            while (n < n3) {
                n2 = fileInputStream.read(byArray, n, n3 - n);
                if (n2 < 0) break;
                n += n2;
            }
            return byArray;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return null;
        }
    }

    public String putKeyFromFile(String string, String string2) throws IOException {
        File file = new File(string2);
        if (file.isFile() && file.length() > 0L) {
            return this.putKeyFromFile(string, string2, this.defaultHtl);
        }
        return "";
    }

    public String putKeyFromFile(String string, byte[] byArray, byte[] byArray2, int n) throws IOException {
        int n2;
        this.fcpSock = new Socket(this.host, this.port);
        this.fcpSock.setSoTimeout(900000);
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut.write(this.header, 0, this.header.length);
        this.fcpOut.println("ClientPut");
        this.fcpOut.println("HopsToLive=" + n);
        this.fcpOut.println("URI=" + string);
        int n3 = 0;
        int n4 = 0;
        if (byArray != null) {
            n3 = byArray.length;
        }
        if (byArray2 != null) {
            n4 = byArray2.length;
        }
        this.fcpOut.println("DataLength=" + Integer.toHexString(n3 + n4));
        if (byArray2 != null) {
            this.fcpOut.println("MetadataLength=" + Integer.toHexString(n4));
        }
        this.fcpOut.println("Data");
        if (byArray2 != null) {
            this.fcpOut.write(byArray2, 0, n4);
        }
        if (byArray != null) {
            this.fcpOut.write(byArray, 0, n3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = this.fcpIn.read()) != -1) {
            stringBuffer.append((char)n2);
            System.out.print((char)n2);
        }
        this.fcpSock.close();
        this.fcpOut.close();
        this.fcpIn.close();
        this.fcpSock.close();
        return stringBuffer.toString();
    }

    public String putKeyFromFile(String string, String string2, int n) throws IOException {
        int n2;
        int n3;
        File file = new File(string2);
        this.fcpSock = new Socket(this.host, this.port);
        this.fcpSock.setSoTimeout(900000);
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut.write(this.header, 0, this.header.length);
        this.fcpOut.println("ClientPut");
        this.fcpOut.println("HopsToLive=" + n);
        this.fcpOut.println("URI=" + string);
        this.fcpOut.println("DataLength=" + Integer.toHexString((int)file.length()));
        System.out.println("DataLength=" + file.length());
        this.fcpOut.println("Data");
        FileInputStream fileInputStream = new FileInputStream(string2);
        byte[] byArray = new byte[128];
        while ((n3 = fileInputStream.read(byArray)) != -1) {
            this.fcpOut.write(byArray, 0, n3);
        }
        fileInputStream.close();
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = this.fcpIn.read()) != -1) {
            stringBuffer.append((char)n2);
            System.out.print((char)n2);
        }
        this.fcpSock.close();
        this.fcpOut.close();
        this.fcpIn.close();
        this.fcpSock.close();
        return stringBuffer.toString();
    }

    public void doHandshake() throws IOException, FcpToolsException {
        FcpKeyword fcpKeyword;
        this.fcpSock = new Socket(this.host, this.port);
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpSock.setSoTimeout(900000);
        this.fcpOut.write(this.header, 0, this.header.length);
        this.fcpOut.println("ClientHello");
        this.fcpOut.println("EndMessage");
        int n = 0;
        do {
            fcpKeyword = FcpKeyword.getFcpKeyword(this.fcpIn);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.print(">");
        } while (fcpKeyword.getId() != 8 && ++n < 32);
        System.out.print("<");
        if (n == 32) {
            throw new ConnectionException();
        }
        this.fcpSock.close();
    }

    public String[] getKeyPair() throws IOException {
        int n;
        this.fcpSock = new Socket(this.host, this.port);
        this.fcpSock.setSoTimeout(900000);
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut.write(this.header, 0, this.header.length);
        this.fcpOut.println("GenerateSVKPair");
        this.fcpOut.println("EndMessage");
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.fcpIn.read()) != -1) {
            stringBuffer.append((char)n);
            System.out.print((char)n);
        }
        this.fcpSock.close();
        this.fcpOut.close();
        this.fcpIn.close();
        this.fcpSock.close();
        String[] stringArray = new String[]{"SSK@", "SSK@"};
        String string = stringBuffer.toString();
        int n2 = string.indexOf("PrivateKey=");
        int n3 = string.indexOf("PublicKey=");
        int n4 = string.indexOf("EndMessage");
        if (n2 != -1 && n3 != -1 && n4 != -1) {
            stringArray[0] = stringArray[0] + string.substring(n2 + 11, n3).trim();
            stringArray[1] = stringArray[1] + string.substring(n3 + 10, n4).trim();
        }
        return stringArray;
    }
}

