/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;

public class UpdateIdThread
extends Thread {
    private static boolean DEBUG = true;
    private static int maxFailures = 3;
    private static int keyCount = 0;
    private static int minKeyCount = 10;
    private static int maxKeysPerFile = 5000;
    private int maxKeys;
    private String date;
    private String oldDate;
    private String requestHtl;
    private String insertHtl;
    private String keypool;
    private String board;
    private String publicKey;
    private String privateKey;
    private String requestKey;
    private String insertKey;
    private String boardState;

    private boolean makeIndexFile() {
        if (DEBUG) {
            System.out.println("UpdateIdThread.makeIndexFile for " + this.board);
        }
        keyCount = Index.getUploadKeys(this.board);
        this.adjustMaxAge(keyCount);
        return keyCount > 0;
    }

    private void uploadIndexFile(int n) {
        File file = new File(this.keypool + this.board + "_upload.txt");
        boolean bl = false;
        int n2 = 0;
        String[] stringArray = new String[]{"Error", "Error"};
        if (file.length() > 0L && file.isFile()) {
            while (!bl && n2 <= maxFailures) {
                ++n2;
                stringArray = FcpInsert.putFile(this.insertKey + n + ".idx", this.keypool + this.board + "_upload.txt", this.insertHtl, true);
                if (stringArray[0].equals("Success")) {
                    bl = true;
                    if (!DEBUG) continue;
                    System.out.println("***** Index file successfully uploaded *****");
                    continue;
                }
                if (stringArray[0].equals("KeyCollision")) {
                    ++n;
                    if (!DEBUG) continue;
                    System.out.println("***** Index file collided, increasing index. *****");
                    continue;
                }
                if (!DEBUG) continue;
                System.out.println("***** Unknown upload error (" + n2 + "), retrying. *****");
            }
        }
    }

    private void adjustMaxAge(int n) {
        if (DEBUG) {
            System.out.println("AdjustMaxAge: old value = " + frame1.maxAge);
        }
        int n2 = 10 * this.maxKeys / 100;
        int n3 = 90 * this.maxKeys / 100;
        if (n < n2 && frame1.maxAge < 21) {
            ++frame1.maxAge;
        }
        if (n > n3 && frame1.maxAge > 1) {
            --frame1.maxAge;
        }
        if (DEBUG) {
            System.out.println("AdjustMaxAge: new value = " + frame1.maxAge);
        }
    }

    public void run() {
        int n = 0;
        int n2 = 0;
        while (n2 < maxFailures) {
            File file = new File(this.keypool + this.date + "-" + this.board + "-" + n + ".idx");
            if (DEBUG) {
                System.out.println("Requesting index " + n);
            }
            if (file.isFile() && file.length() > 0L) {
                if (DEBUG) {
                    System.out.println("Keyfile " + n + " existed, skipping download");
                }
                ++n;
                continue;
            }
            if (FcpRequest.getFile(this.requestKey + n + ".idx", "Unknown", file, this.requestHtl, true)) {
                Index.add(file, new File(this.keypool + this.board));
                ++n;
                n2 = 0;
                continue;
            }
            file.delete();
            ++n2;
            ++n;
        }
        n -= maxFailures;
        if (this.makeIndexFile()) {
            if (frame1.activeUploadThreads == 0 || keyCount >= minKeyCount) {
                if (DEBUG) {
                    System.out.println("UpdateIdThread (" + this.board + "): UploadFiles = " + keyCount);
                }
                this.uploadIndexFile(n);
            }
        } else if (DEBUG) {
            System.out.println("No keys to upload, stopping UpdateIdThread for " + this.board + ".");
        }
    }

    public UpdateIdThread(String string) {
        this.board = string.toLowerCase();
        this.date = mixed.getExtendedDate();
        this.requestHtl = frame1.keyDownloadHtl;
        this.insertHtl = frame1.keyUploadHtl;
        this.keypool = frame1.keypool;
        this.maxKeys = frame1.maxKeys;
        this.publicKey = settings.getValue(this.keypool + string + ".key", "publicKey");
        this.privateKey = settings.getValue(this.keypool + string + ".key", "privateKey");
        this.boardState = settings.getValue(this.keypool + string + ".key", "state");
        this.requestKey = this.publicKey.startsWith("SSK@") && !this.boardState.equals("publicBoard") ? this.publicKey + "PAgM" + "/" + this.date + "/" : "KSK@_" + string + "_" + this.date + "/";
        this.insertKey = this.privateKey.startsWith("SSK@") && !this.boardState.equals("publicBoard") ? this.privateKey + "/" + this.date + "/" : "KSK@_" + string + "_" + this.date + "/";
    }
}

