/*
 * Decompiled with CFR 0.152.
 */
import FcpTools.FcpConnection;
import FcpTools.FcpToolsException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.UnknownHostException;

public class FcpInsert {
    static final boolean DEBUG = true;
    static final int smallestChunk = 262144;
    private static String[] keywords = new String[]{"Success", "RouteNotFound", "KeyCollision", "SizeError", "DataNotFound"};

    private static String[] result(String string) {
        String[] stringArray = new String[]{"Error", "Error"};
        int n = 0;
        while (n < keywords.length) {
            if (string.indexOf(keywords[n]) != -1) {
                stringArray[0] = keywords[n];
            }
            ++n;
        }
        if (string.indexOf("CHK@") != -1) {
            stringArray[1] = string.substring(string.lastIndexOf("CHK@"), string.lastIndexOf("EndMessage"));
            stringArray[1] = stringArray[1].trim();
        } else {
            stringArray[1] = "Error";
        }
        return stringArray;
    }

    public static String[] putFile(String string, String string2, String string3, boolean bl) {
        return FcpInsert.putFile(string, new File(string2), Integer.parseInt(string3), bl);
    }

    public static String[] putFile(String string, File file, String string2, boolean bl) {
        return FcpInsert.putFile(string, file, Integer.parseInt(string2), bl);
    }

    public static String[] putFile(String string, File file, int n, boolean bl) {
        if (file.length() > 32000L && string.startsWith("KSK@")) {
            if (bl) {
                return FcpInsert.putSplitFile(string, file, n);
            }
            String[] stringArray = new String[]{"Error", "Error"};
            return stringArray;
        }
        if (file.length() <= 262144L) {
            try {
                FcpConnection fcpConnection = new FcpConnection(frame1.nodeAddress, frame1.nodePort);
                String string2 = fcpConnection.putKeyFromFile(string, file.getPath(), n);
                return FcpInsert.result(string2);
            }
            catch (FcpToolsException fcpToolsException) {
                System.out.println("FcpToolsException " + fcpToolsException);
                frame1.displayWarning(fcpToolsException.toString());
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println("UnknownHostException");
                frame1.displayWarning(unknownHostException.toString());
            }
            catch (IOException iOException) {
                System.out.println("IOException");
                frame1.displayWarning(iOException.toString());
            }
            return FcpInsert.result("");
        }
        return FcpInsert.putSplitFile(string, file, n);
    }

    private static void updateUploadTable(File file, int n) {
        int n2 = frame1.uploadTableModel.getRowCount();
        String string = (n /= 1024) + "Kb";
        int n3 = 0;
        while (n3 < n2) {
            if (file.getPath().equals(frame1.uploadTableModel.getValueAt(n3, 3))) {
                frame1.uploadTableModel.setValueAt(string, n3, 2);
            }
            ++n3;
        }
    }

    public static String[] putSplitFile(String string, File file, int n) {
        int n2;
        Object object;
        int n3 = (int)file.length();
        int n4 = 262144;
        if (n3 > 0x4000000) {
            n4 = Math.abs(n3 / 256);
        }
        System.out.println("ChunkSize: " + n4);
        boolean bl = false;
        String string2 = new String();
        Thread[] threadArray = new Thread[n3 / n4 + 1];
        int n5 = 0;
        int n6 = Integer.parseInt(frame1.splitfileUploadThreads);
        String[][] stringArray = new String[threadArray.length][2];
        try {
            Object object2;
            int n7;
            int n8;
            object = new FileInputStream(file);
            System.out.println("File size: " + n3);
            n2 = n4;
            while (n2 <= n3) {
                System.out.println("Full Size Chunk: " + n2);
                n8 = 0;
                n7 = 0;
                byte[] byArray = new byte[n4];
                while (n8 < n4) {
                    n7 = ((FileInputStream)object).read(byArray, n8, n4 - n8);
                    if (n7 < 0) break;
                    n8 += n7;
                }
                object2 = new File(frame1.keypool + String.valueOf(System.currentTimeMillis()) + ".tmp");
                ((File)object2).deleteOnExit();
                FileAccess.writeByteArray(byArray, (File)object2);
                byArray = null;
                while (FcpInsert.getActiveThreads(threadArray) >= n6) {
                    mixed.wait(5000);
                }
                threadArray[n5] = new putKeyThread("CHK@", (File)object2, n, stringArray, n5);
                threadArray[n5].start();
                ++n5;
                FcpInsert.updateUploadTable(file, n2);
                mixed.wait(1000);
                n2 += n4;
            }
            n8 = 0;
            n7 = 0;
            int n9 = n3 - n5 * n4;
            if (n9 > 0) {
                System.out.println("lastChunk:" + n9);
                object2 = new byte[n9];
                while (n8 < n9) {
                    n7 = ((FileInputStream)object).read((byte[])object2, n8, n9 - n8);
                    if (n7 < 0) break;
                    n8 += n7;
                }
                File file2 = new File(frame1.keypool + String.valueOf(System.currentTimeMillis()) + ".tmp");
                file2.deleteOnExit();
                FileAccess.writeByteArray((byte[])object2, file2);
                object2 = null;
                if (file2.length() > 0L) {
                    threadArray[n5] = new putKeyThread("CHK@", file2, n, stringArray, n5);
                    threadArray[n5].start();
                    ++n5;
                }
                object2 = null;
            }
            while (FcpInsert.getActiveThreads(threadArray) > 0) {
                System.out.println("Active Splitfile inserts remaining: " + FcpInsert.getActiveThreads(threadArray));
                mixed.wait(3000);
            }
            ((FileInputStream)object).close();
            threadArray = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = new String();
        object = "Version\nRevision=1\nEndPart\nDocument\n";
        object = (String)object + "SplitFile.Size=" + Integer.toHexString(n3) + "\n";
        object = (String)object + "SplitFile.Blocksize=" + Integer.toHexString(n4) + "\n";
        object = (String)object + "SplitFile.BlockCount=" + Integer.toHexString(n5) + "\n";
        n2 = 0;
        while (n2 < n5) {
            String string3 = stringArray[n2][0];
            String string4 = stringArray[n2][1];
            if (string4 == null) {
                String[] stringArray2 = new String[]{"Error", "Error"};
                System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                System.out.println("Chunk " + n2 + " thread returned no value!");
                System.out.println("Aborting upload of " + file.getName());
                System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                return stringArray2;
            }
            if (string4.indexOf("Error") != -1) {
                String[] stringArray3 = new String[]{"Error", "Error"};
                System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                System.out.println("Chunk " + n2 + " upload failed!");
                System.out.println("Aborting upload of " + file.getName());
                System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                return stringArray3;
            }
            object = (String)object + "SplitFile.Block." + Integer.toHexString(n2 + 1) + "=freenet:" + string4 + "\n";
            ++n2;
        }
        object = (String)object + "Info.Format=Frost\n";
        object = (String)object + "End\n";
        System.out.println((String)object);
        int n10 = 0;
        String[] stringArray4 = new String[]{"Error", "Error"};
        while (!stringArray4[0].equals("Success") && !stringArray4[0].equals("KeyCollision") && n10 < 8) {
            ++n10;
            try {
                FcpConnection fcpConnection = new FcpConnection(frame1.nodeAddress, frame1.nodePort);
                string2 = fcpConnection.putKeyFromFile(string, null, ((String)object).getBytes(), n);
            }
            catch (FcpToolsException fcpToolsException) {
                System.out.println("FcpToolsException " + fcpToolsException);
                frame1.displayWarning(fcpToolsException.toString());
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println("UnknownHostException");
                frame1.displayWarning(unknownHostException.toString());
            }
            catch (IOException iOException) {
                System.out.println("IOException");
                frame1.displayWarning(iOException.toString());
            }
            stringArray4 = FcpInsert.result(string2);
            mixed.wait(3000);
            System.out.println("*****" + stringArray4[0] + " " + stringArray4[1] + " ");
        }
        return FcpInsert.result(string2);
    }

    private static int getActiveThreads(Thread[] threadArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < threadArray.length) {
            if (threadArray[n2] != null && threadArray[n2].isAlive()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }
}

