/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class OptionsFrame
extends JDialog {
    static ResourceBundle LangRes = ResourceBundle.getBundle("res.LangRes");
    boolean exitState;
    String uploadingActivated;
    String downloadingActivated;
    String lastUsedDirectory;
    String userName;
    String maxAge;
    String tofTreeSelectedRow;
    String tofFontSize;
    String searchAllBoards;
    String automaticUpdate;
    JPanel mainPanel = new JPanel(new BorderLayout());
    JPanel buttonPanel = new JPanel(new FlowLayout(2, 10, 10));
    JPanel downloadPanel = new JPanel(new GridLayout(10, 1));
    JPanel uploadPanel = new JPanel(new GridLayout(10, 1));
    JPanel tofPanel = new JPanel(new GridLayout(6, 1));
    JPanel tofMainPanel = new JPanel(new BorderLayout());
    JPanel miscPanel = new JPanel(new GridLayout(10, 1));
    JPanel downloadDirectoryPanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel downloadHtlPanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel downloadThreadsPanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel downloadSplitfileThreadsPanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel uploadHtlPanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel uploadThreadsPanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel uploadSplitfileThreadsPanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel uploadIntervalPanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel tofUploadHtlPanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel tofDownloadHtlPanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel tofDisplayDaysPanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel tofDownloadDaysPanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel tofMessageBasePanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel tofBlockMessagePanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel tofSignaturePanel = new JPanel(new BorderLayout());
    JPanel miscKeyUploadHtlPanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel miscKeyDownloadHtlPanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel miscNodePanel = new JPanel(new FlowLayout(0, 10, 10));
    JPanel miscMaxKeysPanel = new JPanel(new FlowLayout(0, 10, 10));
    JScrollPane tofSignatureScrollPane = new JScrollPane();
    JTabbedPane mainTabbedPane = new JTabbedPane();
    JTextArea tofTextArea = new JTextArea();
    JButton okButton = new JButton(LangRes.getString("OK"));
    JButton cancelButton = new JButton(LangRes.getString("Cancel"));
    JButton browseDownloadDirectoryButton = new JButton(LangRes.getString("Browse..."));
    JTextField downloadDirectoryTextField = new JTextField(30);
    JTextField downloadMinHtlTextField = new JTextField(8);
    JTextField downloadMaxHtlTextField = new JTextField(8);
    JTextField downloadThreadsTextField = new JTextField(8);
    JTextField downloadSplitfileThreadsTextField = new JTextField(8);
    JTextField uploadHtlTextField = new JTextField(8);
    JTextField uploadThreadsTextField = new JTextField(8);
    JTextField uploadSplitfileThreadsTextField = new JTextField(8);
    JTextField uploadIntervalTextField = new JTextField(8);
    JTextField tofUploadHtlTextField = new JTextField(8);
    JTextField tofDownloadHtlTextField = new JTextField(8);
    JTextField tofDisplayDaysTextField = new JTextField(8);
    JTextField tofDownloadDaysTextField = new JTextField(8);
    JTextField tofMessageBaseTextField = new JTextField(8);
    JTextField tofBlockMessageTextField = new JTextField(32);
    JTextField miscKeyUploadHtlTextField = new JTextField(8);
    JTextField miscKeyDownloadHtlTextField = new JTextField(8);
    JTextField miscNodeAddressTextField = new JTextField(8);
    JTextField miscNodePortTextField = new JTextField(8);
    JTextField miscMaxKeysTextField = new JTextField(8);
    JCheckBox removeFinishedDownloadsCheckBox = new JCheckBox(LangRes.getString("Remove finished downloads every 5 minutes.(off)"));
    JCheckBox allowEvilBertCheckBox = new JCheckBox(LangRes.getString("Allow 2 byte characters"));

    private void Init() throws Exception {
        this.setTitle(LangRes.getString("Options"));
        this.setResizable(false);
        ((Component)this).setSize(new Dimension(680, 480));
        this.mainTabbedPane.setPreferredSize(new Dimension(680, 480));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsFrame.this.okButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsFrame.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.browseDownloadDirectoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsFrame.this.browseDownloadDirectoryButton_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.mainPanel, null);
        this.mainPanel.add((Component)this.mainTabbedPane, "Center");
        this.mainPanel.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.mainTabbedPane.add(LangRes.getString("Downloads"), this.downloadPanel);
        this.mainTabbedPane.add(LangRes.getString("Uploads"), this.uploadPanel);
        this.mainTabbedPane.add(LangRes.getString("News"), this.tofMainPanel);
        this.mainTabbedPane.add(LangRes.getString("Miscellaneous"), this.miscPanel);
        this.downloadDirectoryPanel.add(new JLabel(LangRes.getString("Download directory:")));
        this.downloadDirectoryTextField.setEditable(true);
        this.downloadDirectoryPanel.add(this.downloadDirectoryTextField);
        this.downloadDirectoryPanel.add(this.browseDownloadDirectoryButton);
        this.downloadHtlPanel.add(new JLabel(LangRes.getString("Minimum HTL (5):")));
        this.downloadHtlPanel.add(this.downloadMinHtlTextField);
        this.downloadHtlPanel.add(new JLabel(LangRes.getString("Maximum HTL (25):")));
        this.downloadHtlPanel.add(this.downloadMaxHtlTextField);
        this.downloadThreadsPanel.add(new JLabel(LangRes.getString("Number of simultaneous downloads (3):")));
        this.downloadThreadsPanel.add(this.downloadThreadsTextField);
        this.downloadSplitfileThreadsPanel.add(new JLabel(LangRes.getString("Number of splitfile threads (3):")));
        this.downloadSplitfileThreadsPanel.add(this.downloadSplitfileThreadsTextField);
        this.downloadPanel.add(this.downloadDirectoryPanel);
        this.downloadPanel.add(this.downloadHtlPanel);
        this.downloadPanel.add(this.downloadThreadsPanel);
        this.downloadPanel.add(this.downloadSplitfileThreadsPanel);
        this.downloadPanel.add(this.removeFinishedDownloadsCheckBox);
        this.uploadHtlPanel.add(new JLabel(LangRes.getString("Upload HTL (5):")));
        this.uploadHtlPanel.add(this.uploadHtlTextField);
        this.uploadThreadsPanel.add(new JLabel(LangRes.getString("Number of simultaneous uploads (3):")));
        this.uploadThreadsPanel.add(this.uploadThreadsTextField);
        this.uploadSplitfileThreadsPanel.add(new JLabel(LangRes.getString("Number of splitfile threads (3):")));
        this.uploadSplitfileThreadsPanel.add(this.uploadSplitfileThreadsTextField);
        this.uploadIntervalPanel.add(new JLabel(LangRes.getString("Reload interval (8 days):")));
        this.uploadIntervalPanel.add(this.uploadIntervalTextField);
        this.uploadPanel.add(this.uploadHtlPanel);
        this.uploadPanel.add(this.uploadThreadsPanel);
        this.uploadPanel.add(this.uploadSplitfileThreadsPanel);
        this.uploadPanel.add(this.uploadIntervalPanel);
        this.tofUploadHtlPanel.add(new JLabel(LangRes.getString("Message upload HTL (5):")));
        this.tofUploadHtlPanel.add(this.tofUploadHtlTextField);
        this.tofDownloadHtlPanel.add(new JLabel(LangRes.getString("Message download HTL(15):")));
        this.tofDownloadHtlPanel.add(this.tofDownloadHtlTextField);
        this.tofDisplayDaysPanel.add(new JLabel(LangRes.getString("Number of days to display (10):")));
        this.tofDisplayDaysPanel.add(this.tofDisplayDaysTextField);
        this.tofDownloadDaysPanel.add(new JLabel(LangRes.getString("Number of days to download backwards (3):")));
        this.tofDownloadDaysPanel.add(this.tofDownloadDaysTextField);
        this.tofMessageBasePanel.add(new JLabel(LangRes.getString("Message base (news):")));
        this.tofMessageBasePanel.add(this.tofMessageBaseTextField);
        this.tofBlockMessagePanel.add(new JLabel(LangRes.getString("Block messages: ")));
        this.tofBlockMessagePanel.add(this.tofBlockMessageTextField);
        this.tofPanel.add(this.tofUploadHtlPanel);
        this.tofPanel.add(this.tofDownloadHtlPanel);
        this.tofPanel.add(this.tofDisplayDaysPanel);
        this.tofPanel.add(this.tofDownloadDaysPanel);
        this.tofPanel.add(this.tofMessageBasePanel);
        this.tofPanel.add(this.tofBlockMessagePanel);
        this.tofMainPanel.add((Component)this.tofPanel, "North");
        this.tofSignatureScrollPane.getViewport().add((Component)this.tofTextArea, null);
        this.tofSignaturePanel.add((Component)new JLabel(LangRes.getString("Signature")), "North");
        this.tofSignaturePanel.add((Component)this.tofSignatureScrollPane, "Center");
        this.tofMainPanel.add((Component)this.tofSignaturePanel, "Center");
        this.miscKeyUploadHtlPanel.add(new JLabel(LangRes.getString("Keyfile upload HTL (5):")));
        this.miscKeyUploadHtlPanel.add(this.miscKeyUploadHtlTextField);
        this.miscKeyDownloadHtlPanel.add(new JLabel(LangRes.getString("Keyfile download HTL (15):")));
        this.miscKeyDownloadHtlPanel.add(this.miscKeyDownloadHtlTextField);
        this.miscNodePanel.add(new JLabel(LangRes.getString("Node address (127.0.0.1):")));
        this.miscNodePanel.add(this.miscNodeAddressTextField);
        this.miscNodePanel.add(new JLabel(LangRes.getString("Node port (8481):")));
        this.miscNodePanel.add(this.miscNodePortTextField);
        this.miscMaxKeysPanel.add(new JLabel(LangRes.getString("Maximum number of keys to store (100000):")));
        this.miscMaxKeysPanel.add(this.miscMaxKeysTextField);
        this.miscPanel.add(this.miscKeyUploadHtlPanel);
        this.miscPanel.add(this.miscKeyDownloadHtlPanel);
        this.miscPanel.add(this.miscNodePanel);
        this.miscPanel.add(this.miscMaxKeysPanel);
        this.miscPanel.add(this.allowEvilBertCheckBox);
    }

    private void okButton_actionPerformed(ActionEvent actionEvent) {
        this.ok();
    }

    private void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.cancel();
    }

    private void browseDownloadDirectoryButton_actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.lastUsedDirectory);
        jFileChooser.setDialogTitle(LangRes.getString("Select download directory."));
        jFileChooser.setFileHidingEnabled(true);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            String string = System.getProperty("file.separator");
            File file = jFileChooser.getSelectedFile();
            this.lastUsedDirectory = file.getParent();
            this.downloadDirectoryTextField.setText(file.getPath() + string);
        }
    }

    public boolean getExitState() {
        return this.exitState;
    }

    private void saveSettings() {
        String string = "downloadDirectory=" + this.downloadDirectoryTextField.getText() + "\r\n";
        string = string + "lastUsedDirectory=" + this.lastUsedDirectory + "\r\n";
        string = string + "htl=" + this.downloadMinHtlTextField.getText() + "\r\n";
        string = string + "htlMax=" + this.downloadMaxHtlTextField.getText() + "\r\n";
        string = string + "htlUpload=" + this.uploadHtlTextField.getText() + "\r\n";
        string = string + "uploadThreads=" + this.uploadThreadsTextField.getText() + "\r\n";
        string = string + "downloadThreads=" + this.downloadThreadsTextField.getText() + "\r\n";
        string = string + "tofUploadHtl=" + this.tofUploadHtlTextField.getText() + "\r\n";
        string = string + "tofDownloadHtl=" + this.tofDownloadHtlTextField.getText() + "\r\n";
        string = string + "keyUploadHtl=" + this.miscKeyUploadHtlTextField.getText() + "\r\n";
        string = string + "keyDownloadHtl=" + this.miscKeyDownloadHtlTextField.getText() + "\r\n";
        string = string + "userName=" + this.userName + "\r\n";
        string = string + "maxMessageDisplay=" + this.tofDisplayDaysTextField.getText() + "\r\n";
        string = string + "maxMessageDownload=" + this.tofDownloadDaysTextField.getText() + "\r\n";
        string = string + "downloadingActivated=" + this.downloadingActivated + "\r\n";
        string = string + "uploadingActivated=" + this.uploadingActivated + "\r\n";
        string = string + "removeFinishedDownloads=" + this.removeFinishedDownloadsCheckBox.isSelected() + "\r\n";
        string = string + "splitfileUploadThreads=" + this.uploadSplitfileThreadsTextField.getText() + "\r\n";
        string = string + "splitfileDownloadThreads=" + this.downloadSplitfileThreadsTextField.getText() + "\r\n";
        string = string + "nodeAddress=" + this.miscNodeAddressTextField.getText() + "\r\n";
        string = string + "nodePort=" + this.miscNodePortTextField.getText() + "\r\n";
        string = string + "uploadInterval=" + this.uploadIntervalTextField.getText() + "\r\n";
        string = string + "maxKeys=" + this.miscMaxKeysTextField.getText() + "\r\n";
        string = string + "messageBase=" + this.tofMessageBaseTextField.getText().trim().toLowerCase() + "\r\n";
        string = string + "blockMessage=" + this.tofBlockMessageTextField.getText().trim().toLowerCase() + "\r\n";
        string = string + "maxAge=" + this.maxAge + "\r\n";
        string = string + "tofTreeSelectedRow=" + this.tofTreeSelectedRow + "\r\n";
        string = string + "tofFontSize=" + this.tofFontSize + "\r\n";
        string = string + "searchAllBoards=" + this.searchAllBoards + "\r\n";
        string = string + "automaticUpdate=" + this.automaticUpdate + "\r\n";
        string = string + "allowEvilBert=" + this.allowEvilBertCheckBox.isSelected() + "\r\n";
        FileAccess.writeFile(string, "frost.ini");
    }

    private void loadSettings() {
        Vector vector = FileAccess.readLines("frost.ini");
        this.removeFinishedDownloadsCheckBox.setSelected(settings.getValue(vector, "removeFinishedDownloads").equals("true"));
        this.allowEvilBertCheckBox.setSelected(settings.getValue(vector, "allowEvilBert").equals("true"));
        this.downloadDirectoryTextField.setText(settings.getValue(vector, "downloadDirectory"));
        this.downloadMinHtlTextField.setText(settings.getValue(vector, "htl"));
        this.downloadMaxHtlTextField.setText(settings.getValue(vector, "htlMax"));
        this.downloadThreadsTextField.setText(settings.getValue(vector, "downloadThreads"));
        this.uploadHtlTextField.setText(settings.getValue(vector, "htlUpload"));
        this.uploadThreadsTextField.setText(settings.getValue(vector, "uploadThreads"));
        this.tofUploadHtlTextField.setText(settings.getValue(vector, "tofUploadHtl"));
        this.tofDownloadHtlTextField.setText(settings.getValue(vector, "tofDownloadHtl"));
        this.tofDisplayDaysTextField.setText(settings.getValue(vector, "maxMessageDisplay"));
        this.tofDownloadDaysTextField.setText(settings.getValue(vector, "maxMessageDownload"));
        this.miscKeyUploadHtlTextField.setText(settings.getValue(vector, "keyUploadHtl"));
        this.miscKeyDownloadHtlTextField.setText(settings.getValue(vector, "keyDownloadHtl"));
        this.downloadSplitfileThreadsTextField.setText(settings.getValue(vector, "splitfileDownloadThreads"));
        this.uploadSplitfileThreadsTextField.setText(settings.getValue(vector, "splitfileUploadThreads"));
        this.miscNodeAddressTextField.setText(settings.getValue(vector, "nodeAddress"));
        this.miscNodePortTextField.setText(settings.getValue(vector, "nodePort"));
        this.uploadIntervalTextField.setText(settings.getValue(vector, "uploadInterval"));
        this.miscMaxKeysTextField.setText(settings.getValue(vector, "maxKeys"));
        this.tofMessageBaseTextField.setText(settings.getValue(vector, "messageBase"));
        this.tofBlockMessageTextField.setText(settings.getValue(vector, "blockMessage"));
        this.downloadingActivated = settings.getValue(vector, "downloadingActivated");
        this.uploadingActivated = settings.getValue(vector, "uploadingActivated");
        this.userName = settings.getValue(vector, "userName");
        this.lastUsedDirectory = settings.getValue(vector, "lastUsedDirectory");
        this.maxAge = settings.getValue(vector, "maxAge");
        this.tofTreeSelectedRow = settings.getValue(vector, "tofTreeSelectedRow");
        this.tofFontSize = settings.getValue(vector, "tofFontSize");
        this.searchAllBoards = settings.getValue(vector, "searchAllBoards");
        this.automaticUpdate = settings.getValue(vector, "automaticUpdate");
    }

    private void ok() {
        this.exitState = true;
        this.saveSettings();
        this.saveSignature();
        this.dispose();
    }

    private void cancel() {
        this.exitState = false;
        this.dispose();
    }

    private void loadSignature() {
        File file = new File("signature.txt");
        if (file.isFile()) {
            this.tofTextArea.setText(FileAccess.readFile("signature.txt"));
        }
    }

    private void saveSignature() {
        FileAccess.writeFile(this.tofTextArea.getText(), "signature.txt");
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(windowEvent);
    }

    public OptionsFrame(Frame frame) {
        super(frame);
        this.loadSettings();
        this.loadSignature();
        this.enableEvents(64L);
        try {
            this.Init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.pack();
    }
}

