/*
	This file is part of OpenFuniter.

	complex.h V2.2.0 - complex math routines.

	Copyright (C) 1995-2002 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen)

	See README for contact information.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version. See

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	See COPYING for more information.
*/

#ifndef _COMPLEX
	#define _COMPLEX
	
	typedef struct {
		double r;
		double i;
	} TComplex;

	TComplex Complex(double RealPart, double ImagPart);

	double Imag(TComplex c);
	double Real(TComplex c);

	TComplex CNeg(TComplex c);

	TComplex CAdd(TComplex c1, TComplex c2);
	TComplex CSub(TComplex c1, TComplex c2);
	TComplex CMul(TComplex c1, TComplex c2);
	TComplex CDiv(TComplex c1, TComplex c2);

	double CAbs(TComplex c);

	TComplex CSqrt(TComplex c);

	#include <math.h>
#endif

