/*
	This file is part of XFuniter.

	main.c V2.2.0 - Funiter's main routine.

	Copyright (C) 1995-2002 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen).
    
	See README for contact information.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version. See

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	See COPYING for more information.
*/

#include <stdio.h>
#include <allegro.h>
#include "menus.h"
#include "realexp.h"
#include "cplexp.h"

int main()
{
    int             res, mode = GFX_AUTODETECT_WINDOWED, 
                    width = 640, height = 460;
    TRealExp        *RealExp;
    TComplexExp     *CplExp;

    /* Initialize graphics */

    allegro_init();
    install_mouse();
    install_keyboard();
    install_timer();
    set_gfx_mode(mode, width, height + 20, 0, 0);

    RealExp = CreateRealExp(0, 0, width, height);
    CplExp = CreateComplexExp(0, 0, width, height);

    MainMenu(RealExp, CplExp);
    allegro_exit();

    FreeComplexExp(CplExp);
    FreeRealExp(RealExp);
    return (res);
}
END_OF_MAIN()
