/*
	This file is part of XFuniter.

	menus.h V2.2.0 - all menu routines.

	Copyright (C) 1995-2002 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen).
    
	See README for contact information.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version. See

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	See COPYING for more information.
*/

#ifndef _MENUS
    #define _MENUS

    #include <stdio.h>
    #include <ctype.h>
    #include <allegro.h>
    #include "help.h"
    #include "extagui.h"
    #include "realexp.h"
    #include "cplexp.h"
       
    #define MAX_EDIT_LEN                    15
    
    /* Callback-functions / eventhandlers for the dialogs */
    
    int ParametersCallback(DIALOG *d);

    /* Menu definition functions */
    
    int MainMenu(TRealExp *RealExp0, TComplexExp *ComplexExp0);
    int MnuFunctiontype(void);
    int MnuGraph(void);
    int MnuDiagram(void);
    int MnuFunction(void);
    int MnuParameters(void);
    int MnuShowData(void); 
    int MnuDraw(void);
    int MnuSettings(void);
    int MnuAbout(void);
    int MnuQuit(void);
    int DoRCentralMenu(void);
    int DoCCentralMenu(void);
#endif
