/*
	This file is part of XFuniter.

	settings.c V2.2.0 - settings.

	Copyright (C) 1995-2002 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen)

	See README for contact information.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version. See

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	See COPYING for more information.
*/

#include "settings.h"


TSettings *CreateSettings(void)
{
	TSettings *Settings;

	if((Settings = (TSettings *) malloc(sizeof(TSettings))) == NULL)
		return NULL;

	Settings = SetDefaultSettings(Settings);

	return(Settings);
}

void FreeSettings(TSettings *Settings)
{
	if(Settings != NULL) free(Settings);
}

TSettings *SetDefaultSettings(TSettings *Settings)
{
    int         i;
    PALETTE     Palette;
    
    /* Get entire default palette */
    
    get_palette(Palette);
    
    /* Default colors */
    
    Palette[ 0].b = 0x00; Palette[ 0].g = 0x00; Palette[ 0].r = 0x00;
    Palette[ 1].b = 0x00; Palette[ 1].g = 0x00; Palette[ 1].r = 0xA8;
    Palette[ 2].b = 0x54; Palette[ 2].g = 0x54; Palette[ 2].r = 0xFC;
    Palette[ 3].b = 0xA8; Palette[ 3].g = 0x00; Palette[ 3].r = 0xA8;
    Palette[ 4].b = 0xFC; Palette[ 4].g = 0x54; Palette[ 4].r = 0xFC;
    Palette[ 5].b = 0x00; Palette[ 5].g = 0x54; Palette[ 5].r = 0xA8;
    Palette[ 6].b = 0x54; Palette[ 6].g = 0xFC; Palette[ 6].r = 0xFC;
    Palette[ 7].b = 0x00; Palette[ 8].g = 0xA8; Palette[ 8].r = 0x00;
    Palette[ 8].b = 0x54; Palette[ 7].g = 0xFC; Palette[ 7].r = 0x54;
    Palette[ 9].b = 0xA8; Palette[ 9].g = 0xA8; Palette[ 9].r = 0x00;
    Palette[10].b = 0xFC; Palette[10].g = 0x54; Palette[10].r = 0x54;
    Palette[11].b = 0xFC; Palette[11].g = 0xFC; Palette[11].r = 0x54; 
    Palette[12].b = 0xA8; Palette[12].g = 0x00; Palette[12].r = 0x00;
    Palette[13].b = 0xA8; Palette[13].g = 0xA8; Palette[13].r = 0xA8;
    Palette[14].b = 0x54; Palette[14].g = 0x54; Palette[14].r = 0x54;
    Palette[15].b = 0xFC; Palette[15].g = 0xFC; Palette[15].r = 0xFC;

    /* General settings */
    
	Settings->GEN_MenuStyle = TRUE;
	Settings->GEN_Fixedpoint = TRUE;
	Settings->GEN_ParConnect = TRUE;

	/* Layout settings (what you see / and how it appears on screen) */

	Settings->LAY_Statusline = TRUE;

	/* Coordinates - Sub-section in the Layout settings */

	Settings->COO_Status = TRUE;
	Settings->COO_Grid = FALSE;
	Settings->COO_Calibrate = TRUE;

	/* Step by step iteration - Sub-section in the Layout settings */

	Settings->SSI_Text = TRUE;
	Settings->SSI_Lines = TRUE;
	Settings->SSI_LineWidth = 2;
	Settings->SSI_FontSize = 4;
	Settings->SSI_Accuracy = 8;

	/* Colors */

	Settings->COL_Inside = 0;
	Settings->COL_Outside = 15;
	Settings->COL_Grid = 15;
	Settings->COL_Function = 4;
	Settings->COL_XYLine = 7;
	Settings->COL_Iter1 = 6;
	Settings->COL_Iter2 = 5;
	Settings->COL_Max = 15;

    for(i = 0; i <= 15; i++) Settings->COL_List[i] = i;

    set_palette(Palette);
    set_palette_range(Palette, 0, 15, FALSE);
	return(Settings);
}


