/*
	This file is part of XFuniter.

	clsmenus.c V2.2.3 - Funiter's old menu-style routine.

	Copyright (C) 1995-2003 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen).
    
	See README for contact information.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version. See

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	See COPYING for more information.
*/

#include "clsmenus.h"

static int          Functiontype;
         
static const char   *MenuTitleStrings[] = {

        "MAIN - MENU:",
        "GRAPH - MENU:",
        "TYPE OF DIAGRAM - MENU:",
        "SELECT A SHAPE TO START WITH:",
        "FUNCTION - MENU:",
        "PARAMETER - MENU:",
        "SETTINGS - MENU:",
        "LAYOUT - MENU:",
        "COORDINATE - MENU:",
        "STEP-BY-STEP ITERATION - MENU:",
        "COLOR - MENU:",
        "FILE - MENU:"
},

                    *MiscTexts[] = {

        "ON ",
        "OFF",
        "FIXED",
        "FLOAT",
        "Read file:",
        "Save file:",

};

static const TItem  MainItems[13] = {

    {   "Functiontype: from R to R  ", NULL, 0, 0, 0, 1, 96   },
	{   "Graph                      ", NULL, 0, 0, 0, 1, 97   },
	{   "Function                   ", NULL, 0, 0, 0, 1, 97   },
    {   "Parameters                 ", NULL, 0, 0, 0, 1, 97   },
	{   "Plot graph                 ", NULL, 0, 0, 0, 1, 97   },
	{   " ",                           NULL, 0, 0, 0, 1, 0    },
	{   "Settings                   ", NULL, 0, 0, 0, 1, 97   },
    {   "Files                      ", NULL, 0, 0, 0, 1, 97   },
	{   "Menustyle: Advanced        ", NULL, 0, 0, 0, 1, 96   },
	{   "About Funiter              ", NULL, 0, 0, 0, 1, 97   },
    {   "Quit program               ", NULL, 0, 0, 0, 1, 96   },

    {   "Functiontype: from C to C  ", NULL, 0, 0, 0, 1, 96   },
	{   "Menustyle: Standard        ", NULL, 0, 0, 0, 1, 96   }

},
                    RealGraphItems[3] = {

    /* Real graphs */

    {   "Step-by-step iteration         ", NULL, 0, 0, 0, 1, 97   },
    {   "Orbit diagram for variable x   ", NULL, 0, 0, 0, 1, 96   },
	{   "Orbit diagram for variable c   ", NULL, 0, 0, 0, 1, 96   }
},

                    ComplexGraphItems[5] = {

    /* Complex graphs */

    {   "Step-by-step iteration                     ", 0, 0, 0, 0, 1, 97  },
	{   "Step-by-step inverse iteration             ", 0, 0, 0, 0, 1, 97  },
	{   "Orbit diagram for variable z (Julia)       ", 0, 0, 0, 0, 1, 97  },
	{   "Orbit diagram for variable c (Mandelbrot)  ", 0, 0, 0, 0, 1, 97  },
    {   "Orbit diagram for variable c               ", 0, 0, 0, 0, 1, 97  }
},

                    RealDiagramItems[4] = {

    /* Real graphs */

    {	"Webdiagram                              ", NULL, 0, 0, 0, 1, 96 },
	{	"Iteration values                        ", NULL, 0, 0, 0, 1, 96 },
	{	"Stepdiagram                             ", NULL, 0, 0, 0, 1, 96 },
	{	"Combination of webdiagram & stepdiagram ", NULL, 0, 0, 0, 1, 96 }
},

                    ComplexStepShapeItems[4] = {

    /* Complex step-by-step shapes */

    {	"Point      ", NULL, 0, 0, 0, 1, 97 },
	{	"Line       ", NULL, 0, 0, 0, 1, 97 },
	{	"Rectangle  ", NULL, 0, 0, 0, 1, 97 },
	{	"Circle     ", NULL, 0, 0, 0, 1, 97 }
},

                    ComplexStepColorItems[3] = {
    
    /* Complex step-by-syep coloring method */
        
    {   "Color depends on startingpoint ", NULL, 0, 0, 0, 1, 96 },
    {   "Color depends on iter. steps   ", NULL, 0, 0, 0, 1, 96 },
    {   "All iterationsteps same color  ", NULL, 0, 0, 0, 1, 96 },
},

                    ComplexDiagramItems[4] = {

    /* Complex (orbit) diagrams */

    {	"Filled-in                  ", NULL, 0, 0, 0, 1, 96 },
	{	"Escape time                ", NULL, 0, 0, 0, 1, 96 },
	{	"Boundary trace             ", NULL, 0, 0, 0, 1, 96 },
	{	"Inverse iteration method   ", NULL, 0, 0, 0, 1, 0  }
},

                    RealFnItems[7] = {

    {	"      2       \r"
        "x -> x  + c           "                , NULL, 0,  6, 0, 2, 96 },
	{	"x -> frac(cx)"                         , NULL, 0,  9, 0, 1, 96 },
	{	"x -> c * cos(x)"                       , NULL, 0, 11, 0, 1, 96 },
	{	"x -> cx(1 - x)"                        , NULL, 0, 13, 0, 2, 96 },
	{	"        3            2\r"
        "x -> -cx  + (c + 1) x "                , NULL, 0, 15, 0, 1, 96 },
	{	"x -> c(1 - |2x - 1|)"                  , NULL, 0, 18, 0, 1, 96 },
    {   "User defined"                          , NULL, 0, 20, 0, 1, 96 }
},

                    ComplexFnItems[1] = {

    {	"      2       \r"
        "z -> z  + c     "                      , NULL, 0,  6, 0, 2, 96 },
},

                    ParameterItems[26] = {

    { "Value for parameter c            :", "            ", 0, 0, 12, 1, 4194 },
	{ "1st starting value for iteration :", "            ", 0, 0, 12, 1, 4194 },
	{ "2nd starting value for iteration :", "            ", 0, 0, 12, 1, 4194 },
    { "Estimated lowest value           :", "            ", 0, 0, 12, 1, 4194 },
    { "Estimated highest value          :", "            ", 0, 0, 12, 1, 4194 },
	{ "Y-coordinate (lowest)            :", "            ", 0, 0, 12, 1, 4194 },
    { "Y-coordinate (highest)           :", "            ", 0, 0, 12, 1, 4194 },
    { "Escape value                     :", "            ", 0, 0, 12, 1, 4194 },
	{ "Number of steps/iteration        :", "            ", 0, 0, 12, 1, 2146 },
    { "Total number of iterations       :", "            ", 0, 0, 12, 1, 2146 },
    { "Number of skipped iterationsteps :", "            ", 0, 0, 12, 1, 2146 },

    /* Differences: Real: Step: index: 3, 4 and 9 */

    { "Lowest value for c               :", "            ", 0, 0, 12, 1, 4194 },
    { "Highest value for c              :", "            ", 0, 0, 12, 1, 4194 },
    { "Function N times iterated        :", "            ", 0, 0, 12, 1, 2146 },

    /* Differences: Real: Orbits x: index: 3 and 4 */

    { "Lowest value for x               :", "            ", 0, 0, 12, 1, 4194 },
    { "Highest value for x              :", "            ", 0, 0, 12, 1, 4194 },

    /* Differences: Real: Orbits c: index: 3 and 4 */

    { "Lowest value for c               :", "            ", 0, 0, 12, 1, 4194 },
    { "Highest value for c              :", "            ", 0, 0, 12, 1, 4194 },

    /*
    **  Differences: Complex: Step: index: 1 and 2
    **               Complex: Orbits: index 1 and 2
    */

	{ "Real part of c                   :", "            ", 0, 0, 12, 1, 4194 },
	{ "Imaginary part of c              :", "            ", 0, 0, 12, 1, 4194 },

    /* Differences: Complex: Step: index: 3 to 6 */

    { "Min. for real part of values     :", "            ", 0, 0, 12, 1, 4194 },
	{ "Max. for real part of values     :", "            ", 0, 0, 12, 1, 4194 },
	{ "Min. for imaginary part of values:", "            ", 0, 0, 12, 1, 4194 },
	{ "Max. for imaginary part of values:", "            ", 0, 0, 12, 1, 4194 },

    /* Differences: Complex: Orbits c: index 1 and 2 */

	{ "Real part of z                   :", "            ", 0, 0, 12, 1, 4194 },
	{ "Imaginary part of z              :", "            ", 0, 0, 12, 1, 4194 }

    },

                    SettingsItems[5] = {

    { "Screen layout                    ", 0, 0, 0, 0, 1, 97 },
    { " ",                                 0, 0, 0, 0, 1, 0  },
    { " ",								   0, 0, 0, 0, 1, 0  },
    { "Fixed / Floatingpoint           :", 0, 0, 0, 0, 1, 96 },
    { "Parameter set connections       :", 0, 0, 0, 0, 1, 96 }

},
                    LayoutItems[5] = {

    { "Coordinates             ", NULL, 0, 0, 0, 1, 97 },
    { "Step-by-step iteration  ", NULL, 0, 0, 0, 1, 97 },
	{ "Colors                  ", NULL, 0, 0, 0, 1, 97 },
	{ " ",                        NULL, 0, 0, 0, 1, 0  },
    { "Status line            :", NULL, 0, 0, 0, 1, 96 }
},

                    CoordItems[3] = {

    { "Coordinate system         :", NULL, 0, 0, 0, 1, 96 },
	{ "Grid                      :", NULL, 0, 0, 0, 1, 96 },
	{ "Calibration               :", NULL, 0, 0, 0, 1, 96 }
},

                    StepItems[4] = {

    { "Show coords at iter points :", NULL, 0, 0, 0, 1, 96 },
	{ "Text size                  :", "  ", 0, 0, 2, 1, 2146 },
	{ "Connecting lines           :", NULL, 0, 0, 0, 1, 96 },
    { "Line width                 :", "  ", 0, 0, 2, 1, 2146 }
},

                    ColorItems[7] = {

    { "Grid                       :", "  ", 0, 0, 2, 1, 2146 },
	{ "Graph of function          :", "  ", 0, 0, 2, 1, 2146 },
	{ "Line x=y                   :", "  ", 0, 0, 2, 1, 2146 },
    { "1st starting value         :", "  ", 0, 0, 2, 1, 2146 },
    { "2nd starting value         :", "  ", 0, 0, 2, 1, 2146 },
    { " "                           , NULL, 0, 0, 2, 1,    0 },
    { "Edit colorpalette           ", NULL, 0, 0, 0, 1,   97 }
},

                    EditColPalItems[8] = {
                    
    { "Color :"               ,"   ", 0, 0, 3, 1,  100 },
    { " "                     , NULL, 0, 0, 0, 1,    0 },
    { "Red   :"               ,"   ", 0, 0, 3, 1,  100 },
    { "Green :"               ,"   ", 0, 0, 3, 1,  100 },
    { "Blue  :"               ,"   ", 0, 0, 3, 1,  100 },
    { " "                     , NULL, 0, 0, 0, 1,    0 },
    { "Invert black and white", NULL, 0, 0, 0, 1,   96 },
    { "To settings menu      ", NULL, 0, 0, 0, 1,   96 }
},
   
                    FilesItems[4] = {

    { "Load (.PAR)                ", NULL, 0, 0, 0, 1, 97 },
    { "Load (.PRM , 2.1)          ", NULL, 0, 0, 0, 1, 97 },
    { " "                          , NULL, 0, 0, 0, 1, 0  },
	{ "Save (.PAR)                ", NULL, 0, 0, 0, 1, 97 }
};

#define SE(V)       ((Functiontype == FT_REAL) ? (RealExp->Settings.V) : \
                    (ComplexExp->Settings.V))

int InitClassicMenus(int FnType, char *LngFilename)
{
    Functiontype = FnType;
    OpenLanguageFile(LngFilename);
    return 0;
}

int ClsMnuMain(TConsole *Console, TRealExp *RealExp, TComplexExp *ComplexExp)
{
	TMenu       *Menu;
    int         i, MenuXPos, MenuWidth, MaxItemLength, Key, FunctionFlag = TRUE,
                ISet = 0, ILay = 0, ICoo = 0, IStep = 0, ICol = 0, IFile = 0;
    char        **Str = GetItemStrings("MAINMENU", &MenuWidth, &MaxItemLength, 
                14);

    if(Str == NULL) {
        MaxItemLength = 27;
        Menu = CreateMenu(MenuTitleStrings[0], 26, 7, 0, 11, MaxItemLength, 0,
        LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 13, 
        (1 << M_HEADER) + (1 << M_STATUSBAR), MainItems);
    }
    else {
        MenuXPos = (80 - MaxItemLength) / 2;
        Menu = CreateMenu(Str[0], MenuXPos, 7, 0, 11, MenuWidth, 0,
        LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 13, 
        (1 << M_HEADER) + (1 << M_STATUSBAR), MainItems);
        for(i = 1; i <= 13; i++) Menu->Items[i - 1]->Caption = Str[i];
    }

    /* Set correct value for the first item (Real/Complex functions) */

    if(Functiontype == FT_COMPLEX)
        SwapItemCaptions(&Menu->Items[10]->Caption, &Menu->Items[0]->Caption);

    /* For Standard menu's, Settings and Files are not vissible */

    if(SE(GEN_MenuStyle) == MS_ADVANCED) {
        SwapItemCaptions(&Menu->Items[12]->Caption, &Menu->Items[8]->Caption);
        Menu->Items[7]->Flag = 96;
        Menu->Items[6]->Flag = 96;
    }
    else {
        SwapItemCaptions(&Menu->Items[8]->Caption, &Menu->Items[12]->Caption);
        Menu->Items[7]->Flag = 0;
        Menu->Items[6]->Flag = 0;
    }

    ClsMnuAbout(Console);
    DrawMenu(Console, Menu);

    while(TRUE) {

        Key = DoMenu(Console, Menu);

        switch(Menu->ItemIndex) {
            case 0:
                if(Key == KEY_ENTER) {
                    Menu->DefaultItemIndex = 0;
                    Functiontype = !Functiontype;

                    /*
                    **  Don't skip the item 'Function' when 'functiontype' is
                    **  toggled.
                    */

                    FunctionFlag = TRUE;

                    if(Functiontype == FT_REAL)
                        SwapItemCaptions(&Menu->Items[11]->Caption,
                        &Menu->Items[0]->Caption);
                    else
                        SwapItemCaptions(&Menu->Items[0]->Caption,
                        &Menu->Items[11]->Caption);

                    DrawItem(Console, Menu, Menu->Items[0]);
                }
                break;
            case 1:
                if(Key == KEY_ENTER) {
                    ClsMnuGraph(Console, RealExp, ComplexExp);

                    /* To 'Function' or 'Parameters' */

                    if(FunctionFlag) {
                        FunctionFlag = FALSE;
                        Menu->DefaultItemIndex = 2;
                    }
                    else
                        Menu->DefaultItemIndex = 3;

                    DrawMenu(Console, Menu);
                }
                break;
            case 2:
                if(Key == KEY_ENTER) {
                    ClsMnuFunction(Console, RealExp, ComplexExp);
                    Menu->DefaultItemIndex = 3;
                    DrawMenu(Console, Menu);
                }
                break;
            case 3:
                if(Key == KEY_ENTER) {
                    ClsMnuPar(Console, RealExp, ComplexExp);
                    Menu->DefaultItemIndex = 4;
                    DrawMenu(Console, Menu);
                }
                break;
            case 4:
                if(Key == KEY_ENTER) {
                    ClsMnuDraw(Console, RealExp, ComplexExp);
                    DrawMenu(Console, Menu);
                }
                break;
            case 5:
                if(Key == KEY_ENTER) {
                }
                break;
            case 6:
                if(Key == KEY_ENTER) {
                    ClsMnuSettings(Console, RealExp, ComplexExp, &ISet, &ILay,
                    &ICoo, &IStep, &ICol);
                    Menu->DefaultItemIndex = 4;
                    DrawMenu(Console, Menu);
                }
                break;
            case 7:
                if(Key == KEY_ENTER) {
                    ClsMnuFiles(Console, RealExp, ComplexExp, &IFile);
                    Menu->DefaultItemIndex = 4;
                    DrawMenu(Console, Menu);
                }
                break;
            case 8:
                if(Key == KEY_ENTER) {
                    SE(GEN_MenuStyle) = !SE(GEN_MenuStyle);
                    if(SE(GEN_MenuStyle) == MS_ADVANCED) {
                        SwapItemCaptions(&Menu->Items[8]->Caption,
                        &Menu->Items[12]->Caption);
                        Menu->Items[7]->Flag = 96;
                        Menu->Items[6]->Flag = 96;
                    }
                    else {
                        SwapItemCaptions(&Menu->Items[12]->Caption,
                        &Menu->Items[8]->Caption);
                        Menu->Items[7]->Flag = 0;
                        Menu->Items[6]->Flag = 0;
                    }
                    DrawItem(Console, Menu, Menu->Items[8]);
                    DrawItem(Console, Menu, Menu->Items[7]);
                    DrawItem(Console, Menu, Menu->Items[6]);
                }
                break;
            case 9:
                if(Key == KEY_ENTER) {
                    ClsMnuAbout(Console);
                    Menu->DefaultItemIndex = 9;
                    DrawMenu(Console, Menu);
                }
                break;
            case 10:
                if(Key == KEY_ENTER) {
                    free(RealExp);
                    free(ComplexExp);
                    DestroyMenu(Menu);
                    CloseLanguageFile();
                    exit(0);
                }
                break;
        }
    }
    return 0;
}

int ClsMnuGraph(TConsole *Console, TRealExp *RealExp, TComplexExp *ComplexExp)
{
	TMenu       *Menu;
    int         Key, OldGraph, MenuXPos, RMenuWidth, CMenuWidth,
                RMaxItemLength, CMaxItemLength, i;
    char        **GRStr = GetItemStrings("RGRAPHMENU", &RMenuWidth, 
                &RMaxItemLength, 4),
                **GCStr = GetItemStrings("CGRAPHMENU", &CMenuWidth, 
                &CMaxItemLength, 6);

    if(Functiontype == FT_REAL)
        OldGraph = RealExp->Graph;
    else
        OldGraph = ComplexExp->Graph;

    /* Create menu */

    if(Functiontype == FT_COMPLEX) {
        if(GCStr == NULL) {
            CMaxItemLength = 43; 
            Menu = CreateMenu(MenuTitleStrings[1], 18, 10, ComplexExp->Graph, 4,
            CMaxItemLength, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 5,
            (1 << M_HEADER) + (1 << M_STATUSBAR), ComplexGraphItems);
        }
        else {
            MenuXPos = (80 - CMenuWidth) / 2;
            Menu = CreateMenu(GCStr[0], MenuXPos, 10, ComplexExp->Graph, 4,
            CMenuWidth, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 5,
            (1 << M_HEADER) + (1 << M_STATUSBAR), ComplexGraphItems);
            for(i = 1; i <= 5; i++) Menu->Items[i - 1]->Caption = GCStr[i];
        }

        /*
        **  For 'Orbit diagram for var. c and z not equal to 0, it isn't
        **  a real Mandelbrot-set anymore, so we delete that from the caption.
        */

        if((ComplexExp->GraphPar[GR_C_ORBITS_C].zReal != 0) ||
        (ComplexExp->GraphPar[GR_C_ORBITS_C].zImag != 0))
            SwapItemCaptions(&Menu->Items[5]->Caption,
            &Menu->Items[6]->Caption);
    }
    else {
        if(GRStr == NULL) {
            RMenuWidth = 31; 
            Menu = CreateMenu(MenuTitleStrings[1], 24, 11, RealExp->Graph, 3,
            RMenuWidth, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 3,
            (1 << M_HEADER) + (1 << M_STATUSBAR), RealGraphItems);
        }
        else {
            MenuXPos = (80 - RMenuWidth) / 2;
            Menu = CreateMenu(GRStr[0], MenuXPos, 11, RealExp->Graph, 3,
            RMenuWidth, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 3,
            (1 << M_HEADER) + (1 << M_STATUSBAR), RealGraphItems);
            for(i = 1; i <= 3; i++) Menu->Items[i - 1]->Caption = GRStr[i];
        }
    }

    if(Functiontype == FT_COMPLEX)
        Menu->DefaultItemIndex = ComplexExp->Graph;
    else
        Menu->DefaultItemIndex = RealExp->Graph;

    a_clrscr(Console);
    DrawMenu(Console, Menu);

    while(TRUE) {
        Key = DoMenu(Console, Menu);

        if(Functiontype == FT_COMPLEX) {
            ComplexExp->Graph = Menu->ItemIndex;
            if(Key == KEY_ENTER) {
                if(ClsMnuDiagram(Console, RealExp, ComplexExp) == KEY_ESC) {
                    DrawMenu(Console, Menu);
                    continue;
                }
                break;
            }
        }
        else {
            RealExp->Graph = Menu->ItemIndex;
            if(RealExp->Graph == GR_R_STEP) {
                if(Key == KEY_ENTER) { 
                    if(ClsMnuDiagram(Console, RealExp, ComplexExp) == KEY_ESC) {
                        DrawMenu(Console, Menu);
                        continue;
                    }
                    break;
                }
            }
        }

        if(Key == KEY_ESC) break;
        if(Key == KEY_ENTER) break;
    }

    /* Process values */

    if(Key == KEY_ESC) {
        if(Functiontype == FT_REAL)
            RealExp->Graph = OldGraph;
        else
            ComplexExp->Graph = OldGraph;
    }

    DestroyMenu(Menu);
    return Key;
}

int ClsMnuDiagram(TConsole *Console, TRealExp *RealExp, TComplexExp *ComplexExp)
{
	TMenu       *Menu;
    int         Key, MenuXPos, RMenuWidth, CSMenuWidth, CMenuWidth, 
                RMaxItemLength, CSMaxItemLength, CMaxItemLength, i;
    char        **DRStr = GetItemStrings("RDIAGRAMMENU", &RMenuWidth, 
                &RMaxItemLength, 5),
                **DCSStr = GetItemStrings("CSDIAGRAMMENU", &CSMenuWidth, 
                &CSMaxItemLength, 5),
                **DCStr = GetItemStrings("CDIAGRAMMENU", &CMenuWidth, 
                &CMaxItemLength, 5);

    /* Select menu */

    if(Functiontype == FT_REAL) {
        if(DRStr == NULL) {
            RMenuWidth = 40;
            Menu = CreateMenu("TYPE OF DIAGRAM - MENU:", 20, 10,
            RealExp->Diagram, 4, RMenuWidth, 0, LIGHTGRAY, BLACK, BLACK,
            LIGHTGRAY, 4, (1 << M_HEADER) + (1 << M_STATUSBAR), 
            RealDiagramItems);
        }
        else {
            MenuXPos = (80 - RMenuWidth) / 2;
            Menu = CreateMenu(DRStr[0], MenuXPos, 10, RealExp->Diagram, 4,
            RMenuWidth, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 4,
            (1 << M_HEADER) + (1 << M_STATUSBAR), RealDiagramItems);
            for(i = 1; i <= 4; i++) Menu->Items[i - 1]->Caption = DRStr[i];
        }
    }
    else {
        if((ComplexExp->Graph == GR_C_STEP) ||
        (ComplexExp->Graph == GR_C_STEPINV)) {
            if(DCSStr == NULL) {
                CSMenuWidth = 11;
                Menu = CreateMenu(MenuTitleStrings[3], 34, 10,
                ComplexExp->Diagram, 4, CSMenuWidth, 0, LIGHTGRAY, BLACK,
                BLACK, LIGHTGRAY, 4, 
                (1 << M_HEADER) + (1 << M_STATUSBAR), ComplexStepShapeItems);
            }
            else {
                MenuXPos = (80 - CSMenuWidth) / 2;
                Menu = CreateMenu(DCSStr[0], MenuXPos, 10, ComplexExp->Diagram, 
                4, CSMenuWidth, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 4,
                (1 << M_HEADER) + (1 << M_STATUSBAR), ComplexStepShapeItems);
                for(i = 1; i <= 4; i++)
                    Menu->Items[i - 1]->Caption = DCSStr[i];
            }
        }
        else {
            if(DCStr == NULL) {
                CMenuWidth = 11;
                Menu = CreateMenu(MenuTitleStrings[2], 26, 10,
                ComplexExp->Diagram, 4, CMenuWidth, 0, LIGHTGRAY, BLACK,
                BLACK, LIGHTGRAY, 4, (1 << M_HEADER) + (1 << M_STATUSBAR), 
                ComplexDiagramItems);
            }
            else {
                MenuXPos = (80 - CMenuWidth) / 2;
                Menu = CreateMenu(DCStr[0], MenuXPos, 10, ComplexExp->Diagram, 
                4, CMenuWidth, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 4,
                (1 << M_HEADER) + (1 << M_STATUSBAR), ComplexDiagramItems);
                for(i = 1; i <= 4; i++) Menu->Items[i - 1]->Caption = DCStr[i];
            }
        }
    }

    /* For 'Orbit diagram for variable c', the last diagram is not available */

    if(ComplexExp->Graph == GR_C_ORBITS_Z) Menu->Items[3]->Flag = 96;

    a_clrscr(Console);
    DrawMenu(Console, Menu);

    while(TRUE) {
        Key = DoMenu(Console, Menu);

        if(Key == KEY_ESC) break;
        
        if(Key == KEY_ENTER) {
            if((Functiontype == FT_COMPLEX) && (ComplexExp->Graph == GR_C_STEP 
            || ComplexExp->Graph == GR_C_STEPINV)) { 
                if(ClsSubDiagram(Console, ComplexExp) == KEY_ESC) {
                    DrawMenu(Console, Menu);
                    continue;
                }
            }
            break;
        } 

    }

    /* Process data */

    if(Key == KEY_ENTER) {
        if(Functiontype == FT_REAL)
            RealExp->Diagram = Menu->ItemIndex;
        else
            ComplexExp->Diagram = Menu->ItemIndex;
    }
    DestroyMenu(Menu);
    return Key;
}

int ClsSubDiagram(TConsole *Console, TComplexExp *ComplexExp)
{
	TMenu       *Menu;
    int         Key, MenuXPos, CSCMenuWidth, CSCMaxItemLength, i = 0,
                DefaultItemIndex = 0;
    char        **CSCStr = GetItemStrings("CSTEPCOLORMENU",
                &CSCMenuWidth, &CSCMaxItemLength, 4);
    
    switch(ComplexExp->Coloring) {
        case CM_START: DefaultItemIndex = 0; break;
        case CM_ITERSTEP: DefaultItemIndex = 1; break;
        case CM_SAME: DefaultItemIndex = 2; break;
    }

    if(CSCStr == NULL) {
        Menu = CreateMenu("SELECT A COLORING-METHOD:", 24, 10, 
        DefaultItemIndex, 3, 31, 0, 
        LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 3, (1 << M_HEADER) + 
        (1 << M_STATUSBAR), ComplexStepColorItems);
    }
    else {
        MenuXPos = (80 - CSCMenuWidth) / 2;
        Menu = CreateMenu(CSCStr[0], MenuXPos, 10, DefaultItemIndex, 
        3, CSCMaxItemLength, 0, 
        LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 3, (1 << M_HEADER) + 
        (1 << M_STATUSBAR), ComplexStepColorItems);
        for(i = 1; i <= 3; i++) Menu->Items[i - 1]->Caption = CSCStr[i];
    }

    DrawMenu(Console, Menu);

    while(TRUE) {
        Key = DoMenu(Console, Menu);
        if((Key == KEY_ESC) || (Key == KEY_ENTER)) break;
    }
    
    switch(Menu->ItemIndex) {
        case 0: ComplexExp->Coloring = CM_START; break;
        case 1: ComplexExp->Coloring = CM_ITERSTEP; break;
        case 2: ComplexExp->Coloring = CM_SAME; break;
    }
    
    DestroyMenu(Menu);
    return Key;

}

int ClsMnuFunction(TConsole *Console, TRealExp *RealExp, 
TComplexExp *ComplexExp)
{
	TMenu       *Menu;
    int         Key, MenuXPos, RMenuWidth, RMaxItemLength;
    char        **FRStr = GetItemStrings("RFUNCTIONMENU", &RMenuWidth, 
                &RMaxItemLength, 2);

    clear_keybuf();

    if(Functiontype == FT_REAL) {
        if(FRStr == NULL)
            Menu = CreateMenu(MenuTitleStrings[4], 29, 4, RealExp->Diagram,
            7, 22, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 7, 
            (1 << M_HEADER) + (1 << M_STATUSBAR), RealFnItems);
        else {
            MenuXPos = (80 - RMenuWidth) / 2;
            Menu = CreateMenu(FRStr[0], MenuXPos, 4, RealExp->Diagram,
            7, 22, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 7, 
            (1 << M_HEADER) + (1 << M_STATUSBAR), RealFnItems);
            Menu->Items[6]->Caption = FRStr[1];             
        }
    }
    else {
        if(FRStr == NULL)
            Menu = CreateMenu(MenuTitleStrings[4], 32, 4, RealExp->Diagram,
            1, 16, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 1, 
            (1 << M_HEADER) + (1 << M_STATUSBAR), ComplexFnItems);
        else
            Menu = CreateMenu(FRStr[0], 32, 4, RealExp->Diagram,
            1, 16, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 1,
            (1 << M_HEADER) + (1 << M_STATUSBAR), ComplexFnItems);
    }
           
    if(Functiontype == FT_REAL)
        Menu->ItemIndex = RealExp->Function;
    else
        Menu->ItemIndex = ComplexExp->Function;

    a_clrscr(Console);
    DrawMenu(Console, Menu);

    while(TRUE) {
        Key = DoMenu(Console, Menu);
        if((Key == KEY_ESC) || (Key == KEY_ENTER)) break;
    }

    if(Key == KEY_ENTER) {
        if(Functiontype == FT_REAL) {
            RealExp->Function = Menu->ItemIndex;
            SelectExperiment(RealExp, TRUE, Menu->ItemIndex);    
        }
        else
            ComplexExp->Function = Menu->ItemIndex;
    }

    DestroyMenu(Menu);
    return Key;
}

TMenu *SelectRealParItems(TMenu *Menu, TRealExp *RealExp)
{
	TCoords		RCoords;
	TRGraphPar	RGraphPar;

	RCoords = *(RealExp->GraphPar[RealExp->Graph].Coords);
	RGraphPar = RealExp->GraphPar[RealExp->Graph];

    switch(RealExp->Graph) {
        case GR_R_STEP:

            /* Y-Coordinate (lowest)    */

            RESBIT(Menu->Items[5]->Flag, I_VISIBLE);

            /* Y-Coordinate (highest)   */

            RESBIT(Menu->Items[6]->Flag, I_VISIBLE);

            /* Total number of iter...  */

            RESBIT(Menu->Items[9]->Flag, I_VISIBLE);

            strcpy(Menu->Items[10]->Caption, Menu->Items[13]->Caption);

            break;
        case GR_R_ORBITS_X:
          
            /* 1st starting value...    */

            RESBIT(Menu->Items[1]->Flag, I_VISIBLE);

            /* 2nd starting value...    */

            RESBIT(Menu->Items[2]->Flag, I_VISIBLE);

            strcpy(Menu->Items[3]->Caption, Menu->Items[11]->Caption);
            strcpy(Menu->Items[4]->Caption, Menu->Items[12]->Caption);
            strcpy(Menu->Items[3]->Caption, Menu->Items[11]->Caption);
            strcpy(Menu->Items[4]->Caption, Menu->Items[12]->Caption);
               
            /* Number of steps/iter...  */

            RESBIT(Menu->Items[8]->Flag, I_VISIBLE);
            break;
        case GR_R_ORBITS_C:

            /* Value for parameter c    */

            RESBIT(Menu->Items[0]->Flag, I_VISIBLE);

            /* 2nd starting value...    */

            RESBIT(Menu->Items[2]->Flag, I_VISIBLE);

            strcpy(Menu->Items[3]->Caption, Menu->Items[14]->Caption);
            strcpy(Menu->Items[4]->Caption, Menu->Items[15]->Caption);
               
            /* Number of steps/iter...  */

            RESBIT(Menu->Items[8]->Flag, I_VISIBLE);
            break;
    }

    /* Copy values to the input strings */

    sprintf(Menu->Items[ 0]->Contents, "%.*g", DBL_DIG, RGraphPar.c);
    sprintf(Menu->Items[ 1]->Contents, "%.*g", DBL_DIG, RGraphPar.xbegin1);
    sprintf(Menu->Items[ 2]->Contents, "%.*g", DBL_DIG, RGraphPar.xbegin2);
    sprintf(Menu->Items[ 3]->Contents, "%.*g", DBL_DIG, RCoords.XMin);
    sprintf(Menu->Items[ 4]->Contents, "%.*g", DBL_DIG, RCoords.XMax);
    sprintf(Menu->Items[ 5]->Contents, "%.*g", DBL_DIG, RCoords.YMin);
    sprintf(Menu->Items[ 6]->Contents, "%.*g", DBL_DIG, RCoords.YMax);
    sprintf(Menu->Items[ 7]->Contents, "%.*g", DBL_DIG, RGraphPar.EscapeValue);
    sprintf(Menu->Items[ 8]->Contents, "%ld", RGraphPar.IterSteps);
    sprintf(Menu->Items[ 9]->Contents, "%ld", RGraphPar.IterMax);
    sprintf(Menu->Items[10]->Contents, "%ld", RGraphPar.IterSkip);
    if(RealExp->Graph == GR_R_STEP)
        sprintf(Menu->Items[10]->Contents, "%d", RGraphPar.Iterated);
    
    return(Menu);
}

TMenu *SelectComplexParItems(TMenu *Menu, TComplexExp *ComplexExp)
{
	TCoords		CCoords;
	TCGraphPar	CGraphPar;

	CCoords = *(ComplexExp->GraphPar[ComplexExp->Graph].Coords);
	CGraphPar = ComplexExp->GraphPar[ComplexExp->Graph];

    RESBIT(Menu->Items[0]->Flag, I_VISIBLE);

    strcpy(Menu->Items[1]->Caption, Menu->Items[18]->Caption);
    strcpy(Menu->Items[2]->Caption, Menu->Items[19]->Caption);
    strcpy(Menu->Items[3]->Caption, Menu->Items[20]->Caption);
    strcpy(Menu->Items[4]->Caption, Menu->Items[21]->Caption);
    strcpy(Menu->Items[5]->Caption, Menu->Items[22]->Caption);
    strcpy(Menu->Items[6]->Caption, Menu->Items[23]->Caption);

    switch(ComplexExp->Graph) {
        case GR_C_STEP:
        case GR_C_STEPINV:
            RESBIT(Menu->Items[9]->Flag, I_VISIBLE);
            break;
        case GR_C_ORBITS_Z:
            RESBIT(Menu->Items[8]->Flag, I_VISIBLE);
            break;
        case GR_C_ORBITS_C:
            SwapItemCaptions(&Menu->Items[1]->Caption,
            &Menu->Items[24]->Caption);
            SwapItemCaptions(&Menu->Items[2]->Caption,
            &Menu->Items[25]->Caption);
            RESBIT(Menu->Items[8]->Flag, I_VISIBLE);
            break;
    }

    /* Copy values to the input strings */

    if(ComplexExp->Graph == GR_C_ORBITS_C) {
        sprintf(Menu->Items[ 1]->Contents, "%.*g", DBL_DIG, CGraphPar.zReal);
        sprintf(Menu->Items[ 2]->Contents, "%.*g", DBL_DIG, CGraphPar.zImag);
    }
    else {
        sprintf(Menu->Items[ 1]->Contents, "%.*g", DBL_DIG, CGraphPar.cReal);
        sprintf(Menu->Items[ 2]->Contents, "%.*g", DBL_DIG, CGraphPar.cImag);
    }
    sprintf(Menu->Items[ 3]->Contents, "%.*g", DBL_DIG, CCoords.XMin);
    sprintf(Menu->Items[ 4]->Contents, "%.*g", DBL_DIG, CCoords.XMax);
    sprintf(Menu->Items[ 5]->Contents, "%.*g", DBL_DIG, CCoords.YMin);
    sprintf(Menu->Items[ 6]->Contents, "%.*g", DBL_DIG, CCoords.YMax);
    sprintf(Menu->Items[ 7]->Contents, "%.*g", DBL_DIG, CGraphPar.EscapeValue);
    sprintf(Menu->Items[ 8]->Contents, "%d", CGraphPar.IterSteps);
    if((ComplexExp->Graph == GR_C_ORBITS_Z) && 
    (ComplexExp->Diagram == DM_INVERSE))
        sprintf(Menu->Items[ 9]->Contents, "%d", ComplexExp->InvJuliaIterMax);
    else
        sprintf(Menu->Items[ 9]->Contents, "%d", CGraphPar.IterMax);
    sprintf(Menu->Items[10]->Contents, "%d", CGraphPar.IterSkip);

    return(Menu);
}

int ClsMnuPar(TConsole *Console, TRealExp *RealExp, TComplexExp *ComplexExp)
{
	TCoords		RCoords;
	TRGraphPar	RGraphPar;
	TCoords		CCoords;
	TCGraphPar	CGraphPar;
    TMenu       *Menu;
    int         i, tmp_x, tmp_y, Key, MenuXPos, MenuWidth, MaxItemLength, 
                RGraph = RealExp->Graph, CGraph = ComplexExp->Graph;
    char        **PRStr = GetItemStrings("PARAMETERMENU", &MenuWidth, 
                &MaxItemLength, 26),
                **XContents = (char **) malloc(sizeof(char *) * 25);
    
    /* Create shortcuts for coordinates and graph parameters */

	RCoords = *(RealExp->GraphPar[RealExp->Graph].Coords);
	RGraphPar = RealExp->GraphPar[RealExp->Graph];
	CCoords = *(ComplexExp->GraphPar[ComplexExp->Graph].Coords);
	CGraphPar = ComplexExp->GraphPar[ComplexExp->Graph];

    /* Recalculate escape value in case the user didn't change it */
   
    if(!RealExp->GraphPar[RGraph].EscapeValueChanged && 
    Functiontype == FT_REAL) {
        RGraphPar.EscapeValue = CalculateRealFnEscapeValue(RealExp);
        RealExp->GraphPar[RealExp->Graph].EscapeValue = RGraphPar.EscapeValue;
    }
    if(!ComplexExp->GraphPar[CGraph].EscapeValueChanged &&
    Functiontype == FT_COMPLEX) {
        CGraphPar.EscapeValue = CalculateComplexFnEscapeValue(ComplexExp);
        ComplexExp->GraphPar[ComplexExp->Graph].EscapeValue = 
            CGraphPar.EscapeValue;
    }
    
    /* Create menu */
    
    if(PRStr == NULL)
        Menu = CreateMenu(MenuTitleStrings[5], 16, 7, 0, 11, 34, 0,
        LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 26, 
        (1 << M_HEADER) + (1 << M_STATUSBAR), ParameterItems);
    else {
        MenuXPos = (80 - MenuWidth) / 2;
        Menu = CreateMenu(PRStr[0], MenuXPos, 7, 0, 11, MenuWidth, 0,
        LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 26, 
        (1 << M_HEADER) + (1 << M_STATUSBAR), ParameterItems);
        for(i = 1; i <= 25; i++) Menu->Items[i - 1]->Caption = PRStr[i];  
    }

    for(i = 0; i <= 24; i++) {
        XContents[i] = (char *) malloc(sizeof(char) * 50);
        Menu->Items[i]->Contents = XContents[i];
    }
    
    /* R -> R */
    
    if(Functiontype == FT_REAL) 

        /*
        **  Hide fields that are not required/make no sense for the selected
        **  graph, and change names for some fields.
        */

        Menu = SelectRealParItems(Menu, RealExp);
    
    else 

        /*
        **  Hide fields that are not required/make no sense for the selected
        **  graph, and change names for some fields.
        */

        Menu = SelectComplexParItems(Menu, ComplexExp);

    a_clrscr(Console);
    DrawMenu(Console, Menu);

    while(TRUE) {

        tmp_x = a_wherex(Console); tmp_y = a_wherey(Console);
            
        a_gotoxy(Console, (PRStr == NULL) ? 14 : (MenuXPos - 2), 16); 
            
        if(Functiontype == FT_REAL) {
            if(RealExp->GraphPar[RGraph].EscapeValueChanged) {
                a_textcolor(Console, RED); 
                a_cputs(Console, "*");
            }
            else {
                a_cputs(Console, " ");
            }
        }
        else if(Functiontype == FT_COMPLEX) {
            if(ComplexExp->GraphPar[CGraph].EscapeValueChanged) {
                a_textcolor(Console, RED); 
                a_cputs(Console, "*");
            }
            else {
                a_cputs(Console, " ");
            }
        }        
        a_gotoxy(Console, tmp_x, tmp_y);
        
        Key = DoMenu(Console, Menu);

        /* Set coordinates to default values */
        
        if(Key == KEY_F3) {
            if(Functiontype == FT_REAL) {
                SelectRealStdCoords(RealExp->GraphPar[RGraph].Coords, 
                    RealExp->Function, RGraph);
                sprintf(Menu->Items[ 3]->Contents, "%g", 
                    RealExp->GraphPar[RGraph].Coords->XMin);
                sprintf(Menu->Items[ 4]->Contents, "%g", 
                    RealExp->GraphPar[RGraph].Coords->XMax);
                sprintf(Menu->Items[ 5]->Contents, "%g", 
                    RealExp->GraphPar[RGraph].Coords->YMin);
                sprintf(Menu->Items[ 6]->Contents, "%g", 
                    RealExp->GraphPar[RGraph].Coords->YMax);
                Menu->DefaultItemIndex = 0;
                DrawMenu(Console, Menu);
            }
            else if(Functiontype == FT_COMPLEX) {
                SetComplexExpDefaultCoords(ComplexExp, CGraph);
                sprintf(Menu->Items[ 3]->Contents, "%g",
                    ComplexExp->GraphPar[CGraph].Coords->XMin);
                sprintf(Menu->Items[ 4]->Contents, "%g", 
                    ComplexExp->GraphPar[CGraph].Coords->XMax);
                sprintf(Menu->Items[ 5]->Contents, "%g", 
                    ComplexExp->GraphPar[CGraph].Coords->YMin);
                sprintf(Menu->Items[ 6]->Contents, "%g", 
                    ComplexExp->GraphPar[CGraph].Coords->YMax);
                Menu->DefaultItemIndex = 0;
                DrawMenu(Console, Menu);
            }
        }
        
        /* Recalculate escape value */
        
        if(Key == KEY_F4) {
            if(Functiontype == FT_REAL) {
                RealExp->GraphPar[RGraph].EscapeValueChanged = 
                    RGraphPar.EscapeValueChanged = FALSE;                
                RealExp->GraphPar[RGraph].EscapeValue = 
                    CalculateRealFnEscapeValue(RealExp);
                sprintf(Menu->Items[7]->Contents, "%g",
                    RealExp->GraphPar[RGraph].EscapeValue);            
            }   
            else if(Functiontype == FT_COMPLEX) {
                ComplexExp->GraphPar[CGraph].EscapeValueChanged = 
                    CGraphPar.EscapeValueChanged = FALSE;                
                ComplexExp->GraphPar[CGraph].EscapeValue = 
                    CalculateRealFnEscapeValue(RealExp);
                sprintf(Menu->Items[7]->Contents, "%g",
                    ComplexExp->GraphPar[CGraph].EscapeValue);            
            }   
            DrawMenu(Console, Menu);
            clear_keybuf();
            continue;
        }

        /* Quit this menu */

		if(Key == KEY_ESC) { clear_keybuf(); break; }

        if(Functiontype == FT_REAL) {
            switch(Menu->ItemIndex) {
                case 0:
                    if(RGraph == GR_R_STEP || RGraph ==  GR_R_ORBITS_X) {
                        if(!RealExp->GraphPar[RGraph].EscapeValueChanged) {
                            sprintf(Menu->Items[7]->Contents, "%g",
                            CalculateRealFnEscapeValue(RealExp));
                        }
                    }
                    break;
                case 1:
                    if(RGraph == GR_R_STEP) {
                        if(TSTBIT(Menu->Items[1]->Flag, I_CHANGED)) {
                            strcpy(Menu->Items[2]->Contents,
                            Menu->Items[1]->Contents);
                        }
                    }
                    else if(RGraph == GR_R_ORBITS_C) {
                        if(!RealExp->GraphPar[RGraph].EscapeValueChanged) {
                            sprintf(Menu->Items[7]->Contents, "%g",
                            CalculateRealFnEscapeValue(RealExp));
                        }
                    }
                    break;
                case 3:
                    if(RGraph == GR_R_STEP) {
                        strcpy(Menu->Items[5]->Contents,
                        Menu->Items[3]->Contents);
                        if(!RealExp->GraphPar[RGraph].EscapeValueChanged) {
                            sprintf(Menu->Items[7]->Contents, "%g",
                            CalculateRealFnEscapeValue(RealExp));
                        }
                    }
                    break;
                case 4:
                    if(RGraph == GR_R_STEP) {
                        strcpy(Menu->Items[6]->Contents,
                        Menu->Items[4]->Contents);
                        if(!RealExp->GraphPar[RGraph].EscapeValueChanged) {
                            sprintf(Menu->Items[7]->Contents, "%g",
                            CalculateRealFnEscapeValue(RealExp));
                        }
                    }
                    break;
                case 5:
                case 6:
                    if(!RealExp->GraphPar[RGraph].EscapeValueChanged) {
                        sprintf(Menu->Items[7]->Contents, "%g",
                        CalculateRealFnEscapeValue(RealExp));
                    }
                    break;
                case 7:

                    /*
                    **  If the calculated value isn't equal to that which the
                    **  user entered, the editfield/text is painted red and
                    **  the 'changed' flag is set to TRUE (user changed value).
                    */

                    if(TSTBIT(Menu->Items[7]->Flag, I_CHANGED)) {

                        /* Action which indicates user has changed value */

                        if(Functiontype == FT_REAL) 
                            RealExp->GraphPar[RGraph].EscapeValueChanged = 
                                RGraphPar.EscapeValueChanged = TRUE;
                        else if(Functiontype == FT_COMPLEX) 
                            ComplexExp->GraphPar[CGraph].EscapeValueChanged = 
                                CGraphPar.EscapeValueChanged = TRUE;
                    }
                    break;    
                default:
                    break;
            }
        }
        else if(Functiontype == FT_COMPLEX) {
            switch(Menu->ItemIndex) {
                case 1:
                case 2:
                case 5:
                case 6:
                    if(!ComplexExp->GraphPar[CGraph].EscapeValueChanged) {
                        sprintf(Menu->Items[7]->Contents, "%g",
                        CalculateComplexFnEscapeValue(ComplexExp));
                    }
                    break;
                case 7:

                    /*
                    **  If the calculated value isn't equal to that which the
                    **  user entered, the editfield/text is painted red and
                    **  the 'changed' flag is set to TRUE (user changed value).
                    */

                    if(TSTBIT(Menu->Items[7]->Flag, I_CHANGED)) {

                        /* Action which indicates user has changed value */

                        ComplexExp->GraphPar[CGraph].EscapeValueChanged = 
                            CGraphPar.EscapeValueChanged = TRUE;
                    }
                    break;    
                default:
                    break;
            }
        }
        
        /* Copy strings into values */

        if(Functiontype == FT_REAL) {
            RGraphPar.c = atof(Menu->Items[0]->Contents);
   		    RGraphPar.xbegin1 = atof(Menu->Items[1]->Contents);
            RGraphPar.xbegin2 = atof(Menu->Items[2]->Contents);
            SetCoords(&RCoords, atof(Menu->Items[3]->Contents),
            atof(Menu->Items[5]->Contents), atof(Menu->Items[4]->Contents),
            atof(Menu->Items[6]->Contents));
            
            RGraphPar.EscapeValue = atof(Menu->Items[7]->Contents);
   		    RGraphPar.IterSteps = atoi(Menu->Items[8]->Contents);
            RGraphPar.IterMax = atoi(Menu->Items[9]->Contents);
            RGraphPar.IterSkip = atoi(Menu->Items[10]->Contents);
            if(RealExp->Graph == GR_R_STEP)
                RGraphPar.Iterated = atoi(Menu->Items[10]->Contents);

            /* Copy values back */

	        *(RealExp->GraphPar[RealExp->Graph].Coords) = RCoords;
            RealExp->GraphPar[RealExp->Graph] = RGraphPar;
        }
        if(Functiontype == FT_COMPLEX) {    
            if(ComplexExp->Graph == GR_C_ORBITS_C) {
   		        CGraphPar.zReal = atof(Menu->Items[1]->Contents);
                CGraphPar.zImag = atof(Menu->Items[2]->Contents);
   		    }
            else {
                CGraphPar.cReal = atof(Menu->Items[1]->Contents);
                CGraphPar.cImag = atof(Menu->Items[2]->Contents);
   		    }
            SetCoords(&CCoords, strtod(Menu->Items[3]->Contents, NULL),
            strtod(Menu->Items[5]->Contents, NULL), 
            strtod(Menu->Items[4]->Contents, NULL),
            strtod(Menu->Items[6]->Contents, NULL));

            CGraphPar.EscapeValue = atof(Menu->Items[7]->Contents);
   		    CGraphPar.IterSteps = atoi(Menu->Items[8]->Contents);
            if((ComplexExp->Graph == GR_C_ORBITS_Z) && 
            (ComplexExp->Diagram == DM_INVERSE)) 
                ComplexExp->InvJuliaIterMax = atoi(Menu->Items[9]->Contents);
            else
                CGraphPar.IterMax = atoi(Menu->Items[9]->Contents);
            CGraphPar.IterSkip = atoi(Menu->Items[10]->Contents);

            /* Copy values back */

	        *(ComplexExp->GraphPar[ComplexExp->Graph].Coords) = CCoords;
            ComplexExp->GraphPar[ComplexExp->Graph] = CGraphPar;
        }
    }
    DestroyMenu(Menu);
    return 0;
}

int ClsMnuSummary(TConsole *Console, TRealExp *RealExp, TComplexExp *ComplexExp)
{
    TMenu           *Menu;
    int             Key, AltKey;
    unsigned int     n, i, XPos, MenuWidth[10], MaxItemLength[10], YPos = 3;
    char            **MStr = GetItemStrings("MAINMENU", &MenuWidth[0], 
                        &MaxItemLength[0], 14),
                    **GRStr = GetItemStrings("RGRAPHMENU", &MenuWidth[1],  
                        &MaxItemLength[1], 4),
                    **GCStr = GetItemStrings("CGRAPHMENU", &MenuWidth[2], 
                        &MaxItemLength[2], 6),
                    **DRStr = GetItemStrings("RDIAGRAMMENU", &MenuWidth[3], 
                        &MaxItemLength[3], 5),
                    **DCSStr = GetItemStrings("CSDIAGRAMMENU", &MenuWidth[4],
                        &MaxItemLength[4], 5),
                    **DCStr = GetItemStrings("CDIAGRAMMENU", &MenuWidth[5], 
                        &MaxItemLength[5], 5),
                    **CSCStr = GetItemStrings("CSTEPCOLORMENU", &MenuWidth[6], 
                        &MaxItemLength[6], 4),
                    **FRStr = GetItemStrings("RFUNCTIONMENU", &MenuWidth[7], 
                        &MaxItemLength[7], 2),
                    **PStr = GetItemStrings("PARAMETERMENU", &MenuWidth[8],
                        &MaxItemLength[8], 26),
                    **MTStr = GetItemStrings("MISCTEXTS", &MenuWidth[9],
                    &MaxItemLength[9], 7),
                    **XContents = (char **) malloc(sizeof(char *) * 25);
    
    if(MStr == NULL) MaxItemLength[0] = 27;
    if(GRStr == NULL) MaxItemLength[1] = 31;
    if(GCStr == NULL) MaxItemLength[2] = 43;
    if(DRStr == NULL) MaxItemLength[3] = 40;
    if(DCSStr == NULL) MaxItemLength[4] = 11;
    if(DCSStr == NULL) MaxItemLength[5] = 11;
    if(CSCStr == NULL) MaxItemLength[6] = 31;
    if(FRStr == NULL) MaxItemLength[7] = 22;
    if(PStr == NULL) MaxItemLength[8] = 34;
    if(MTStr == NULL) MaxItemLength[8] = 52;
         
    n = MaxItemLength[0];
    for(i = 1; i <= 9; i++) if(MaxItemLength[i] > n) n = MaxItemLength[i];
    XPos = (80 - n) / 2;
    
    /* Create menu */
    
    if(PStr == NULL)
        Menu = CreateMenu("", XPos + 1, (Functiontype == FT_REAL) ? 14 : 15,
        0, 11, MenuWidth[8], 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 26, 0, 
        ParameterItems);
    else {
        Menu = CreateMenu("", XPos + 1, (Functiontype == FT_REAL) ? 14 : 15,
        0, 11, MenuWidth[8], 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 26, 0, 
        ParameterItems);
        for(i = 1; i <= 25; i++) Menu->Items[i - 1]->Caption = PStr[i];  
    }

    for(i = 0; i <= 24; i++) {
        XContents[i] = (char *) malloc(sizeof(char) * 50);
        Menu->Items[i]->Contents = XContents[i];
    }
    
    a_clrscr(Console);
    
    if(Functiontype == FT_REAL) {
    
        /* Functiontype */
        
        a_gotoxy(Console, XPos, YPos); a_textcolor(Console, WHITE);
        if(MStr == NULL) 
            a_cputs(Console, MainItems[0].Caption); 
        else 
            a_cputs(Console, MStr[1]);
        YPos+=2;
        
        /* Graph */
        
        a_gotoxy(Console, XPos, YPos); a_textcolor(Console, WHITE); 
        a_cputs(Console, (MStr == NULL) ? MainItems[1].Caption : MStr[2]);
        YPos++;
                
        a_gotoxy(Console, XPos + 1, YPos); a_textcolor(Console, LIGHTGRAY);
        if(GRStr == NULL)
            a_cputs(Console, RealGraphItems[RealExp->Graph].Caption);
        else
            a_cputs(Console, GRStr[RealExp->Graph + 1]);
        YPos++;
        
        /* Diagram */
        
        if(RealExp->Graph == GR_R_STEP) {        
            a_gotoxy(Console, XPos + 2, YPos); a_textcolor(Console, LIGHTGRAY);
            if(DRStr == NULL)
                a_cputs(Console, RealDiagramItems[RealExp->Diagram].Caption);
            else
                a_cputs(Console, DRStr[RealExp->Diagram + 1]);
            YPos++;
        }
        
        YPos++;
        
        /* Function */
        
        a_gotoxy(Console, XPos, YPos); a_textcolor(Console, WHITE); 
        a_cputs(Console, (MStr == NULL) ? MainItems[2].Caption : MStr[3]);
        YPos++;

        a_textcolor(Console, LIGHTGRAY);
        if(RealExp->Function < 6) 
            DrawCaption(Console, XPos + 1, YPos, 
                RealFnItems[RealExp->Function].Caption);        
        else
            if(FRStr == NULL)
                a_cputs(Console, RealFnItems[RealExp->Function].Caption);    
            else
                a_cputs(Console, FRStr[1]);
         
         YPos++;
         
        /* Parameters */
        
        SelectRealParItems(Menu, RealExp);
    }       
    else {            
    
        /* Functiontype */
        
        a_gotoxy(Console, XPos, YPos); a_textcolor(Console, WHITE);
        if(MStr == NULL) 
            a_cputs(Console, MainItems[11].Caption); 
        else 
            a_cputs(Console, MStr[12]);
        YPos+=2;
        
        /* Graph */
        
        a_gotoxy(Console, XPos, YPos); a_textcolor(Console, WHITE); 
        a_cputs(Console, (MStr == NULL) ? MainItems[1].Caption : MStr[2]);
        YPos++;

        a_gotoxy(Console, XPos + 1, YPos); a_textcolor(Console, LIGHTGRAY);
        if(GCStr == NULL)
            a_cputs(Console, ComplexGraphItems[ComplexExp->Graph].Caption);
        else
            a_cputs(Console, GCStr[ComplexExp->Graph + 1]);
        YPos++;
        
        /* Diagram */

        if((ComplexExp->Graph == GR_C_STEP) || 
        (ComplexExp->Graph == GR_C_STEPINV)) {        
            a_gotoxy(Console, XPos + 2, YPos); a_textcolor(Console, LIGHTGRAY);
            if(DCSStr == NULL)
                a_cputs(Console, 
                ComplexStepShapeItems[ComplexExp->Diagram].Caption);
            else
                a_cputs(Console, DCSStr[ComplexExp->Diagram + 1]);
            
            YPos++;
            
            a_gotoxy(Console, XPos + 3, YPos); a_textcolor(Console, LIGHTGRAY);
            if(CSCStr == NULL)
                a_cputs(Console, 
                ComplexStepColorItems[ComplexExp->Coloring].Caption);
            else
                a_cputs(Console, CSCStr[ComplexExp->Coloring + 1]);
            
            YPos++;
        }
        else {
            a_gotoxy(Console, XPos + 1, YPos); a_textcolor(Console, LIGHTGRAY);
            if(DCStr == NULL)
                a_cputs(Console, 
                ComplexDiagramItems[ComplexExp->Diagram].Caption);
            else
                a_cputs(Console, DCStr[ComplexExp->Diagram + 1]);
            
            YPos++;
        }
        
        YPos++;
        
        /* Function */

        a_gotoxy(Console, XPos, YPos); a_textcolor(Console, WHITE); 
        a_cputs(Console, (MStr == NULL) ? MainItems[2].Caption : MStr[3]);
        YPos++;

        a_textcolor(Console, LIGHTGRAY);
        /*if(RealExp->Function < 6)*/ 
            DrawCaption(Console, XPos + 1, YPos, 
                ComplexFnItems[ComplexExp->Function].Caption);        
        YPos++;
        
        /* Parameters */
        
        SelectComplexParItems(Menu, ComplexExp);
    }
    
    YPos+=2;
    
    /* Parameters */
        
    a_gotoxy(Console, XPos, YPos); a_textcolor(Console, WHITE); 
    a_cputs(Console, (MStr == NULL) ? MainItems[3].Caption : MStr[4]);
    YPos++;
    
    for(i = 0; i < Menu->MaxItem; i++) DrawItem(Console, Menu, Menu->Items[i]);

    YPos+=13;
    
    a_gotoxy(Console, XPos, YPos); a_textcolor(Console, WHITE);
    a_cputs(Console, (MTStr != NULL) ? MTStr[6] :
    "<ENTER> - Draw  / <Escape> - Back to parameter-menu.");
        
    DestroyMenu(Menu);
    Key = readkey();
    AltKey = Key >> 8;
    
    if(AltKey == KEY_ENTER) 
        return TRUE; 
    else if(AltKey == KEY_ESC)
        return FALSE;
    return FALSE;
}

int ClsMnuDraw(TConsole *Console, TRealExp *RealExp, TComplexExp *ComplexExp)
{
    if(ClsMnuSummary(Console, RealExp, ComplexExp)) 
        MnuDraw(Functiontype, RealExp, ComplexExp);
    ClsMnuPar(Console, RealExp, ComplexExp);
    return 0;
}

void ClsMnuSettings(TConsole *Console, TRealExp *RealExp, 
TComplexExp *ComplexExp, int *ISet, int *ILay, int *ICoo, int *IStep, int *ICol)
{
    TMenu       *Menu;
	int         i, Key, MenuXPos, SMenuWidth, MTMenuWidth, SMaxItemLength,
                MTMaxItemLength;
    char        **SStr = GetItemStrings("SETTINGMENU", &SMenuWidth,
                &SMaxItemLength, 6),
                **MTStr = GetItemStrings("MISCTEXTS", &MTMenuWidth,
                &MTMaxItemLength, 4);

    if(MTStr == NULL) {
        MTStr = (char **) MiscTexts;
        SMaxItemLength = 33;
        SMenuWidth = 33;
    }

    if(SStr == NULL) {
        SMenuWidth = 33;
        Menu = CreateMenu("SETTINGS - MENU:", 23, 10, *ISet, 5,
        SMenuWidth, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 5,
        (1 << M_HEADER) + (1 << M_STATUSBAR), SettingsItems);
    }
    else {
        MenuXPos = (80 - SMenuWidth) / 2;
        Menu = CreateMenu(SStr[0], MenuXPos, 10, *ISet, 5, SMenuWidth, 0,
        LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 5,
        (1 << M_HEADER) + (1 << M_STATUSBAR), SettingsItems);
        for(i = 1; i <= 5; i++) Menu->Items[i - 1]->Caption = SStr[i];
    }

    a_clrscr(Console);
    DrawMenu(Console, Menu);

    a_gotoxy(Console, Menu->XPos + SMaxItemLength + 1, Menu->Items[3]->YPos);
    a_cputs(Console, (SE(GEN_Fixedpoint)) ? (MTStr[2]) : (MTStr[3]));
    a_gotoxy(Console, Menu->XPos + SMaxItemLength + 1, Menu->Items[4]->YPos);
    a_cputs(Console, (SE(GEN_ParConnect)) ? (MTStr[0]) : (MTStr[1]));

    while(TRUE) {

        Key = DoMenu(Console, Menu);

		if(Key == KEY_ESC) { clear_keybuf(); break; }

		switch(Menu->ItemIndex) {
			case 0:
                if(Key == KEY_ENTER) {
                    ClsMnuLayout(Console, RealExp, ComplexExp, ILay, ICoo, 
                    IStep, ICol);
                    DrawMenu(Console, Menu);
                    a_gotoxy(Console, Menu->XPos + SMaxItemLength + 1, 
                    Menu->Items[3]->YPos);
                    a_cputs(Console, 
                    (SE(GEN_Fixedpoint)) ? (MTStr[2]) : (MTStr[3]));
                    a_gotoxy(Console, Menu->XPos + SMaxItemLength + 1, 
                    Menu->Items[4]->YPos);
                    a_cputs(Console, 
                    (SE(GEN_ParConnect)) ? (MTStr[0]) : (MTStr[1]));
                }
				break;
			case 1:
				break;
			case 3:
                if(Key == KEY_ENTER) {
                    SE(GEN_Fixedpoint) = !SE(GEN_Fixedpoint);
                    a_gotoxy(Console, Menu->XPos + SMaxItemLength + 1, 
                    Menu->Items[3]->YPos);
                    a_cputs(Console, 
                    (SE(GEN_Fixedpoint)) ? (MTStr[2]) : (MTStr[3]));
                }
                break;
			case 4:
                if(Key == KEY_ENTER) {
                    SE(GEN_ParConnect) = !SE(GEN_ParConnect);
	                a_gotoxy(Console, Menu->XPos + SMaxItemLength + 1, 
                    Menu->Items[4]->YPos);
                    a_cputs(Console,
                    (SE(GEN_ParConnect)) ? (MTStr[0]) : (MTStr[1]));
                }
                break;
		}
	}
    *ISet = Menu->ItemIndex;
    DestroyMenu(Menu);
	return;
}

void ClsMnuLayout(TConsole *Console, TRealExp *RealExp, 
TComplexExp *ComplexExp, int *ILay, int *ICoo, int *IStep, int *ICol)
{
    TMenu       *Menu;
	int         i, Key, MenuXPos, LMenuWidth, MTMenuWidth,
                LMaxItemLength, MTMaxItemLength;
    char        **LStr = GetItemStrings("LAYOUTMENU", &LMenuWidth,
                &LMaxItemLength, 6), 
                **MTStr = GetItemStrings("MISCTEXTS", &MTMenuWidth, 
                &MTMaxItemLength, 4);

    clear_keybuf();

    if(MTStr == NULL) {
        MTStr = (char **) MiscTexts;
        LMaxItemLength = 24;
        LMenuWidth = 24;
    }
            
    if(LStr == NULL) {
        LMenuWidth = 24;
        Menu = CreateMenu("LAYOUT - MENU:", 23, 10, *ILay, 5, LMenuWidth, 0,
        LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 5, 
        (1 << M_HEADER) + (1 << M_STATUSBAR), LayoutItems);
    }
    else {
        MenuXPos = (80 - LMaxItemLength) / 2;
        Menu = CreateMenu(LStr[0], MenuXPos, 10, *ILay, 5, LMenuWidth, 0,
        LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 5, 
        (1 << M_HEADER) + (1 << M_STATUSBAR), LayoutItems);
        for(i = 1; i <= 5; i++) Menu->Items[i - 1]->Caption = LStr[i];  
    }

    a_clrscr(Console);
    DrawMenu(Console, Menu);

    a_gotoxy(Console, Menu->XPos + LMaxItemLength + 1, Menu->Items[4]->YPos);
    a_cputs(Console, (SE(LAY_Statusline)) ? (MTStr[0]) : (MTStr[1]));

    while(TRUE) {

        Key = DoMenu(Console, Menu);

        if(Key == KEY_ESC) { clear_keybuf(); break; }

        switch(Menu->ItemIndex) {
			case 0:
                if(Key == KEY_ENTER) {
				    *ICoo = ClsMnuCoords(Console, RealExp, ComplexExp, *ICoo);
                    Menu->DefaultItemIndex = Menu->ItemIndex;
                    DrawMenu(Console, Menu);
                    a_gotoxy(Console, Menu->XPos + LMaxItemLength + 1, 
                    Menu->Items[4]->YPos);
                    a_cputs(Console, 
                    (SE(LAY_Statusline)) ? (MTStr[0]) : (MTStr[1]));
                }
				break;
			case 1:
                if(Key == KEY_ENTER) {
                    *IStep = ClsMnuStep(Console, RealExp, ComplexExp, *IStep);
                    Menu->DefaultItemIndex = Menu->ItemIndex;
                    DrawMenu(Console, Menu);
                    a_gotoxy(Console, Menu->XPos + LMaxItemLength + 1, 
                    Menu->Items[4]->YPos);
                    a_cputs(Console,
                    (SE(LAY_Statusline)) ? (MTStr[0]) : (MTStr[1]));
                }
				break;
			case 2:
                if(Key == KEY_ENTER) {
                    *ICol = ClsMnuColors(Console, RealExp, ComplexExp, *ICol);
                    Menu->DefaultItemIndex = Menu->ItemIndex;
                    DrawMenu(Console, Menu);
                    a_gotoxy(Console, Menu->XPos + LMaxItemLength + 1, 
                    Menu->Items[4]->YPos);
                    a_cputs(Console, 
                    (SE(LAY_Statusline)) ? (MTStr[0]) : (MTStr[1]));
                }
				break;
			case 3:
				break;
			case 4:
                if(Key == KEY_ENTER) {
                    SE(LAY_Statusline) = !SE(LAY_Statusline);
		            a_gotoxy(Console, Menu->XPos + LMaxItemLength + 1, 
                    Menu->Items[4]->YPos);
                    a_cputs(Console, 
                    (SE(LAY_Statusline)) ? (MTStr[0]) : (MTStr[1]));
				}
                break;
			default:
				break;
		}
	}
    *ILay = Menu->ItemIndex;
    DestroyMenu(Menu);
	return;
}

void SetCoo(int Functiontype, TRealExp *RealExp, TComplexExp *ComplexExp)
{
    unsigned int    NewMode = 96;   /* X and Y Coords + Calibration (text) */
    
    if(!SE(COO_Status))  
        NewMode = 0; 
    else {
        NewMode = 52; /* X and Y Coords only + Calibration */
        if(SE(COO_Grid)) 
            SETBIT(NewMode, CO_GRID); else RESBIT(NewMode, CO_GRID);
        if(SE(COO_Calibrate)) 
            SETBIT(NewMode, CO_TEXT); else RESBIT(NewMode, 
                CO_TEXT);
    }
    
    if(Functiontype == FT_REAL) {
        RealExp->GraphPar[GR_R_STEP].Coords->Mode = NewMode;
        RealExp->GraphPar[GR_R_ORBITS_X].Coords->Mode = NewMode;
        RealExp->GraphPar[GR_R_ORBITS_C].Coords->Mode = NewMode;
    }
    else {
        ComplexExp->GraphPar[GR_C_STEP].Coords->Mode = NewMode;
        ComplexExp->GraphPar[GR_C_STEPINV].Coords->Mode = NewMode;
        ComplexExp->GraphPar[GR_C_ORBITS_Z].Coords->Mode = NewMode;
        ComplexExp->GraphPar[GR_C_ORBITS_C].Coords->Mode = NewMode;
    }
}
   
int ClsMnuCoords(TConsole *Console, TRealExp *RealExp, 
TComplexExp *ComplexExp, int ICoo)
{
    TMenu       *Menu;
	int         i, Key, MenuXPos, CMenuWidth, MTMenuWidth,
                CMaxItemLength, MTMaxItemLength;
    char        **CStr = GetItemStrings("COORDINATEMENU", &CMenuWidth, 
                &CMaxItemLength, 4),
                **MTStr = GetItemStrings("MISCTEXTS", &MTMenuWidth, 
                &MTMaxItemLength, 4);

    if(MTStr == NULL) {
        MTStr = (char **) MiscTexts;
        CMaxItemLength = 28;
        CMenuWidth = 28;
    }

    if(CStr == NULL) {
        Menu = CreateMenu("SETTINGS FOR COORDINATES:", 23, 10, ICoo,
        3, 28, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 3,
        (1 << M_HEADER) + (1 << M_STATUSBAR), CoordItems);
    }
    else {
        MenuXPos = (80 - CMenuWidth) / 2;
        Menu = CreateMenu(CStr[0], MenuXPos, 10, ICoo, 3, CMaxItemLength, 
        0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 3, 
        (1 << M_HEADER) + (1 << M_STATUSBAR), CoordItems);
        for(i = 1; i <= 3; i++) Menu->Items[i - 1]->Caption = CStr[i];
    }
    
	if(!SE(COO_Status)) {
        Menu->Items[1]->Flag = 0;
        Menu->Items[2]->Flag = 0;
    }
    else {
        Menu->Items[1]->Flag = 96;
        Menu->Items[2]->Flag = 96;
    }

    a_clrscr(Console);
    DrawMenu(Console, Menu);

    a_gotoxy(Console, Menu->XPos + CMaxItemLength + 1, Menu->Items[0]->YPos);
    a_cputs(Console, (SE(COO_Status)) ? (MTStr[0]) : (MTStr[1]));

	if(SE(COO_Status)) {
        a_gotoxy(Console, Menu->XPos + CMaxItemLength + 1, 
        Menu->Items[1]->YPos);
        a_cputs(Console, (SE(COO_Grid)) ? (MTStr[0]) : (MTStr[1]));

        a_gotoxy(Console, Menu->XPos + CMaxItemLength + 1, 
        Menu->Items[2]->YPos);
        a_cputs(Console, (SE(COO_Calibrate)) ? (MTStr[0]) : (MTStr[1]));
    }
    
	while(TRUE) {

        Key = DoMenu(Console, Menu);

        if(Key == KEY_ESC) break;

		switch(Menu->ItemIndex) {
			case 0:
                if(Key == KEY_ENTER) {
				    SE(COO_Status) = !SE(COO_Status);
	                if(!SE(COO_Status)) {
                        Menu->Items[1]->Flag = 0;
                        Menu->Items[2]->Flag = 0;
                    }
                    else {
                        Menu->Items[1]->Flag = 96;
                        Menu->Items[2]->Flag = 96;
                    }
                    DrawMenu(Console, Menu);
		            
                    a_gotoxy(Console, Menu->XPos + CMaxItemLength + 1, 
                    Menu->Items[0]->YPos);
                    a_cputs(Console,
                    (SE(COO_Status)) ? (MTStr[0]) : (MTStr[1]));
                    
	                if(SE(COO_Status)) {
                        a_gotoxy(Console, Menu->XPos + CMaxItemLength + 1, 
                        Menu->Items[1]->YPos);
                        a_cputs(Console, 
                        (SE(COO_Grid)) ? (MTStr[0]) : (MTStr[1]));
                    
                        a_gotoxy(Console, Menu->XPos + CMaxItemLength + 1, 
                        Menu->Items[2]->YPos);
                        a_cputs(Console, 
                        (SE(COO_Calibrate)) ? (MTStr[0]) : (MTStr[1]));
				    }
                    
                }
                break;
			case 1:
                if(Key == KEY_ENTER) {
    				SE(COO_Grid) = !SE(COO_Grid);
			        a_gotoxy(Console, Menu->XPos + CMaxItemLength + 1, 
                    Menu->Items[1]->YPos);
                    a_cputs(Console, (SE(COO_Grid)) ? (MTStr[0]) : (MTStr[1]));
				}
                break;
			case 2:
                if(Key == KEY_ENTER) {
        			SE(COO_Calibrate) = !SE(COO_Calibrate);
			        a_gotoxy(Console, Menu->XPos + CMaxItemLength + 1, 
                    Menu->Items[2]->YPos);
                    a_cputs(Console,
                    (SE(COO_Calibrate)) ? (MTStr[0]) : (MTStr[1]));
				}
                break;
		}
	}
    SetCoo(Functiontype, RealExp, ComplexExp);
    ICoo = Menu->ItemIndex;
    DestroyMenu(Menu);
	return(ICoo);
}

int ClsMnuStep(TConsole *Console, TRealExp *RealExp, TComplexExp *ComplexExp, 
int IStep)
{
    TMenu       *Menu;
	int         i, Key, MenuXPos, SMenuWidth, MTMenuWidth,
                SMaxItemLength, MTMaxItemLength;
    char        **SStr = GetItemStrings("STEPMENU",
                &SMenuWidth, &SMaxItemLength, 5), 
                **MTStr = GetItemStrings("MISCTEXTS",
                &MTMenuWidth, &MTMaxItemLength, 5);
    
    if(MTStr == NULL) {
        MTStr = (char **) MiscTexts;
        SMaxItemLength = 29;
        SMenuWidth = 29;
    }

    if(SStr == NULL) {
        SMenuWidth = 29;
        Menu = CreateMenu("SETTINGS FOR STEP-BY-STEP ITERATION:", 23, 10, IStep,
        4, SMaxItemLength, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 4, 
        (1 << M_HEADER) + (1 << M_STATUSBAR), StepItems);
    }
    else {
        MenuXPos = (80 - SMenuWidth) / 2;
        Menu = CreateMenu(SStr[0], MenuXPos, 10, IStep, 4, SMaxItemLength, 0, 
        LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 4, 
        (1 << M_HEADER) + (1 << M_STATUSBAR), StepItems);
        for(i = 1; i <= 4; i++) Menu->Items[i - 1]->Caption = SStr[i];
    }
    
    if(Functiontype == FT_REAL) 
        Menu->Items[2]->Flag = 0;
    else
        Menu->Items[2]->Flag = 96;
        
    sprintf(Menu->Items[1]->Contents, "%2d", SE(SSI_FontSize));
    sprintf(Menu->Items[3]->Contents, "%2d", SE(SSI_LineWidth));

    a_clrscr(Console);
    DrawMenu(Console, Menu);

    a_gotoxy(Console, Menu->XPos + SMaxItemLength + 1, Menu->Items[0]->YPos);
    a_cputs(Console, (SE(SSI_Text)) ? (MTStr[0]) : (MTStr[1]));
    if(Functiontype == FT_COMPLEX) { 
        a_gotoxy(Console, Menu->XPos + SMaxItemLength + 1, 
            Menu->Items[2]->YPos);
        a_cputs(Console, (SE(SSI_Lines)) ? (MTStr[0]) : (MTStr[1]));
    }
    
	while(TRUE) {

        SE(SSI_FontSize) = atoi(Menu->Items[1]->Contents);
        SE(SSI_LineWidth) = atoi(Menu->Items[3]->Contents);

        Key = DoMenu(Console, Menu);
        
        if(Key == KEY_ESC) break;
		
        switch(Menu->ItemIndex) {
			case 0:
                if(Key == KEY_ENTER) {
				    SE(SSI_Text) = !SE(SSI_Text);
                    a_gotoxy(Console, Menu->XPos + SMaxItemLength + 1, 
                    Menu->Items[0]->YPos);
                    a_cputs(Console, (SE(SSI_Text)) ? (MTStr[0]) : (MTStr[1]));
				}
                break;
			case 1:
                break;
			case 2:
                if(Functiontype == FT_COMPLEX) {
                    if(Key == KEY_ENTER) {
				        SE(SSI_Lines) = !SE(SSI_Lines);
		                a_gotoxy(Console, Menu->XPos + SMaxItemLength + 1, 
                        Menu->Items[2]->YPos);
                        a_cputs(Console, (SE(SSI_Lines)) ? (MTStr[0]) : 
                        (MTStr[1]));
                    }
			    }
                break;
			case 3:
                break;
		}
	}
    IStep = Menu->ItemIndex;
    DestroyMenu(Menu);
	return(IStep);
}

int ClsMnuColors(TConsole *Console, TRealExp *RealExp, TComplexExp *ComplexExp,
int IColor)
{
    TMenu       *Menu;
	int         i, Key, MenuXPos, CMenuWidth, CMaxItemLength;
    char        **CStr = GetItemStrings("SETCOLORMENU", &CMenuWidth,
                &CMaxItemLength, 8);

    if(CStr == NULL) {
        CMenuWidth = 29;
        Menu = CreateMenu("COLOR SETTINGS:", 23, 8, IColor,
        7, 29, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 7, 
        (1 << M_HEADER) + (1 << M_STATUSBAR), ColorItems);
    }
    else {
        MenuXPos = (80 - CMenuWidth) / 2;
        Menu = CreateMenu(CStr[0], MenuXPos, 8, IColor, 7, CMaxItemLength, 
        0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 7, 
        (1 << M_HEADER) + (1 << M_STATUSBAR), ColorItems);
        for(i = 1; i <= 7; i++) Menu->Items[i - 1]->Caption = CStr[i];
    }

    sprintf(Menu->Items[0]->Contents, "%2d", SE(COL_Grid));
    sprintf(Menu->Items[1]->Contents, "%2d", SE(COL_Function));
    sprintf(Menu->Items[2]->Contents, "%2d", SE(COL_XYLine));
    sprintf(Menu->Items[3]->Contents, "%2d", SE(COL_Iter1));
    sprintf(Menu->Items[4]->Contents, "%2d", SE(COL_Iter2));

    DrawMenu(Console, Menu);
    
    /* Draw a list with colors */

    a_gotoxy(Console, 19, 20);
	for(i = 0; i <= 15; i++) {
	    (i == 0) ? a_textbackground(Console, WHITE) : 
        a_textbackground(Console, BLACK);
		a_textcolor(Console, i);
		a_cprintf(Console, " %d", i);
	}

	while(TRUE) {

        Key = DoMenu(Console, Menu);

        if((Key == KEY_ESC) || (Key == KEY_ENTER)) {
            SE(COL_Grid) = atoi(Menu->Items[0]->Contents);
            SE(COL_Function) = atoi(Menu->Items[1]->Contents);
            SE(COL_XYLine) = atoi(Menu->Items[2]->Contents);
            SE(COL_Iter1) = atoi(Menu->Items[3]->Contents);
            SE(COL_Iter2) = atoi(Menu->Items[4]->Contents);
        }
        
        if(Key == KEY_ESC) break;

        switch(Menu->ItemIndex) {
            case 5:
                break;
            case 6:
                if(Key == KEY_ENTER) { 
                    ClsEditColorPalette(Console, RealExp, ComplexExp, 0);
                    
                    sprintf(Menu->Items[0]->Contents, "%2d", SE(COL_Grid));
                    sprintf(Menu->Items[1]->Contents, "%2d", SE(COL_Function));
                    sprintf(Menu->Items[2]->Contents, "%2d", SE(COL_XYLine));
                    sprintf(Menu->Items[3]->Contents, "%2d", SE(COL_Iter1));
                    sprintf(Menu->Items[4]->Contents, "%2d", SE(COL_Iter2));

                    DrawMenu(Console, Menu);
                    
                    /* Draw a list with colors */

                    a_gotoxy(Console, 19, 20);
	                for(i = 0; i <= 15; i++) {
	                    (i == 0) ? a_textbackground(Console, WHITE) : 
                        a_textbackground(Console, BLACK);
		                a_textcolor(Console, i);
		                a_cprintf(Console, " %d", i);
	                }
                    
                    /*ClsMnuColors(Console, RealExp, ComplexExp, IColor);*/
                }                    
                break;
		}
	}
    IColor = Menu->ItemIndex;
    DestroyMenu(Menu);
	return(IColor);
}

int ClsEditColorPalette(TConsole *Console, TRealExp *RealExp, 
TComplexExp *ComplexExp, int ICPE)
{
    TMenu       *Menu;
	int         i, OldCol, Col = 0, x, y, Num, BlockSize, Key, MenuXPos, 
                CPEMenuWidth, MTMenuWidth, CPEMaxItemLength, MTMaxItemLength;
    char        **CPEStr = GetItemStrings("CPEMENU",
                &CPEMenuWidth, &CPEMaxItemLength, 9), 
                **MTStr = GetItemStrings("MISCTEXTS",
                &MTMenuWidth, &MTMaxItemLength, 5);
    
    Console->CursorMode = _NOCURSOR;
    
    if(MTStr == NULL) {
        MTStr = (char **) MiscTexts;
        CPEMaxItemLength = 22;
        CPEMenuWidth = 22;
    }

    if(CPEStr == NULL) {
        CPEMenuWidth = 22;
        Menu = CreateMenu("EDIT COLOR-PALETTE:", 23, 10, ICPE,
        8, CPEMaxItemLength, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 8, 
        (1 << M_HEADER) + (1 << M_STATUSBAR), EditColPalItems);
    }
    else {
        MenuXPos = (80 - CPEMenuWidth) / 2;
        Menu = CreateMenu(CPEStr[0], MenuXPos, 10, ICPE, 8, CPEMaxItemLength, 0, 
        LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 8, 
        (1 << M_HEADER) + (1 << M_STATUSBAR), EditColPalItems);
        for(i = 1; i <= 8; i++) Menu->Items[i - 1]->Caption = CPEStr[i];
    }

    Col = atoi(Menu->Items[0]->Contents);
    sprintf(Menu->Items[0]->Contents, "%3d", Col);
    sprintf(Menu->Items[2]->Contents, "%3d", SE(Palette[Col].r));
    sprintf(Menu->Items[3]->Contents, "%3d", SE(Palette[Col].g));
    sprintf(Menu->Items[4]->Contents, "%3d", SE(Palette[Col].b));

    DrawMenu(Console, Menu);
    DrawStatusBar(Console, Menu, 1599);

    /* Draw Palette */

    BlockSize = 20;
    x = 0;
    y = 0;
    for(i = 0; i <= 15; i++) {
        rectfill(screen, x * BlockSize + 6, y * BlockSize + 6,
        x * BlockSize + BlockSize, y * BlockSize + BlockSize, i);
        x++; 
    }

    rect(screen, Col * BlockSize + 3, 0 * BlockSize + 3,
    Col * BlockSize + BlockSize + 3, BlockSize + 3, 15);
    
	while(TRUE) {

        if(Key == KEY_LEFT || Key == KEY_RIGHT || Key == KEY_PGUP ||
        Key == KEY_PGDN) {
            
            sprintf(Menu->Items[0]->Contents, "%3d", Col);
            Col = atoi(Menu->Items[0]->Contents);
            DrawItem(Console, Menu, Menu->Items[0]);

            rect(screen, OldCol * BlockSize + 3, 0 * BlockSize + 3,
            OldCol * BlockSize + BlockSize + 3, BlockSize + 3, 0);

            rect(screen, Col * BlockSize + 3, 0 * BlockSize + 3,
            Col * BlockSize + BlockSize + 3, BlockSize + 3, 15);
                    
            sprintf(Menu->Items[2]->Contents, "%3d", SE(Palette[Col].r));
            SE(Palette[Col].r) = atoi(Menu->Items[2]->Contents);
            DrawItem(Console, Menu, Menu->Items[2]);

            sprintf(Menu->Items[3]->Contents, "%3d", SE(Palette[Col].g));
            SE(Palette[Col].g) = atoi(Menu->Items[3]->Contents);
            DrawItem(Console, Menu, Menu->Items[3]);

            sprintf(Menu->Items[4]->Contents, "%3d", SE(Palette[Col].b));
            SE(Palette[Col].b) = atoi(Menu->Items[4]->Contents);
            DrawItem(Console, Menu, Menu->Items[4]);
            
            set_palette(SE(Palette));
            set_palette_range(SE(Palette), 0, 15, FALSE);
		}

        Key = DoMenu(Console, Menu);
        
        if(Key == KEY_ESC) break;
		
        switch(Menu->ItemIndex) {
			case 0:
                if(Key == KEY_RIGHT) if(Col < 15) { OldCol = Col; Col++; } 
                if(Key == KEY_LEFT) if(Col > 0) { OldCol = Col; Col--; }
                break;
			case 1:
			case 2:
                if(Key == KEY_RIGHT) 
                    if(SE(Palette[Col].r) < 63) SE(Palette[Col].r++);
                if(Key == KEY_LEFT) 
                    if(SE(Palette[Col].r) > 0) SE(Palette[Col].r--);
                if(Key == KEY_PGUP) 
                    if(SE(Palette[Col].r) <= 56) SE(Palette[Col].r+=7);
                if(Key == KEY_PGDN) 
                    if(SE(Palette[Col].r) >= 7) SE(Palette[Col].r-=7);
                break;
            case 3:
                if(Key == KEY_RIGHT) 
                    if(SE(Palette[Col].g) < 63) SE(Palette[Col].g++);
                if(Key == KEY_LEFT) 
                    if(SE(Palette[Col].g) > 0) SE(Palette[Col].g--);
                if(Key == KEY_PGUP) 
                    if(SE(Palette[Col].g) <= 56) SE(Palette[Col].g+=7);
                if(Key == KEY_PGDN) 
                    if(SE(Palette[Col].g) >= 7) SE(Palette[Col].g-=7);
                break;
            case 4:
                if(Key == KEY_RIGHT) 
                    if(SE(Palette[Col].b) < 63) SE(Palette[Col].b++);
                if(Key == KEY_LEFT) 
                    if(SE(Palette[Col].b) > 0) SE(Palette[Col].b--);
                if(Key == KEY_PGUP) 
                    if(SE(Palette[Col].b) <= 56) SE(Palette[Col].b+=7);
                if(Key == KEY_PGDN) 
                    if(SE(Palette[Col].b) >= 7) SE(Palette[Col].b-=7);
                break;
            case 5:
                break;
			case 6:
                if(Key == KEY_ENTER) {
                }
                break;
			case 7:
                if(Key == KEY_ENTER) {
                }
                break;
            default:
                break;
		}
	}
    ICPE = Menu->ItemIndex;
    DestroyMenu(Menu);
    Console->CursorMode = _SOLIDCURSOR;
	return(ICPE);
}

int ClsMnuFiles(TConsole *Console, TRealExp *RealExp, TComplexExp *ComplexExp, 
int *ItemF)
{
    TMenu       *Menu;
	int         i, Key, MenuXPos, FMenuWidth, MTMenuWidth,
                FMaxItemLength, MTMenuItemLength;
    char        **FStr = GetItemStrings("FILEMENU", &FMenuWidth, 
                &FMaxItemLength, 5),
                **MTStr = GetItemStrings("MISCTEXT", &MTMenuWidth, 
                &MTMenuItemLength, 6), 
                FilePath[2048] = "default.par";

    if(MTStr == NULL) {
        MTStr = (char **) MiscTexts;
        FMaxItemLength = 28;
        FMenuWidth = 28;
    }

    if(FStr == NULL) {
        FMenuWidth = 28;
        Menu = CreateMenu("FILE - MENU:", 23, 10, *ItemF, 4, FMenuWidth, 
        0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 4, 
        (1 << M_HEADER) + (1 << M_STATUSBAR), FilesItems);
    }
    else {
        MenuXPos = (80 - FMenuWidth) / 2;
        Menu = CreateMenu(FStr[0], MenuXPos, 10, *ItemF,
        4, FMenuWidth, 0, LIGHTGRAY, BLACK, BLACK, LIGHTGRAY, 4, 
        (1 << M_HEADER) + (1 << M_STATUSBAR), FilesItems);
        for(i = 1; i <= 4; i++) Menu->Items[i - 1]->Caption = FStr[i];
    }
        
    a_clrscr(Console);
    DrawMenu(Console, Menu);

	while(TRUE) {

        Key = DoMenu(Console, Menu);

        if(Key == KEY_ESC) break;
        
		switch(Menu->ItemIndex) {
			case 0:
                if(Key == KEY_ENTER) {
                    if(file_select_ex((MTStr == NULL) ? MiscTexts[4] : MTStr[4],
                    FilePath, "PAR", 2047, 300, 400) != 0) {
                        scare_mouse();
                        if(Functiontype == FT_REAL) 
                            LoadRealExp(RealExp, FilePath, TRUE);
                        else
                            LoadComplexExp(ComplexExp, FilePath, TRUE);
                        unscare_mouse();
                        SetCoo(Functiontype, RealExp, ComplexExp);
                    }
                }
                break;
            case 1:
                if(Key == KEY_ENTER) {
                    strcpy(FilePath, "default.prm");
                }
                break;
			case 3:
                if(Key == KEY_ENTER) {
                    strcpy(FilePath, "default.par");
                    if(file_select_ex((MTStr == NULL) ? MiscTexts[5] : MTStr[5],
                    FilePath, "PAR", 2047, 300, 400) != 0) {
                        scare_mouse();
                        if(Functiontype == FT_REAL)
                            SaveRealExp(RealExp, FilePath);
                        else
                            SaveComplexExp(ComplexExp, FilePath);
                        unscare_mouse();
                    }
                }
				break;
		}
	}

    *ItemF = Menu->ItemIndex;
    DestroyMenu(Menu);

	return 0;
}

int ClsMnuAbout(TConsole *Console)
{
    a_clrscr(Console);
	a_textcolor(Console, GREEN);
    a_gotoxy(Console, 6, 1);
    a_cputs(Console,
    "Please read this document carefully before using this software:");
	a_textcolor(Console, YELLOW);
    a_gotoxy(Console, 6, 3);
    a_cputs(Console, 
    "XFuniter V2.2.3 Copyright (C) 1995-2003 Stijn Wolters.");
    a_gotoxy(Console, 6, 4);
    a_cputs(Console, 
    "Original idea: Ernic Kamerich (University of Nijmegen).");
	a_textcolor(Console, GREEN);
    a_gotoxy(Console, 6, 6);
	a_cputs(Console, 
    "See README for contact information.");
    a_gotoxy(Console, 6, 8);
    a_textcolor(Console, RED);
	a_cputs(Console, 
    "This program is free software; you can redistribute it and/or modify ");
    a_gotoxy(Console, 6, 9);
	a_cputs(Console, 
    "it under the terms of the GNU General Public License as published by");
    a_gotoxy(Console, 6, 10);
	a_cputs(Console, 
    "the Free Software Foundation; either version 2 of the License, or");
    a_gotoxy(Console, 6, 11);
	a_cputs(Console, 
    "(at your option) any later version.");
    a_gotoxy(Console, 6, 13);
	a_cputs(Console, 
    "This program is distributed in the hope that it will be useful,");
    a_gotoxy(Console, 6, 14);
	a_cputs(Console, 
    "but WITHOUT ANY WARRANTY; without even the implied warranty of");
    a_gotoxy(Console, 6, 15);
	a_cputs(Console, 
    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the");
    a_gotoxy(Console, 6, 16);
	a_cputs(Console, 
    "GNU General Public License for more details.");
    a_gotoxy(Console, 6, 18);
	a_cputs(Console, 
    "You should have received a copy of the GNU General Public License");
    a_gotoxy(Console, 6, 19);
	a_cputs(Console, 
    "along with this program; if not, write to the Free Software");
    a_gotoxy(Console, 6, 20);
	a_cputs(Console, 
    "Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307");  
    a_gotoxy(Console, 6, 21);
    a_cputs(Console, "USA");
    a_textcolor(Console, LIGHTGREEN);
    a_gotoxy(Console, 6, 23); 
    a_cprintf(Console,
    "Funiter was last compiled on %s at %s", __DATE__, __TIME__);
	a_textcolor(Console, GREEN);
    a_gotoxy(Console, 6, 25);
	a_cputs(Console, 
    "See COPYING for more information.");               
	a_textcolor(Console, WHITE);
    a_gotoxy(Console, 51, 25);
    a_cputs(Console, "[Hit a key to continue]");

    clear_keybuf();    
    readkey();
    clear_keybuf();    
    return 0;
}
