/*
	This file is part of XFuniter.

	cntmenu.c V2.2.3 - Funiter's (old) central menu routine.

	Copyright (C) 1995-2003 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen). 

	See README for contact information.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version. See

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	See COPYING for more information.
*/

#include "cntmenu.h"

static const TItem

    RJItems[8] = {

        /* Zoom is not for the combination 'web/step' */

        {   "ENTER    - Select area (zoom) ", NULL, 0, 0, 0, 1, 96  },
		{   "<T>      - Change diagram type", NULL, 0, 0, 0, 1, 96  },
		{   "Space    - Orbit diagram var.x", NULL, 0, 0, 0, 1, 96  },
        {   "<S>      - Save menu          ", NULL, 0, 0, 0, 1, 96  },
        {   "ESCAPE   - To parameter menu  ", NULL, 0, 0, 0, 1, 96  },

        /* 1 & 2 are changed for 'orbit diagram var. x' */

        {   "BkSp     - Step-by-step iter. ", NULL, 0, 0, 0, 1, 96  },
        {   "BkSp     - Orbit diagram var.x", NULL, 0, 0, 0, 1, 96  },
        {   "Space    - Orbit diagram var.c", NULL, 0, 0, 0, 1, 96  }
    },

    RJSItems[5] = {

        {   "<W>     - Webdiagram             ", NULL, 0, 0, 0, 1, 96  },
		{   "<I>     - Iteration values       ", NULL, 0, 0, 0, 1, 96  },
		{   "<S>     - Stepdiagram            ", NULL, 0, 0, 0, 1, 96  },
        {   "<C>     - Combination: Web & Step", NULL, 0, 0, 0, 1, 96  },
        {   "ESCAPE  - Previous menu          ", NULL, 0, 0, 0, 1, 96  } 

    },
    
    CJItems[8] = {

        {   "ENTER    - Select area (zoom)     ", NULL, 0, 0, 0, 1, 96  },
		{   "<T>      - Change diagram type    ", NULL, 0, 0, 0, 1, 96  },
        {   "BkSp     - Step-by-step iteration ", NULL, 0, 0, 0, 1, 96  },
        {   "Space    - Mandelbrot set         ", NULL, 0, 0, 0, 1, 96  },
        {   "<S>      - Save menu              ", NULL, 0, 0, 0, 1, 96  },
        {   "ESCAPE   - To parameter menu      ", NULL, 0, 0, 0, 1, 96  }, 

        {   "Space    - Julia set              ", NULL, 0, 0, 0, 1, 96  },
        {   "BkSp     - Julia set              ", NULL, 0, 0, 0, 1, 96  }
    },

    CJSItems[3] = {
        
        {   "<1>    - Iteration         ", NULL, 0, 0, 0, 1, 96 },
        {   "<2>    - Inverse iteration ", NULL, 0, 0, 0, 1, 96 },
        {   "ESCAPE - Previous menu     ", NULL, 0, 0, 0, 1, 96 }
    },
    
    CJSSItems[5] = {
    
        {   "<P>    - Point         ", NULL, 0, 0, 0, 1, 96 },
        {   "<L>    - Line          ", NULL, 0, 0, 0, 1, 96 },
        {   "<R>    - Rectangle     ", NULL, 0, 0, 0, 1, 96 },
        {   "<C>    - Circle        ", NULL, 0, 0, 0, 1, 96 },
        {   "ESCAPE - Previous menu ", NULL, 0, 0, 0, 1, 96 }
    },
    
    CJSCItems[4] = {
    
        {   "<S>    - Color depends on startingpoint ", NULL, 0, 0, 0, 1, 96 },
        {   "<I>    - Color depends on iter. steps   ", NULL, 0, 0, 0, 1, 96 },
        {   "<A>    - All iterationsteps same color  ", NULL, 0, 0, 0, 1, 96 },
        {   "ESCAPE - To previous menu               ", NULL, 0, 0, 0, 1, 96 }
    },
    
    CJOItems[7] = {
    
	    {   "Julia:                             ", NULL, 0, 0, 0, 1, 96 },
	    {   "<F>    -  Filled-in                ", NULL, 0, 0, 0, 1, 96 },
	    {   "<E>    -  Escape time              ", NULL, 0, 0, 0, 1, 96 },
	    {   "<B>    -  Boundary trace           ", NULL, 0, 0, 0, 1, 96 },
	    {   "<I>    -  Inverse iteration method ", NULL, 0, 0, 0, 1, 96 },
	    {   "ESCAPE -  Previous menu            ", NULL, 0, 0, 0, 1, 96 },

        {   "Mandelbrot:                        ", NULL, 0, 0, 0, 1, 96 }
    
    },
       
    CSItems[5] = {

        {   "<P>    - Postscript (Portrait) ", NULL, 0, 0, 0, 1, 96  },
		{   "<L>    - Postscript (Landscape)", NULL, 0, 0, 0, 1, 96  },
		{   "<X>    - PC Paintbrush PCX     ", NULL, 0, 0, 0, 1, 96  },
        {   "<R>    - Parameters            ", NULL, 0, 0, 0, 1, 96  },
        {   "ESCAPE - To previous menu      ", NULL, 0, 0, 0, 1, 96  }

    };

static char

    F1KeyStr[] = "[ F1 ] = Help.",

    CalcHelpStr[] = "Working: <Escape> aborts.",
    
    *ZoomHelpStr[] = {

		"ENTER    - Select area (zoom)    ",
		"ESCAPE   - Abort selection       ",
		"PGUP     - Smaller rect          ",
		"PGDN     - Larger rect           ",
		"0..9     - Skip n pixels (faster)",
        "ENTER    - Continue selection    "
    },

    *RealComplexStepHelpStr[] = {

		"ENTER    - Iterate         ",
		"DELETE   - Erase screen    ",
		"ESCAPE   - To central menu "
    },

    *ComplexStepInvHelpStr[] = {

		"<=>      - Both roots       ",
		"<+>      - Pos. root        ",
		"<->      - Neg. root        ",
		"ENTER    - Random root      ",
		"Delete   - Erase screen     ",
		"Escape   - To central menu  "
    
    },

    *DefPointHelpStr[] = {
    
        "Mouse position indicates ",
        "starting point.          ",
		"Escape - To central menu ",
    },
    
    *DefShapeHelpStr[] = {  
        
        "ENTER      - Start selection   ",
		"L-button   - First/second point",
		"R-button   - New selection     ",
		"Escape     - To central menu   ",
    
    },
    
    *RealJumpStr[] = {

        "Move mouse       - Change value      ",
        "ENTER / L-button - Select value      ",
        "ESCAPE           - To parameter menu "
    },
        
    *CplJumpHelpStr[] = {
    
        "Move mouse - Change value      ",
        "L-button   - Julia             ",
        "R-button   - Inverse Julia     ",
        "<P>        - Preview Julia     ",
        "ENTER      - Select value      ",
        "ESCAPE     - To parameter menu "
    };
    

int MnuDraw(int Functiontype, TRealExp *RealExp, TComplexExp *ComplexExp)
{
    int     MSGMenuWidth, MSGMaxItemLength, CDSMenuWidth, CDSMaxItemLength, 
            CSMenuWidth, CSMaxItemLength, RSMenuWidth, RSMaxItemLength, 
            CentralMenuStatus = 0;
    char    **MSGStr = GetItemStrings("MESSAGES", &MSGMenuWidth,
                &MSGMaxItemLength, 7),
            **CDSStr = GetItemStrings("CDEFSHAPEHELP", &CDSMenuWidth, 
                &CDSMaxItemLength, 4),
            **CSStr = GetItemStrings("CSTEPHELP", &CSMenuWidth, 
                &CSMaxItemLength, 6),
            **RSStr = GetItemStrings("RSTEPHELP", &RSMenuWidth,
                &RSMaxItemLength, 3);
                
    scare_mouse();
    if(!Functiontype) {
        while(CentralMenuStatus != -1) {
            StatusBar(RealExp->Settings.LAY_Statusline, RealExp->Graph,
            -1, (MSGStr != NULL) ? MSGStr[6] : CalcHelpStr);
            
            RealDraw(RealExp, (RSStr != NULL) ? RSStr : RealComplexStepHelpStr);

            CentralMenuStatus = DoRCentralMenu(RealExp);
        }
    }
    else {
        while(CentralMenuStatus != -1) {
            StatusBar(ComplexExp->Settings.LAY_Statusline, -1,
            ComplexExp->Graph, (MSGStr != NULL) ? MSGStr[6] : CalcHelpStr);
            
            ComplexDraw(ComplexExp, 
            (RSStr != NULL) ? RSStr : RealComplexStepHelpStr, 
            (CSStr != NULL) ? CSStr : ComplexStepInvHelpStr, 
            (MSGStr != NULL) ? MSGStr : DefPointHelpStr, 
            (CDSStr != NULL) ? CDSStr : DefShapeHelpStr);
            
            CentralMenuStatus = DoCCentralMenu(ComplexExp);
        }
    }
    unscare_mouse();
    return 0;
}

static int RStepSubMenu(TRealExp *RealExp)
{
    TConsole            *Console;
	TMenu               *Menu; 
    int                 AltKey, ExitValue, RSMenuWidth, RSMaxItemLength, i = 0;
    char                **RSStr = GetItemStrings("RJSUBMENU", &RSMenuWidth, 
                        &RSMaxItemLength, 6);

    /* Diagram selection for 'Step by step iteration' */

    if(RSStr == NULL) {
        Console = alconio_init(35, 7, 1, BLACK, GRAY);
        Menu = CreateMenu("", 1, 1, 0, 5, 33, 0, BLACK, WHITE, WHITE, BLACK,
        5, 0, RJSItems);
    }
    else {
        Console = alconio_init(RSMaxItemLength + 2, 7, 1, BLACK, GRAY);
        Menu = CreateMenu("", 1, 1, 0, 5, RSMaxItemLength, 0, BLACK, WHITE,
        WHITE, BLACK, 5, 0, RJSItems);
        for(i = 0; i <= 4; i++) Menu->Items[i]->Caption = RSStr[i];
    }

    DrawMenu(Console, Menu);
    
    ExitValue = 0;
    while(TRUE) {
        AltKey = DoMenu(Console, Menu);

        if((AltKey == KEY_W) || ((Menu->ItemIndex == 0) &&
        (AltKey == KEY_ENTER))) {
            RealExp->Diagram = DM_WEB;
            break;
        }
        if((AltKey == KEY_I) || ((Menu->ItemIndex == 1) &&
        (AltKey == KEY_ENTER))) {
            RealExp->Diagram = DM_ITERVALUES;
            break;
        }
        if((AltKey == KEY_S) || ((Menu->ItemIndex == 2) &&
        (AltKey == KEY_ENTER))) {
            RealExp->Diagram = DM_STEP;
            break;
        }
        if((AltKey == KEY_C) || ((Menu->ItemIndex == 3) &&
        (AltKey == KEY_ENTER))) {
            RealExp->Diagram = DM_WEB;
            break;
        }
        if((AltKey == KEY_ESC) || ((Menu->ItemIndex == 4) &&
        (AltKey == KEY_ENTER))) {
            ExitValue = -1;
            break;
        }
        else
            continue;
    }
    
    DestroyMenu(Menu);
    a_putimage(Console, Console->ScreenContents);
    alconio_exit(Console);

    return ExitValue;               
}

static int CStepColorSubMenu(TComplexExp *ComplexExp)
{
    TConsole            *Console;
	TMenu               *Menu;
    int                 AltKey, ExitValue, CSMenuWidth, CSMaxItemLength, i = 0;
    char                **CSStr = GetItemStrings("CJSTEPCOLORMENU",
                        &CSMenuWidth, &CSMaxItemLength, 5);

    if(CSStr == NULL) {
        Console = alconio_init(42, 6, 1, BLACK, GRAY);
        Menu = CreateMenu("", 1, 1, 0, 4, 40, 0, BLACK, WHITE, WHITE, BLACK,
        4, 0, CJSCItems);
    }
    else {
        Console = alconio_init(CSMaxItemLength + 2, 6, 1, BLACK, GRAY);
        Menu = CreateMenu("", 1, 1, 0, 4, CSMaxItemLength, 0, BLACK, WHITE,
        WHITE, BLACK, 4, 0, CJSCItems);
        for(i = 0; i <= 3; i++) Menu->Items[i]->Caption = CSStr[i];
    }

    DrawMenu(Console, Menu);

    ExitValue = 0;
    while(TRUE) {
        AltKey = DoMenu(Console, Menu);

        if((AltKey == KEY_S) || ((Menu->ItemIndex == 0) &&
        (AltKey == KEY_ENTER))) {
            ComplexExp->Coloring = CM_START;
            break;
        }
        if((AltKey == KEY_A) || ((Menu->ItemIndex == 1) &&
        (AltKey == KEY_ENTER))) {
            ComplexExp->Coloring = CM_ITERSTEP;
            break;
        }
        if((AltKey == KEY_I) || ((Menu->ItemIndex == 2) &&
        (AltKey == KEY_ENTER))) {  
            ComplexExp->Coloring = CM_SAME;
            break;
        }
        if((AltKey == KEY_ESC) || ((Menu->ItemIndex == 4) &&
        (AltKey == KEY_ENTER))) {  
            ExitValue = -1;
            break;
        }
        else
            continue;
    }
    DestroyMenu(Menu);
    a_putimage(Console, Console->ScreenContents);
    alconio_exit(Console);
    return ExitValue;
}

static int CStepShapeSubMenu(TComplexExp *ComplexExp)
{
    TConsole            *Console;
	TMenu               *Menu;
    int                 AltKey, ExitValue, CSMenuWidth, CSMaxItemLength, i = 0;
    char                **CSStr = GetItemStrings("CJSTEPSHAPEMENU", 
                        &CSMenuWidth, &CSMaxItemLength, 5);
    if(CSStr == NULL) {
        Console = alconio_init(25, 7, 1, BLACK, GRAY);
        Menu = CreateMenu("", 1, 1, 0, 5, 23, 0, BLACK, WHITE, WHITE, BLACK, 
        5, 0, CJSSItems);
    }
    else {
        Console = alconio_init(CSMaxItemLength + 2, 7, 1, BLACK, GRAY);
        Menu = CreateMenu("", 1, 1, 0, 5, CSMaxItemLength, 0, BLACK, WHITE, 
        WHITE, BLACK, 5, 0, CJSSItems);
        for(i = 0; i <= 4; i++) Menu->Items[i]->Caption = CSStr[i];
    }

    DrawMenu(Console, Menu);
    
    ExitValue = 0;
    while(TRUE) {
        AltKey = DoMenu(Console, Menu);

        if((AltKey == KEY_P) || ((Menu->ItemIndex == 0) &&
        (AltKey == KEY_ENTER))) {
            ComplexExp->Diagram = SH_POINT;
            if(CStepColorSubMenu(ComplexExp) == -1) {
                Console->BkCol = GRAY;
                DrawMenu(Console, Menu); 
                continue;
            }
            break;
        }
        if((AltKey == KEY_L) || ((Menu->ItemIndex == 1) &&
        (AltKey == KEY_ENTER))) { 
            ComplexExp->Diagram = SH_LINE;
            if(CStepColorSubMenu(ComplexExp) == -1) { 
                Console->BkCol = GRAY;
                DrawMenu(Console, Menu); 
                continue;
            }
            break;
        }
        if((AltKey == KEY_R) || ((Menu->ItemIndex == 2) &&
        (AltKey == KEY_ENTER))) {  
            ComplexExp->Diagram = SH_RECT;
            if(CStepColorSubMenu(ComplexExp) == -1) { 
                Console->BkCol = GRAY;
                DrawMenu(Console, Menu); 
                continue;
            }
            break;
        }
        if((AltKey == KEY_C) || ((Menu->ItemIndex == 3) &&
        (AltKey == KEY_ENTER))) {  
            ComplexExp->Diagram = SH_CIRCLE;
            if(CStepColorSubMenu(ComplexExp) == -1) { 
                Console->BkCol = GRAY;
                DrawMenu(Console, Menu); 
                continue;
            }
            break;
        }
        if((AltKey == KEY_ESC) || ((Menu->ItemIndex == 4) &&
        (AltKey == KEY_ENTER))) {  
            ExitValue = -1;
            break;
        }
        else
            continue;
    }
    DestroyMenu(Menu);
    a_putimage(Console, Console->ScreenContents);
    alconio_exit(Console);
    return ExitValue;
}

/*
**  Mode:       TRUE    : text corresponding to actual graph,
**              FALSE   : text corresponding to oposite graph.
*/

static int CStepOrbitsSubMenu(TComplexExp *ComplexExp, int Mode)
{
    TConsole            *Console;
	TMenu               *Menu; 
    int                 AltKey, ExitValue, CSMenuWidth, CSMaxItemLength, 
                        COMenuWidth, COMaxItemLength, i = 0;
    char                **CSStr = GetItemStrings("CJSTEPMENU", &CSMenuWidth, 
                        &CSMaxItemLength, 3),
                        **COStr = GetItemStrings("CJORBITMENU", &COMenuWidth,
                        &COMaxItemLength, 7);

    /* Graph selection for 'Step by step iteration' */

    if((ComplexExp->Graph == GR_C_STEP || ComplexExp->Graph == GR_C_STEPINV)) {
        
        if(CSStr == NULL) {
            Console = alconio_init(29, 5, 1, BLACK, GRAY);
            Menu = CreateMenu("", 1, 1, 0, 3, 27, 0, BLACK, WHITE, WHITE, BLACK, 
            3, 0, CJSItems);
        }
        else {
            Console = alconio_init(CSMaxItemLength + 2, 5, 1, BLACK, GRAY);
            Menu = CreateMenu("", 1, 1, 0, 3, CSMaxItemLength, 0, BLACK, WHITE, 
            WHITE, BLACK, 3, 0, CJSItems);
            for(i = 0; i <= 2; i++) Menu->Items[i]->Caption = CSStr[i];
        }

        DrawMenu(Console, Menu);
        ExitValue = 0;
        while(TRUE) {
            AltKey = DoMenu(Console, Menu);

            if((AltKey == KEY_ESC) || ((Menu->ItemIndex == 2) && 
            (AltKey == KEY_ENTER))) {
                ExitValue = -1;
                break;
            }   

            if(((AltKey == KEY_1) || (AltKey == KEY_1_PAD)) || 
            ((Menu->ItemIndex == 0) && (AltKey == KEY_ENTER))) {
                ComplexExp->Graph = GR_C_STEP;
                if(CStepShapeSubMenu(ComplexExp) == -1) {
                    Console->BkCol = GRAY;
                    DrawMenu(Console, Menu);
                    continue;
                }
                break;
            }
            if(((AltKey == KEY_2) || (AltKey == KEY_2_PAD)) || 
            ((Menu->ItemIndex == 1) && (AltKey == KEY_ENTER))) {
                ComplexExp->Graph = GR_C_STEPINV;
                if(CStepShapeSubMenu(ComplexExp) == -1) {
                    Console->BkCol = GRAY;
                    DrawMenu(Console, Menu);
                    continue;
                }
                break;
            }
            else 
                continue;
        }
        DestroyMenu(Menu);
        a_putimage(Console, Console->ScreenContents);
        alconio_exit(Console);
    }

    /* Diagram selection for orbit-diagrams */

    else {
        if(COStr == NULL) {
            Console = alconio_init(37, 8, 1, BLACK, GRAY);
            Menu = CreateMenu("", 1, 1, 0, 6, 35, 0, BLACK, WHITE, WHITE, BLACK, 
            7, 0, CJOItems);
        }
        else {
            Console = alconio_init(COMaxItemLength + 2, 8, 1, BLACK, GRAY);
            Menu = CreateMenu("", 1, 1, 0, 6, COMaxItemLength, 0, BLACK, WHITE, 
            WHITE, BLACK, 7, 0, CJOItems);
            for(i = 0; i <= 5; i++) Menu->Items[i]->Caption = COStr[i];
        }

        /* Set correct captions */
        
        if(ComplexExp->Graph == GR_C_ORBITS_C) {
            SwapItemCaptions(&Menu->Items[(Mode) ? 0 : 6]->Caption,
            &Menu->Items[(Mode) ? 6 : 0]->Caption);
            Menu->Items[4]->Flag = 0;
        }    
        else {
            SwapItemCaptions(&Menu->Items[(Mode) ? 6 : 0]->Caption, 
            &Menu->Items[(Mode) ? 0 : 6]->Caption);
            Menu->Items[4]->Flag = 96;
        }
        
        DrawMenu(Console, Menu);

        ExitValue = 0;
        while(TRUE) {
            AltKey = DoMenu(Console, Menu);

            if((AltKey == KEY_F) || ((Menu->ItemIndex == 1) &&
            (AltKey == KEY_ENTER))) {
                ComplexExp->Diagram = DM_FILLED;
                break;
            }
            if((AltKey == KEY_E) || ((Menu->ItemIndex == 2) &&
            (AltKey == KEY_ENTER))) { 
                ComplexExp->Diagram = DM_ETD;
                break;
            }
            if((AltKey == KEY_B) || ((Menu->ItemIndex == 3) &&
            (AltKey == KEY_ENTER))) {  
                ComplexExp->Diagram = DM_BOUNDARY;
                break;
            }
            if(ComplexExp->Graph == GR_C_ORBITS_Z &&
            ((AltKey == KEY_I) || ((Menu->ItemIndex == 4) &&
            (AltKey == KEY_ENTER)))) {  
                ComplexExp->Diagram = DM_INVERSE;
                break;
            }
            if((AltKey == KEY_ESC) || ((Menu->ItemIndex == 5) &&
            (AltKey == KEY_ENTER))) {  
                ExitValue = -1;
                break;
            }
            else
                continue;
        }
        DestroyMenu(Menu);
        a_putimage(Console, Console->ScreenContents);
        alconio_exit(Console);
    }
    return ExitValue;               
}

int DoRCentralMenu(TRealExp *RealExp)
{
    TConsole            *Console;
	TMenu               *Menu; 
    int                 AltKey, ExitValue, OldGraph, NewGraph, MSGMenuWidth, 
                        MSGMaxItemLength, ZHMenuWidth, ZHMaxItemLength, 
                        RMenuWidth, RMaxItemLength, RJMenuWidth, 
                        RJMaxItemLength, i = 0;
    char                **RStr = GetItemStrings("RJMENU", &RMenuWidth, 
                        &RMaxItemLength, 5),
                        **RJStr = GetItemStrings("RJHELP", &RJMenuWidth,
                        &RJMaxItemLength, 3),
                        **ZHStr = GetItemStrings("ZOOMHELP", &ZHMenuWidth,
                        &ZHMaxItemLength, 5),
                        **MSGStr = GetItemStrings("MESSAGES", &MSGMenuWidth,
                        &MSGMaxItemLength, 7);

    /* Allocate space for menu */
    
    if(RStr == NULL) {
        Console = alconio_init(32, 7, 1, BLACK, GRAY);
        Menu = CreateMenu("", 1, 1, 0, 5, 30, 0, BLACK, WHITE, WHITE, BLACK, 
        8, 0, RJItems);
    }
    else {
        Console = alconio_init(RMaxItemLength + 2, 7, 1, BLACK, GRAY);
        Menu = CreateMenu("", 1, 1, 0, 5, RMaxItemLength, 0, BLACK, WHITE, 
        WHITE, BLACK, 8, 0, RJItems);
        for(i = 0; i <= 4; i++) Menu->Items[i]->Caption = RStr[i];
    }

    /* Set correct menu-texts */
        
    if(RealExp->Graph == GR_R_ORBITS_X) {
        SwapItemCaptions(&Menu->Items[1]->Caption, &Menu->Items[5]->Caption);
        SwapItemCaptions(&Menu->Items[2]->Caption, &Menu->Items[7]->Caption);
    }
    if(RealExp->Graph == GR_R_ORBITS_C) {
        SwapItemCaptions(&Menu->Items[1]->Caption, &Menu->Items[6]->Caption);
        Menu->Items[2]->Flag = 0;
    }

    DrawMenu(Console, Menu);

    OldGraph = RealExp->Graph;
    
    while(TRUE) {
        AltKey = DoMenu(Console, Menu);
        
        /* User canceled menu */
        
        if((AltKey == KEY_ESC) || ((Menu->ItemIndex == 4) &&
        (AltKey == KEY_ENTER))) {
            ExitValue = -1;
            break;
        }

        /* Zoom */

        if((AltKey == KEY_Z) || ((Menu->ItemIndex == 0) &&
        (AltKey == KEY_ENTER))) {

            /* Restore original image */

            a_putimage(Console, Console->ScreenContents);

            /* Zoom function */

            if(ZoomBox(screen, font, RealExp->GraphPar[RealExp->Graph].Coords,
            (ZHStr != NULL) ? ZHStr : ZoomHelpStr) != 0) {
                ExitValue = 0;
                break;
            }
            else {

                /* User canceled zoom-function */
                
                Console->BkCol = GRAY;
                DrawMenu(Console, Menu);
                continue;
            }
        }
        
        /* Change type (diagram for 'step-by-step iteration' */
        
        if((AltKey == KEY_T) || ((Menu->ItemIndex == 1) &&
        (AltKey == KEY_ENTER))) {
            if(RealExp->Graph == GR_R_STEP) {
                if(RStepSubMenu(RealExp) == 0) break; else continue;
            }
        }
        
        /* 
        **  Jump from 'step-by-step iteration' to 'orbitdiagram for var.x' or
        **  from 'orbitdiagram var. x' to 'orbitdiagram var. c' 
        */
        
        if((AltKey == KEY_SPACE) || ((Menu->ItemIndex == 2) &&
        (AltKey == KEY_ENTER))) { 

            /*
            **	Step by step iteration    --> Orbit diagram for variable x
            */

            if(RealExp->Graph == GR_R_STEP) {

                /* Restore part of screen */
            
                a_putimage(Console, Console->ScreenContents);

                NewGraph = RealJump(RealExp, GR_R_ORBITS_X, NULL, 
                (MSGStr != NULL) ? MSGStr[5] : F1KeyStr, 
                (RJStr != NULL) ? RJStr : RealJumpStr);

                if(NewGraph > -1) {
                    RealExp->Graph = NewGraph;
                    ExitValue = 0;
                    break;
                }
            }
           	
            /*
            **	Orbit diagram for variable x  --> Orbit diagram for variabele c
            */
            
            else if(RealExp->Graph == GR_R_ORBITS_X) {
                
                /* Restore part of screen */
            
                a_putimage(Console, Console->ScreenContents);

                NewGraph = RealJump(RealExp, GR_R_ORBITS_C, NULL, 
                (MSGStr != NULL) ? MSGStr[5] : F1KeyStr, 
                (RJStr != NULL) ? RJStr : RealJumpStr);
        
                if(NewGraph > -1) {
                    RealExp->Graph = NewGraph;
                    ExitValue = 0;
                    break;
                }
            }

            else {
                clear_keybuf();
                continue;
            }
        }
        
        /* Save image/parameters */
            
        if((AltKey == KEY_S) || ((Menu->ItemIndex == 3) &&
        (AltKey == KEY_ENTER))) 
            CntMnuSave(FT_REAL, RealExp, NULL);
        
        /* 
        **  Jump from 'orbitdiagram var. c' to 'orbitdiagram var. x' or
        **  from 'orbitdiagram var. x' to 'step-by-step iteration'
        */
        
        if((AltKey == KEY_BACKSPACE) || ((Menu->ItemIndex == 1) && 
        (AltKey == KEY_ENTER))) {
            
            /*
            **	Banendiagram variabele x  --> Step by step iteration
	        */

            if(RealExp->Graph == GR_R_ORBITS_X) {

                /* Restore part of screen */
            
                a_putimage(Console, Console->ScreenContents);

                NewGraph = RealJump(RealExp, GR_R_STEP, NULL,  
                (MSGStr != NULL) ? MSGStr[5] : F1KeyStr, 
                (RJStr != NULL) ? RJStr : RealJumpStr);
            
                if(NewGraph > -1) {
                    RealExp->Graph = NewGraph;
                    if(RStepSubMenu(RealExp) == 0) break; else continue;
                }
            }

            /*
	        **	Orbit diagram variable c  --> Banendiagram variabele x
	        */
            
            else if(RealExp->Graph == GR_R_ORBITS_C) {

                /* Restore part of screen */
            
                a_putimage(Console, Console->ScreenContents);

                NewGraph = RealJump(RealExp, GR_R_ORBITS_X, NULL,  
                (MSGStr != NULL) ? MSGStr[5] : F1KeyStr, 
                (RJStr != NULL) ? RJStr : RealJumpStr);
        
                if(NewGraph > -1) {
                    RealExp->Graph = NewGraph;
                    ExitValue = 0;
                    break;
                }
	        }

            else {
                clear_keybuf();
                continue;
            }
        }
    }
    clear_keybuf();
    DestroyMenu(Menu);
    a_putimage(Console, Console->ScreenContents);
    alconio_exit(Console);
    return ExitValue;
}

int DoCCentralMenu(TComplexExp *ComplexExp)
{
    TConsole            *Console;
	TMenu               *Menu; 
    int                 AltKey, ExitValue, OldGraph, NewGraph, ZHMenuWidth,
                        ZHMaxItemLength, CMenuWidth, CMaxItemLength, 
                        CJMenuWidth, CJMaxItemLength, MSGMenuWidth, 
                        MSGMaxItemLength, i = 0;
    char                **CStr = GetItemStrings("CJMENU", &CMenuWidth, 
                        &CMaxItemLength, 8),
                        **CJStr = GetItemStrings("CJHELP", &CJMenuWidth, 
                        &CJMaxItemLength, 6),
                        **ZHStr = GetItemStrings("ZOOMHELP", &ZHMenuWidth,
                        &ZHMaxItemLength, 5),
                        **MSGStr = GetItemStrings("MESSAGES", &MSGMenuWidth,
                        &MSGMaxItemLength, 7);

    /* Allocate space for menu */
    
    if(CStr == NULL) {
        Console = alconio_init(36, 8, 1, BLACK, GRAY);
        Menu = CreateMenu("", 1, 1, 0, 6, 34, 0, BLACK, WHITE, WHITE, BLACK, 
        8, 0, CJItems);
    }
    else {
        Console = alconio_init(CMaxItemLength + 2, 8, 1, BLACK, GRAY);
        Menu = CreateMenu("", 1, 1, 0, 6, CMaxItemLength, 0, BLACK, WHITE, 
        WHITE, BLACK, 8, 0, CJItems);
        for(i = 0; i <= 7; i++) Menu->Items[i]->Caption = CStr[i];
    }
    
    /*
    **  Set correct menu texts.
    */

    if(ComplexExp->Graph == GR_C_STEP || ComplexExp->Graph == GR_C_STEPINV) {
        SwapItemCaptions(&Menu->Items[3]->Caption, &Menu->Items[6]->Caption);
        Menu->Items[2]->Flag = 0;
    }
    
    if(ComplexExp->Graph == GR_C_ORBITS_C) {
        SwapItemCaptions(&Menu->Items[2]->Caption, &Menu->Items[7]->Caption);
        Menu->Items[3]->Flag = 0;
    }

    DrawMenu(Console, Menu);

    /*OldGraph = RealExp->Graph;*/
    
    while(TRUE) {
    
        AltKey = DoMenu(Console, Menu);
        
        /* User canceled menu */
        
        if((AltKey == KEY_ESC) || ((Menu->ItemIndex == 5) && 
        (AltKey == KEY_ENTER))) {
            ExitValue = -1;
            break;
        }
        
        /* Zoom */
        
        if((AltKey == KEY_Z) || ((Menu->ItemIndex == 0) && 
        (AltKey == KEY_ENTER))) {

            /* Restore original image */
            
            a_putimage(Console, Console->ScreenContents);
            
            /* Zoom function */
            
            if(ZoomBox(screen, font, 
            ComplexExp->GraphPar[ComplexExp->Graph].Coords,
            (ZHStr != NULL) ? ZHStr : ZoomHelpStr) != 0) {
                ExitValue = 0;
                break;
            }
            else {
            
                /* User canceled zoom-function */
                
                Console->BkCol = GRAY;
                DrawMenu(Console, Menu);
                continue;
            }
        }  
        
        /* Change type (diagram for 'step-by-step iteration' */
        
        if((AltKey == KEY_T) || ((Menu->ItemIndex == 1) &&
        (AltKey == KEY_ENTER))) {
            if(CStepOrbitsSubMenu(ComplexExp, TRUE) == 0) break; else continue;
        }

        if((AltKey == KEY_BACKSPACE) || ((Menu->ItemIndex == 2) && 
        (AltKey == KEY_ENTER))) {
            
            /* Restore part of screen */
            
            a_putimage(Console, Console->ScreenContents);
            
   	        /*
            **	Orbit diagram for variable c  --> Banendiagram for variabele z
            */
        
            if(ComplexExp->Graph == GR_C_ORBITS_C) {
                
                OldGraph = ComplexExp->Graph;
                ComplexExp->Graph = GR_C_ORBITS_Z;
                if(CStepOrbitsSubMenu(ComplexExp, FALSE) == -1) {                
                    ComplexExp->Graph = OldGraph;
                    Console->BkCol = GRAY;
                    DrawMenu(Console, Menu); 
                    continue;
                }
                else {
                    ComplexExp->Graph = OldGraph;
                    NewGraph = ComplexJump(ComplexExp, GR_C_ORBITS_Z, 
                    (MSGStr != NULL) ? MSGStr[5] : F1KeyStr,
                    (CJStr != NULL) ? CJStr : CplJumpHelpStr, TRUE);
                
                    if(NewGraph != -1) { ComplexExp->Graph = NewGraph; break; } 
                }
            }
    
   	        /*
            **	Orbit diagram for variable z  --> Step by step iteration (inv)
            */
        
            else if(ComplexExp->Graph == GR_C_ORBITS_Z) {
                OldGraph = ComplexExp->Graph; 
                ComplexExp->Graph = GR_C_STEP; 
                if(CStepOrbitsSubMenu(ComplexExp, FALSE) == 0) {
                    NewGraph = ComplexExp->Graph;
                    ComplexExp->Graph = OldGraph; 
                    ComplexJump(ComplexExp, NewGraph,  
                    (MSGStr != NULL) ? MSGStr[5] : F1KeyStr,
                    (CJStr != NULL) ? CJStr : CplJumpHelpStr, FALSE);
                    break; 
                }
                else { 
                    ComplexExp->Graph = OldGraph; 
                    continue;
                }
            }
        }

        if((AltKey == KEY_SPACE) || ((Menu->ItemIndex == 3) &&
        (AltKey == KEY_ENTER))) { 

            /* Restore part of screen */
            
            a_putimage(Console, Console->ScreenContents);

          	/*
            **	Step by step iteration (inv)  --> Orbit diagram for variable z
            */
        
            if((ComplexExp->Graph == GR_C_STEP) || 
            (ComplexExp->Graph == GR_C_STEPINV)) {
        
                NewGraph = ComplexJump(ComplexExp, GR_C_ORBITS_Z, 
                (MSGStr != NULL) ? MSGStr[5] : F1KeyStr,
                (CJStr != NULL) ? CJStr : CplJumpHelpStr, FALSE);

                if(NewGraph != -1) { 
                    ComplexExp->Graph = NewGraph; 
                    
                    if(CStepOrbitsSubMenu(ComplexExp, FALSE) == 0) 
                        break; 
                    else 
                        continue;
                }
            }
            
   	        /*
            **	Orbit diagram for variable z  --> Banendiagram for variabele c
            */
        
            else if(ComplexExp->Graph == GR_C_ORBITS_Z) {
            
                NewGraph = ComplexJump(ComplexExp, GR_C_ORBITS_C, 
                (MSGStr != NULL) ? MSGStr[5] : F1KeyStr,
                (CJStr != NULL) ? CJStr : CplJumpHelpStr, FALSE);
           
                if(NewGraph != -1) { 
                    ComplexExp->Graph = NewGraph; 
                    
                    if(CStepOrbitsSubMenu(ComplexExp, FALSE) == 0) 
                        break; 
                    else 
                        continue;
                }
            }
        }
            
        /* Save image/parameters */
            
        if((AltKey == KEY_S) || ((Menu->ItemIndex == 4) &&
        (AltKey == KEY_ENTER))) {
            a_putimage(Console, Console->ScreenContents);
            CntMnuSave(FT_COMPLEX, NULL, ComplexExp);
            Console->BkCol = GRAY;
            DrawMenu(Console, Menu);
        }
    }
    clear_keybuf();
    DestroyMenu(Menu);
    a_putimage(Console, Console->ScreenContents);
    alconio_exit(Console);
    return ExitValue;
}

int CntMnuSave(int Functiontype, TRealExp *RealExp, TComplexExp *ComplexExp)
{
    FILE                *fp;
    TConsole            *Console;
	TMenu               *Menu; 
    int                 AltKey, CSMenuWidth, MTMenuWidth, CSMaxItemLength, 
                        MTMaxItemLength, i = 0;
    char                **CSStr = GetItemStrings("CSAVEMENU", &CSMenuWidth, 
                        &CSMaxItemLength, 5),
                        **MTStr = GetItemStrings("MISCTEXTS",
                        &MTMenuWidth, &MTMaxItemLength, 5),
                        FilePath[2048] = "default.ps";
    
    if(CSStr == NULL) {
        Console = alconio_init(33, 7, 1, BLACK, GRAY);
        Menu = CreateMenu("", 1, 1, 0, 5, 31, 0, BLACK, WHITE, WHITE, BLACK, 
        5, 0, CSItems);
    }
    else {
        Console = alconio_init(CSMaxItemLength + 2, 7, 1, BLACK, GRAY);
        Menu = CreateMenu("", 1, 1, 0, 5, CSMaxItemLength, 0, BLACK, WHITE, 
        WHITE, BLACK, 5, 0, CSItems);
        for(i = 0; i <= 4; i++) Menu->Items[i]->Caption = CSStr[i];
    }
    DrawMenu(Console, Menu);
    
    while(TRUE) {
    
        AltKey = DoMenu(Console, Menu);
    
        /*
        **  Write Postscript Portrait.
        */
        
        if((AltKey == KEY_P) || ((Menu->ItemIndex == 0) &&
        (AltKey == KEY_ENTER))) { 
            if(file_select_ex((MTStr != NULL) ? MTStr[4] : "Save: ", 
            FilePath, "PS", 2047, 300, 400) != 0) {
                scare_mouse();
                a_putimage(Console, Console->ScreenContents);
                if((fp = fopen(FilePath, "w")) != NULL) {
                    WriteEPS(screen, SCREEN_W, SCREEN_H, fp, 0);
                    fclose(fp);
                }
                Console->BkCol = GRAY;
                DrawMenu(Console, Menu);
                unscare_mouse();
                break;
            }
        }

        /*
        **  Write Postscript Landscape.
        */

        if((AltKey == KEY_L) || ((Menu->ItemIndex == 1) &&
        (AltKey == KEY_ENTER))) { 
            if(file_select_ex((MTStr != NULL) ? MTStr[4] : "Save: ", 
            FilePath, "PS", 2047, 300, 400) != 0) {
                scare_mouse();
                a_putimage(Console, Console->ScreenContents);
                if((fp = fopen(FilePath, "w")) != NULL) {
                    WriteEPS(screen, SCREEN_W, SCREEN_H, fp, 1);
                    fclose(fp);
                }
                Console->BkCol = GRAY;
                DrawMenu(Console, Menu);
                unscare_mouse();
                break;
            }
        }

        /*
        **  Write PCX (PC Paintbrush format).
        */

        if((AltKey == KEY_X) || ((Menu->ItemIndex == 2) &&
        (AltKey == KEY_ENTER))) { 
            strcpy(FilePath, "default.pcx");
            if(file_select_ex((MTStr != NULL) ? MTStr[4] : "Save: ", 
            FilePath, "PCX", 2047, 300, 400) != 0) {
                scare_mouse();
                a_putimage(Console, Console->ScreenContents);
                if(Functiontype == FT_REAL) {
                    save_bitmap(FilePath, screen, RealExp->Settings.Palette); 
                }
                else {
                    save_bitmap(FilePath, screen, ComplexExp->Settings.Palette); 
                }
                Console->BkCol = GRAY;
                DrawMenu(Console, Menu);
                unscare_mouse();
                break;
            }
        }

        if((AltKey == KEY_R) || ((Menu->ItemIndex == 3) &&
        (AltKey == KEY_ENTER))) { 
        }

        if((AltKey == KEY_ESC) || ((Menu->ItemIndex == 4) &&
        (AltKey == KEY_ENTER))) {
            DestroyMenu(Menu);
            a_putimage(Console, Console->ScreenContents);
            alconio_exit(Console);
            return 1; 
        }
    }
    DestroyMenu(Menu);
    a_putimage(Console, Console->ScreenContents);
    alconio_exit(Console);
    return 0;
}
