/*
	This file is part of XFuniter.

	cntmenus.h V2.2.3 - Funiter's (old) central menu routine.

	Copyright (C) 1995-2003 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen).
    
	See README for contact information.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version. See

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	See COPYING for more information.
*/

#ifndef _CNTMENU
    #define _CNTMENU

    #include <stdio.h>
    #include <ctype.h>
    #include <allegro.h>
    #include "help.h"
    #include "estoui.h"
    #include "realexp.h"
    #include "cplexp.h"
    
    #define FT_COMPLEX         1
    #define FT_REAL            0

    int MnuDraw(int Functiontype, TRealExp *RealExp, TComplexExp *ComplexExp);
    int DoRCentralMenu(TRealExp *RealExp);
    int DoCCentralMenu(TComplexExp *ComplexExp);
    int CntMnuSave(int Functiontype, TRealExp *RealExp, 
        TComplexExp *ComplexExp);
#endif
