/*
	This file is part of XFuniter.

	main.c V2.2.3 - Funiter's main routine.

	Copyright (C) 1995-2003 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen).

	See README for contact information.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version. See

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	See COPYING for more information.
*/

#include <stdio.h>
#include <allegro.h>
#include "realexp.h"
#include "cplexp.h"
#include "clsmenus.h"

int main(int argc, char *argv[])
{
    char        LngFile[2048] = "english.mnu";
    int         i, res, card, width = 640, height = 480, color_depth;
    TConsole    *Console;
    TRealExp    *RealExp;
    TComplexExp *ComplexExp;

    /* Initialize graphics */
    
    set_uformat(U_ASCII);
    
    allegro_init();
    install_mouse();
    install_keyboard();
    install_timer();
    if(set_gfx_mode(GFX_SAFE, 640, 480, 0, 0) != 0) {
        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
        allegro_message("Error setting a graphmode!");
        exit(1);
    }

	/* Look for commandline options. */

    while(argc > 0) {
        for(i = 1; i < argc; i++) {
			if(strncmp(argv[i], "-l", 2) == 0) {
				strcpy(LngFile, argv[i] + 2);
                
			}
            else if(strncmp(argv[i], "-s", 2) == 0) {
                gfx_mode_select_ex(&card, &width, &height, &color_depth);
                if(set_gfx_mode(card, width, height, 0, 0) != 0) {
                    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
                    allegro_message("Error setting a graphmode!");
                    exit(1);
                }
            }
			else if((strncmp(argv[i], "-?", 2) == 0) ||
					(strncmp(argv[i], "-h", 2) == 0)) {
				printf("\nUsage: %s [-s] [-l<filename>] [-? | -h]", argv[0]);
		 		printf("\n-l<filename> = load a language file");
                printf("\n-s           = open dialog to select a graphicmode");
				printf("\n-? or -h     = help");
				printf("\n\nCommandline parameters are lowercase only!\n");
				return 0;
			}
			else {
				printf("Unknown command, use -h or -? for help.\n");
				return 0;
			}
		}
		argc--;
	}

    clear_keybuf();
    RealExp = CreateRealExp(0, 0, width, height - 20);
    ComplexExp = CreateComplexExp(0, 0, width, height - 20);

    Console = alconio_init(80, 30, 2, LIGHTGRAY, BLACK);
    InitClassicMenus(0, LngFile);
    ClsMnuMain(Console, RealExp, ComplexExp);
    alconio_exit(Console);
    
    allegro_exit();

    FreeComplexExp(ComplexExp);
    FreeRealExp(RealExp);
    return (res);
}
END_OF_MAIN()
