/*
	This file is part of XFuniter.

	coords.h V2.2.3 - drawing a grid, converting coordinates and zoom.

	Copyright (C) 1995-2003 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen)

	See README for contact information.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version. See

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	See COPYING for more information.
*/

#ifndef _COORDS
	#define _COORDS

	typedef struct {
		double  			XMin, YMin, XMax, YMax, Width, Height;
		unsigned int		XStart, YStart, XEnd, YEnd, Mode;
	} TCoords;

	#define CO_NOCOORDS		0
	#define CO_GRID			1
	#define CO_CALIBRATION	2
	#define CO_TEXT			3
	#define CO_XCOORDS		4
	#define CO_YCOORDS		5

	#define M2R_X(S,N)      ((((S).XEnd * ((N) - (S).XMin) / (S).Width) +   \
							(S).XStart))
	#define M2R_Y(S,N)      (((((S).YEnd - (S).YStart) * ((S).YMax - (N))   \
							/ (S).Height) + (S).YStart))

	#define R2M_X(S,N)     	((S).XMin + ((double) ((N) + (S).XStart) *      \
							(S).Width / (double) ((S).XEnd - (S).XStart)))
	#define R2M_Y(S,N)     	(((S).YMax - ((double) ((N) + (S).YStart) *     \
							((S).Height / (double) ((S).YEnd - (S).YStart)))))

	#define REAL_TO_MATH_X(S,N)		R2M_X(S,N)
	#define REAL_TO_MATH_Y(S,N)		R2M_Y(S,N)
	#define MATH_TO_REAL_X(S,N)		M2R_X(S,N)
	#define MATH_TO_REAL_Y(S,N)		M2R_Y(S,N)

	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <math.h>
    #include <allegro.h>
    #include "bitmanip.h"
	#include "help.h"

	TCoords *CreateCoords(double XMin, double YMin, double XMax, double YMax,
		unsigned int XStart, unsigned int YStart, unsigned int XEnd,
		unsigned int YEnd, int Mode);
    int SetCoords(TCoords *Coords, double XMin, double YMin, double XMax, 
        double YMax);
	void FreeCoords(TCoords *Coords);

    int ZoomBox(BITMAP *Bitmap, FONT *Font, TCoords *Coords, char *HelpText[]);
	int DrawGrid(BITMAP *Bitmap, const FONT *Font, TCoords *Coords);

#endif
