/*
	This file is part of XFuniter.

	estoui.c V2.2.3 - (was mover.c) Funiter's old menu routine.
    
    estoui = extremely simple text oriented user interface.
    
	Copyright (C) 1995-2003 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen).
    
	See README for contact information.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version. See

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	See COPYING for more information.
*/

#include "estoui.h"

/* string which holds the complete textfile for the menus. */

static char *MenuTexts;

void DrawStatusBar(TConsole *Console, TMenu *Menu, unsigned int Mode)
{
        char    *Keys[11] = { 
                    "Escape", "Enter/Return", 
                    "Cursor-", "Up", "Down", "Left", "Right", 
                    "Delete", "Backspace", "PGUP", "PGDN"
        };
        int     OldX, OldY, i; 

        OldX = a_wherex(Console);
        OldY = a_wherey(Console);        
	    /*a_textcolor(Console, Menu->BkCol); 
        a_textbackground(Console, Menu->FgCol);*/
	    a_gotoxy(Console,  0, 24); 
        for(i = 0; i <= 10; i++) 
            if(TSTBIT(Mode, i)) a_cprintf(Console, "%s ", Keys[i]);
        /*a_textcolor(Console, Menu->FgCol); 
        a_textbackground(Console, Menu->BkCol);*/
        a_gotoxy(Console, OldX, OldY);
}

void DrawCaption(TConsole *Console, int XPos, int YPos, char *CaptionStr)
{
	char 			*Caption, *TempCaption;
    int             TempYPos = YPos;
    
    Caption = strdup(CaptionStr);
	TempCaption = Caption;
	Caption = strtok(Caption, "\r");

    while(Caption != NULL) {

		a_gotoxy(Console, XPos, TempYPos);
		a_cputs(Console, Caption);

		TempYPos++;

        Caption = strtok(NULL, "\r");
	}
	free(TempCaption);
}

void DrawItemContents(TConsole *Console, TMenu *Menu, TItem *Item)
{
    int     XPos = strlen(Item->Caption) + 2 + Item->XPos;
    
	a_textcolor(Console, Menu->FgCol); a_textbackground(Console, Menu->BkCol);
    if(Item->Contents != NULL) {
        a_gotoxy(Console, XPos, Item->YPos);
        a_cprintf(Console, "%.*s", Item->Width, Item->Contents);
        a_gotoxy(Console, XPos - 1, Item->YPos); 
        if(TSTBIT(Item->Flag, I_EDIT)) a_cprintf(Console, "[");
        a_gotoxy(Console, XPos + Item->Width, Item->YPos); 
        if(TSTBIT(Item->Flag, I_EDIT)) a_cprintf(Console, "]");
    }
}

void DrawItem(TConsole *Console, TMenu *Menu, TItem *Item)
{
    char            *ControlBackground;
	unsigned int 	Attr, YPos, i, ItemCaptionLen = Item->Width;

	YPos = Item->YPos;

	/* Make shortcut for Control->Attributes */

	Attr = Item->Flag;

	/*
	**	Create an array with only spaces that occupy the entire control.
	*/

	if((ControlBackground = (char *) malloc(ItemCaptionLen + 2)) == NULL)
		return;
    memset(ControlBackground, ' ', ItemCaptionLen);
    if(TSTBIT(Attr, I_MENU)) 
        ControlBackground[ItemCaptionLen] = '>';
    else
        ControlBackground[ItemCaptionLen] = '\0';
    ControlBackground[ItemCaptionLen + 1] = '\0';

	/*
	**	Set colors for selected/unselected control.
	*/
    
    /* || TSTBIT(Attr, I_DEFAULT) */
	if(TSTBIT(Attr, I_SELECTED)) {
		a_textcolor(Console, Menu->FgSelCol); 
        a_textbackground(Console, Menu->BkSelCol);
	}
	else {
		a_textcolor(Console, Menu->FgCol); 
        a_textbackground(Console, Menu->BkCol);
	}

	/* Set a different color when the control is disabled */

	if(!TSTBIT(Attr, I_ENABLED))
		a_textcolor(Console, Menu->BkCol ^ WHITE);

	/* Plot control background */

	for(i = 0; i < Item->Height; i++) { /* Item->YPos */
		a_gotoxy(Console, Item->XPos, YPos + i);
		a_cputs(Console, ControlBackground);
	}

	/*
	**	Show control if flag VISIBLE is set.
	*/

	if(TSTBIT(Attr, I_VISIBLE)) {
        DrawCaption(Console, Item->XPos, Item->YPos, Item->Caption);
        if(TSTBIT(Item->Flag, I_EDIT) || TSTBIT(Item->Flag, I_ITEM)) 
            DrawItemContents(Console, Menu, Item);
    }

	Item->YPos = YPos;
	free(ControlBackground);
	a_textcolor(Console, Menu->FgCol); a_textbackground(Console, Menu->BkCol);
}

int SwapItemCaptions(char **Cap1, char **Cap2)
{
    char     *TempCap;

    TempCap = *Cap1;
    *Cap1 = *Cap2;
    *Cap2 = TempCap;
    return  TRUE;
}

static void Select(TConsole *Console, TMenu *Menu, TItem *Item)
{
	SETBIT(Item->Flag, I_SELECTED);
	DrawItem(Console, Menu, Item);
}

static void UnSelect(TConsole *Console, TMenu *Menu, TItem *Item)
{
	RESBIT(Item->Flag, I_SELECTED);
	DrawItem(Console, Menu, Item);
}

int OpenLanguageFile(const char *Filename)
{
    FILE    *fp;
    long    FileSize;

    if((fp = fopen(Filename, "rt")) == NULL)
        return 1;
    else {
        if((FileSize = file_size(Filename)) == 0) return 1;
        if((MenuTexts = (char *) malloc(FileSize)) == NULL) return 1;
        fread(MenuTexts, sizeof(char), FileSize / sizeof(char), fp);
        fclose(fp);
    }
    return 0;
}

void CloseLanguageFile(void)
{
    if(MenuTexts != NULL) free(MenuTexts);
}

char **GetItemStrings(const char *Header, int *MenuWidth, int *MaxItemLength, 
int MaxItemIndex)
{
    int     i, len = 0, ilen = 0;
    char    **ItemStrings = (char **) malloc(sizeof(char *) * MaxItemIndex), *p;

    *MaxItemLength = 0;
    *MenuWidth = 0;
    
    if(MenuTexts != NULL) {
        p = MenuTexts;
        MenuTexts = strstr(MenuTexts, Header) + strlen(Header);
        if(MenuTexts == NULL) return NULL;
        for(i = 0; i < MaxItemIndex; i++) {
            MenuTexts = strchr(MenuTexts, '[') + 1;
            len = (int) (strchr(MenuTexts, ']') - MenuTexts);
            if(i > 0) { 
                ilen = len; 
                if(ilen > *MaxItemLength) *MaxItemLength = ilen;
            }
            ItemStrings[i] = (char *) malloc(sizeof(char) * len + 1);
            strncpy(ItemStrings[i], MenuTexts, len);
            *(ItemStrings[i] + len) = '\0';
            if(len > *MenuWidth) *MenuWidth = len; 
        }
        MenuTexts = p;
    }
    else return NULL;
    
    return ItemStrings;
}

TItem *CreateItem(const char *Caption, const char *Contents,
int XPos, int YPos, int Width, int Height, int Flag)
{
    TItem   *Item = (TItem *) malloc(sizeof(TItem));

    if(Caption != NULL) {
        Item->Caption = (char *) malloc(strlen(Caption) + 1);
        strcpy(Item->Caption, Caption);
    }
    else
        Item->Caption = NULL;

    if(Contents != NULL) {
        Item->Contents = (char *) malloc(strlen(Contents) + 1);
        strcpy(Item->Contents, Contents);
    }
    else
        Item->Contents = NULL;

    Item->XPos = XPos;
    Item->YPos = YPos;
    Item->Width = Width;
    Item->Height = Height;
    Item->Flag = Flag;
    return(Item);
}

void DestroyItem(TItem *Item)
{
    if(Item->Caption != NULL) free(Item->Caption);
    if(Item->Contents != NULL) free(Item->Contents);
    if(Item != NULL) free(Item);
}

TItem **CreateItems(const TItem *SrcItems, int NumItem)
{
    int     i;
    TItem   **DestItem = (TItem **) malloc(sizeof(TItem *) * NumItem);

    for(i = 0; i < NumItem; i++) {
        *(DestItem + i) = CreateItem(SrcItems[i].Caption, SrcItems[i].Contents,
        SrcItems[i].XPos, SrcItems[i].YPos, SrcItems[i].Width,
        SrcItems[i].Height, SrcItems[i].Flag);
    }
    return(DestItem);
}

void DestroyItems(TItem **Items, int NumItem)
{
    int     i;

    for(i = 0; i < NumItem; i++) DestroyItem(*(Items + i));
}

TMenu *CreateMenu(const char *Header, int XPos, int YPos, int DefaultItemIndex,
    int MaxItem, int MaxItemWidth, int ItemIndex, int FgCol, int BkCol, 
    int FgSelCol, int BkSelCol, int NumItem, int Flag, const TItem *Items)
{
    TMenu               *Menu;
    unsigned int        i;

    if((Menu = (TMenu *) malloc(sizeof(TMenu))) == NULL) return NULL;
    if((Menu->Header = (char *) malloc(strlen(Header) + 1)) != NULL)
        strcpy(Menu->Header, Header);

    Menu->XPos = XPos;
    Menu->YPos = YPos;
    Menu->DefaultItemIndex = DefaultItemIndex;
    Menu->MaxItem = MaxItem;
    Menu->MaxItemWidth = MaxItemWidth;
    Menu->ItemIndex = ItemIndex;
    Menu->FgCol = FgCol;
    Menu->BkCol = BkCol;
    Menu->FgSelCol = FgSelCol;
    Menu->BkSelCol = BkSelCol;
    Menu->NumItem = NumItem;
    Menu->Flag = Flag;
    
    Menu->Items = CreateItems(Items, Menu->NumItem);

    for(i = 0; i < Menu->MaxItem; i++) {

        if(Menu->Items[i]->XPos == 0)
            Menu->Items[i]->XPos = Menu->XPos;
        if(Menu->Items[i]->YPos == 0)
            Menu->Items[i]->YPos = Menu->YPos + 
            (TSTBIT(Menu->Flag, M_HEADER) ? 2 : 0) + Menu->Items[i]->Height * i;
        if(Menu->Items[i]->Width == 0)
            Menu->Items[i]->Width = Menu->MaxItemWidth;
    }
    
    return Menu;
}

void DestroyMenu(TMenu *Menu)
{
    if(Menu->Items != NULL) DestroyItems(Menu->Items, Menu->NumItem);
    if(Menu->Header != NULL) free(Menu->Header);
    if(Menu != NULL) free(Menu);
}

void DrawMenu(TConsole *Console, TMenu *Menu)
{
    unsigned int        i, OldMenuItemIndex = Menu->ItemIndex;

    a_clrscr(Console);

	/* Menuheader plaatsen */
    
	a_textcolor(Console, Menu->FgCol); a_textbackground(Console, Menu->BkCol);

    if(TSTBIT(Menu->Flag, M_HEADER)) {
	    a_gotoxy(Console, Menu->XPos, Menu->YPos); 
        a_cputs(Console, Menu->Header);
    }
    
    /* help */

    if(TSTBIT(Menu->Flag, M_STATUSBAR)) DrawStatusBar(Console, Menu, 31);
    
	for(i = 0; i < Menu->MaxItem; i++) DrawItem(Console, Menu, Menu->Items[i]);

    OldMenuItemIndex = Menu->ItemIndex;
    Menu->ItemIndex = 0;
	while(!TSTBIT(Menu->Items[Menu->ItemIndex]->Flag, I_VISIBLE))
		if(Menu->ItemIndex < Menu->MaxItem) {
			Menu->ItemIndex++;
            Menu->DefaultItemIndex++;
        }
		else
			break;
    Menu->ItemIndex = OldMenuItemIndex;

	UnSelect(Console, Menu, Menu->Items[Menu->ItemIndex]);
    Select(Console, Menu, Menu->Items[Menu->DefaultItemIndex]);

	Menu->ItemIndex = Menu->DefaultItemIndex;

    if(TSTBIT(Menu->Items[Menu->ItemIndex]->Flag, I_EDIT)) {
        SETBIT(Menu->Items[Menu->ItemIndex]->Flag, I_ENT_EDIT);
        RESBIT(Menu->Items[Menu->ItemIndex]->Flag, I_LEFT_EDIT);
        DrawStatusBar(Console, Menu, 509);
    }
}

int DoMenu(TConsole *Console, TMenu *Menu)
{
    unsigned int        PrevItem, i, k, l, EditStartX, EditOldX, CaptionLen,
                        ContentsLen;
    static unsigned int EditIndex = 0;
    static unsigned int ContentsIndex = 0;

    i = PrevItem = Menu->ItemIndex;

    CaptionLen = strlen(Menu->Items[i]->Caption);
    
    if(TSTBIT(Menu->Items[i]->Flag, I_ENT_EDIT)) {
        EditIndex = 0;
        EditStartX = strlen(Menu->Items[i]->Caption) +
        Menu->Items[i]->XPos + 2;
        a_gotoxy(Console, CaptionLen + Menu->Items[i]->XPos + 2, 
        a_wherey(Console));
        RESBIT(Menu->Items[i]->Flag, I_CHANGED);
        ContentsIndex = 0;
        DrawStatusBar(Console, Menu, 509);
    }
    if(TSTBIT(Menu->Items[i]->Flag, I_LEFT_EDIT)) {
        a_gotoxy(Console, EditStartX - 1, a_wherey(Console)); 
        a_cprintf(Console, " ");
        a_gotoxy(Console, EditStartX + Menu->Items[i]->Width, 
        a_wherey(Console)); 
        a_cprintf(Console, " ");
        ContentsIndex = 0;
    }
    
    RESBIT(Menu->Items[i]->Flag, I_ENT_EDIT);
    RESBIT(Menu->Items[i]->Flag, I_LEFT_EDIT);

    if(TSTBIT(Menu->Items[Menu->ItemIndex]->Flag, I_EDIT)) {
        EditStartX = CaptionLen + Menu->Items[i]->XPos + 2;
        ContentsLen = strlen(Menu->Items[i]->Contents);
    }

    clear_keybuf();
    k = readkey();
    Menu->Key = k >> 8;
    Menu->AscKey = k & 0xFF;
    
    if(Menu->Key == KEY_ESC) { 
        a_textbackground(Console, Menu->BkCol);
        return(KEY_ESC);
    }
    
	switch(Menu->Key) {
		case KEY_DOWN:
        case KEY_UP:
            if(Menu->Key == KEY_DOWN) {
			    i++;
			    if(i >= Menu->MaxItem) i = PrevItem;
			    while(!TSTBIT(Menu->Items[i]->Flag, I_ENABLED) ||
			    !TSTBIT(Menu->Items[i]->Flag, I_VISIBLE)) {
				    i++;
                    if(i >= Menu->MaxItem) { i = PrevItem; break; }
                }
			}

            if(Menu->Key == KEY_UP) {
			    i--;
                if(i >= Menu->MaxItem) i = PrevItem;
			    while(!TSTBIT(Menu->Items[i]->Flag, I_ENABLED) ||
			    !TSTBIT(Menu->Items[i]->Flag, I_VISIBLE)) {
				    i--;
                    if(i >= Menu->MaxItem) { i = PrevItem; break; }
                }
            }
            if(i != PrevItem) {
				UnSelect(Console, Menu, Menu->Items[PrevItem]);
				Select(Console, Menu, Menu->Items[i]);
		        Menu->ItemIndex = i;

                /* Enter an edit control */

                if(TSTBIT(Menu->Items[i]->Flag, I_EDIT)) {
                    SETBIT(Menu->Items[i]->Flag, I_ENT_EDIT);
                    RESBIT(Menu->Items[i]->Flag, I_LEFT_EDIT);
                }

                /* Exit an edit control */

                if(TSTBIT(Menu->Items[PrevItem]->Flag, I_EDIT)) {
                    SETBIT(Menu->Items[PrevItem]->Flag, I_LEFT_EDIT);
                    RESBIT(Menu->Items[PrevItem]->Flag, I_ENT_EDIT);
                }
			}
			break;

        case KEY_HOME:
            if(TSTBIT(Menu->Items[i]->Flag, I_EDIT)) {
                EditIndex = 0;
                a_gotoxy(Console, EditStartX, a_wherey(Console));
            }
            break;

        case KEY_END:
            if(TSTBIT(Menu->Items[i]->Flag, I_EDIT)) {
                if(EditIndex < Menu->Items[i]->Width)
                a_gotoxy(Console, Menu->Items[i]->XPos + EditIndex + 1,
                Menu->Items[i]->YPos);
            }
            break;

        case KEY_LEFT:
            if(TSTBIT(Menu->Items[i]->Flag, I_EDIT)) {
                if(EditIndex > 0) {
                    EditIndex--;
                    a_gotoxy(Console, a_wherex(Console) - 1, a_wherey(Console));
                }
                else {
                    if(ContentsIndex > 0) {
                        ContentsIndex--;
                        EditOldX = a_wherex(Console);
                        a_gotoxy(Console, EditStartX, a_wherey(Console));
                        a_cprintf(Console, "%.*s", Menu->Items[i]->Width,
                        Menu->Items[i]->Contents + ContentsIndex);
                        a_gotoxy(Console, EditOldX, a_wherey(Console));
                    }                        
                }
            }
            break;

        case KEY_RIGHT:
            if(TSTBIT(Menu->Items[i]->Flag, I_EDIT)) {
                if(EditIndex < Menu->Items[i]->Width) {
                    EditIndex++;
                    a_gotoxy(Console, a_wherex(Console) + 1, a_wherey(Console));
                }
                else {
                    if(ContentsLen - ContentsIndex > Menu->Items[i]->Width) {
                        ContentsIndex++;
                        EditOldX = a_wherex(Console);
                        a_gotoxy(Console, EditStartX, a_wherey(Console));
                        a_cprintf(Console, "%.*s", Menu->Items[i]->Width,
                        Menu->Items[i]->Contents + ContentsIndex);
                        a_gotoxy(Console, EditOldX, a_wherey(Console));
                    }
                }
            }
            break;

        case KEY_BACKSPACE:
            if(TSTBIT(Menu->Items[i]->Flag, I_EDIT)) {
                if((EditIndex > 0) && (EditIndex <= Menu->Items[i]->Width)) {
                    EditOldX = a_wherex(Console) - 1;
                    for(l = EditIndex + ContentsIndex; l <= ContentsLen; l++) {
                        Menu->Items[i]->Contents[l - 1] = 
                        Menu->Items[i]->Contents[l];
                    }
                    a_gotoxy(Console, EditStartX, a_wherey(Console));
                    a_cprintf(Console, "%.*s", Menu->Items[i]->Width - 1,
                    Menu->Items[i]->Contents + ContentsIndex);
                    a_cprintf(Console, " ");
                    EditIndex--;
                    a_gotoxy(Console, EditOldX, a_wherey(Console));
                    SETBIT(Menu->Items[i]->Flag, I_CHANGED);
                }
            }
            break;
        case KEY_DEL:
            if(TSTBIT(Menu->Items[i]->Flag, I_EDIT)) {
                if(EditIndex < Menu->Items[i]->Width) {
                    EditOldX = a_wherex(Console);
                    for(l = EditIndex + ContentsIndex; l < ContentsLen; l++) {
                        Menu->Items[i]->Contents[l] =
                        Menu->Items[i]->Contents[l + 1];
                    }
                    a_gotoxy(Console, EditStartX, a_wherey(Console));
                    a_cprintf(Console, "%.*s", Menu->Items[i]->Width - 1,
                    Menu->Items[i]->Contents + ContentsIndex);
                    a_cprintf(Console, " ");
                    a_gotoxy(Console, EditOldX, a_wherey(Console));
                    SETBIT(Menu->Items[i]->Flag, I_CHANGED);
                }
			}
			break;

        case KEY_INSERT:
            break;

        default:
			if(TSTBIT(Menu->Items[i]->Flag, I_EDIT) && (EditIndex <
            Menu->Items[i]->Width)) {
                
                a_gotoxy(Console, CaptionLen +
                Menu->Items[i]->XPos + EditIndex + 2, Menu->Items[i]->YPos);

                if(TSTBIT(Menu->Items[i]->Flag, E_NUM)) {
				    if(isdigit(Menu->AscKey)) {
                        a_cprintf(Console, "%c", Menu->AscKey);
						Menu->Items[i]->Contents[EditIndex + ContentsIndex] = 
                        Menu->AscKey;
						if(EditIndex < Menu->Items[i]->Width) EditIndex++;
					}
                }

                if(TSTBIT(Menu->Items[i]->Flag, E_FNUM)) {
				    if(isdigit(Menu->AscKey) || (Menu->AscKey == '.') ||
                    (Menu->AscKey == '+') || (Menu->AscKey == '-')) {
                        a_cprintf(Console, "%c", Menu->AscKey);
						Menu->Items[i]->Contents[EditIndex + ContentsIndex] = 
                        Menu->AscKey;
						if(EditIndex < Menu->Items[i]->Width) EditIndex++;
					}
                }

                if(TSTBIT(Menu->Items[i]->Flag, E_CHR)) {
				    if(isalpha(Menu->AscKey)) {
                        a_cprintf(Console, "%c", Menu->AscKey);
						Menu->Items[i]->Contents[EditIndex + ContentsIndex] = 
                        Menu->AscKey;
						if(EditIndex < Menu->Items[i]->Width) 
                        EditIndex++;
					}
                }

                if(TSTBIT(Menu->Items[i]->Flag, E_NUMCHR)) {
				    if(isalnum(Menu->AscKey)) {
                        a_cprintf(Console, "%c", Menu->AscKey);
						Menu->Items[i]->Contents[EditIndex + ContentsIndex] = 
                        Menu->AscKey;
						if(EditIndex < Menu->Items[i]->Width) EditIndex++;
					}
                }

                if(TSTBIT(Menu->Items[i]->Flag, E_ASCII)) {
				    if(isascii(Menu->AscKey) && (Menu->AscKey > 31)) {
                        a_cprintf(Console, "%c", Menu->AscKey);
						Menu->Items[i]->Contents[EditIndex + ContentsIndex] = 
                        Menu->AscKey;
						if(EditIndex < Menu->Items[i]->Width) EditIndex++;
					}
                }
			    Menu->Items[i]->Contents[EditIndex + ContentsIndex] = '\0'; 
                SETBIT(Menu->Items[i]->Flag, I_CHANGED);            
            }
			break;
	}
    a_textbackground(Console, Menu->BkCol);
    return Menu->Key;
}
