/*
	This file is part of XFuniter.

	extagui.c V2.2.3 - Allegro-GUI extentions.

    Copyright (C) 1995-2003 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen)

	See README for contact information.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version. See

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	See COPYING for more information.
*/

#include "extagui.h"

static int draw_text(DIALOG *d)
{
    int     i, ofg = d->fg, obg = d->bg, otm,  
            m = (d->d2) ? 0 : gui_strlen(" >"); 

    /* Switch colors when the object has focus */
        
    if(d->flags & D_GOTFOCUS) {
        d->fg = obg;
        d->bg = ofg;
    }

    /* Draw a dotted line */
        
    if(d->flags & D_SELECTED) {
        for(i = 0; i < d->w; i+=2) {
            putpixel(screen, d->x + i, d->y, d->fg);
            putpixel(screen, d->x + i, d->y + d->h, d->fg);
        }
        for(i = 0; i < d->h; i+=2) {
            putpixel(screen, d->x, d->y + i, d->fg);
            putpixel(screen, d->x + d->w - 1, d->y + i, d->fg);
        }
    }
    
    /* clear previous image */
        
    rectfill(screen, d->x, d->y, d->x + d->w + m, d->y + d->h, d->bg);
    
    /* 
    **  draw text. In case the text is drawn for a radio-button we reserve 
    **  some space for the button. 
    */
        
    otm = text_mode(-1);
    gui_textout(screen, d->dp, d->x + 1, d->y + 1, d->fg, 0);    
    
    /* 
    **  When d2 is 0 a > is drawn on the right of each item to indicate that 
    **  the item is a menu and that will follow a certain action out of that
    **  specific window.
    */
    
    if(!(d->d2)) gui_textout(screen, " >", d->x + d->w + 1, d->y + 1, d->fg, 0); 
    
    /* Restore old textmode */
    
    text_mode(otm);

    /* Restore old colors */
        
    d->fg = ofg;
    d->bg = obg;
    
    return 0;
}

int do_alt_dialog(DIALOG *dialog, int focus_obj, int (*dfnp)(DIALOG *))
{
    void    *player;
    
    player = init_dialog(dialog, focus_obj);

    while(update_dialog(player)) 
        if(dfnp != NULL) dfnp(dialog);
          
    return shutdown_dialog(player);
}

/*
**  This is a modification of the d_box_proc which makes it look more like a 
**  dialog-box. Since it draws some additional things, the default handler is
**  called first.
*/

int d_alt_box_proc(int msg, DIALOG *d, int c)
{
    int     res, otm;

    /* Call default handler */
    
    res = d_box_proc(msg, d, c);
    
    if(msg == MSG_DRAW) {
        
        /* Boundary */
        
        rect(screen, d->x + 3, d->y + 3, d->x + d->w - 4, d->y + d->h - 4, 
        d->fg);

        if(d->dp != NULL) {
            
            /* Background for header (Title-bar) */
            
            rectfill(screen, d->x + 5, d->y + 5, d->x + d->w - 6, 
            d->y + 5 + text_height(font) * 2, d->fg);

            /* Set transparant text */
            
            otm = text_mode(-1);
            
            /* Print header (Title) */
            
            gui_textout(screen, (char *) d->dp, d->x + 10, 
            d->y + 5 + text_height(font) / 2, d->bg, 0);
            
            /* Restore textmode */
            
            text_mode(otm);
        }
        return D_O_K;
    }

    return res;
}

int d_menubar_proc(int msg, DIALOG *d, int c)
{
    int     res;
    
    if(msg == MSG_KEY) 
        if(((c >> 8) == KEY_ENTER) || ((c >> 8) == d->key)) return D_CLOSE;
    if(msg == MSG_DCLICK) 
        return D_CLOSE;
    
    if(msg == MSG_GOTFOCUS) { 
        broadcast_dialog_message(MSG_RADIO, d->d1); 
        d->flags |= D_SELECTED;
    }
    
    if(msg == MSG_DRAW) { 
        draw_text(d); 
        return D_O_K; 
    }

    /* return control to the d_radio_proc to handle other events */
        
    res = d_radio_proc(msg, d, c);
    return(res);
}

int d_alt_check_proc(int msg, DIALOG *d, int c)
{
    int     res;
    
    if(msg == MSG_KEY) if((c >> 8) == KEY_ENTER) return D_CLOSE;
    if(msg == MSG_DCLICK) return D_CLOSE;

    res = d_check_proc(msg, d, c);
    return(res);
}

/*
**  Annoyed by the fact that you only could select a radio-button by clicking
**  on the circle, I modified the MSG_DRAW part so that you can click on the
**  text as well.
*/

int d_alt_radio_proc(int msg, DIALOG *d, int c)
{
    int     i, r = text_height(font) / 2, otm, res;
    
    d->w = text_height(font) * 2 + gui_strlen(d->dp) + 2;
    d->h = text_height(font) + 2;           
    
    if(msg == MSG_DRAW) {
        
        /* clear previous image of radio-button */
        
        rectfill(screen, d->x, d->y, d->x + d->w, d->y + d->h, d->bg);
        
        /* draw outer circle */
        
        switch(d->d2) {
            case 0:
                circle(screen, d->x + r + 1, d->y + r + 1, r, d->fg);
                break;
            case 1:
                rect(screen, d->x + 1, d->y+ 1, d->x + r * 2, d->y + r * 2, 
                d->fg);
        }
        
        /* draw text */
        
        otm = text_mode(-1);
        gui_textout(screen, d->dp, d->x + text_height(font) * 2 + 1, d->y + 1, 
        d->fg, 0);    
        text_mode(otm);
        
        /* draw inner (filled) circle when selected */
        
        if(d->flags & D_SELECTED) {
            switch(d->d2) {
                case 0: 
                    circlefill(screen, d->x + r + 1, d->y + r + 1, r - 2, 
                    d->fg);
                    break;
                case 1:
                    rectfill(screen, d->x + 3, d->y + 3, d->x + r * 2 - 2,
                    d->y + r * 2 - 2, d->fg);
                    break;
            }
        }
                    
        /* draw a dotted rectangle around the entire widget when it has focus */
        
        if(d->flags & D_GOTFOCUS) {
            for(i = 0; i < d->w; i+=2) {
                putpixel(screen, d->x + i, d->y, d->fg);
                putpixel(screen, d->x + i, d->y + d->h, d->fg);
            }
            for(i = 0; i < d->h; i+=2) {
                putpixel(screen, d->x, d->y + i, d->fg);
                putpixel(screen, d->x + d->w - 1, d->y + i, d->fg);
            }
            
        }
        return D_O_K;
    }
    
    /* return control to the d_radio_proc to handle other events */
    
    res = d_radio_proc(msg, d, c);
    
    return(res);
}

/*
**  The d_edit_proc routine is enhanced:
**
**  1.  dp2         holds text which is printed in front of the edit field.
**
**  2.  dp3         'char *' to the format which filters keys. The edit-box 
**                  will only accept legal characters for that specific format.
**                  'i' = integer, 'f' = float.          
**
*/

int d_alt_edit_proc(int msg, DIALOG *d, int c)
{
    char        *str = (char *) d->dp3;
    int         res, otm, ofg = d->fg, obg = d->bg; 
    static int  oldx;

    if(msg == MSG_KEY) if((c >> 8) == KEY_ENTER) return D_CLOSE;
    if(msg == MSG_DCLICK) return D_CLOSE;
    
    if(msg == MSG_START) {

        /* 
        **  Store old x position which we require later to print the leading
        **  text 
        */
    
        oldx = d->x;
        
        /* New x position will be just after the text */
        
        if(d->dp2 != NULL) d->x = d->x + gui_strlen(d->dp2);
    }
    
    if(msg == MSG_DRAW) {
        
        /* Set transparant text */

        otm = text_mode(-1);
        
        /* put text from d->dp2 on screen */

        if(d->dp2 != NULL) {
            if(d->flags & D_GOTFOCUS) {
                obg = d->fg;
                ofg = d->bg;
            }
            
            /* Draw selection rectangle */
                
            rectfill(screen, oldx, d->y, oldx + gui_strlen((char *) d->dp2) - 2, 
            d->y + d->h, ofg);
            
            /* Draw text */
            
            gui_textout(screen, (char *) d->dp2, oldx, d->y, obg, 0);
        }
        
        /* Restore old textmode */
        
        text_mode(otm);
    }

    if(msg == MSG_UCHAR) {
        if(str != NULL) {

            /* Only digits */
            
            if(str[0] == 'i') { 
                if(!isdigit(c)) return D_O_K; 
            }

            /* Floating point numbers */
            
            if(str[0] == 'f') {
                if(!(isdigit(c) || (c == '.') || (c == '+') || (c == '-')))
                    return D_O_K;
            }
        }   
    }
    
    /* Return control to the default handler */

    res = d_edit_proc(msg, d, c);

    return res;
}
