/*
	This file is part of XFuniter.

	help.c V2.2.3 - some routines which are part of the funiter help-function.

	Copyright (C) 1995-2003 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen).
    
	See README for contact information.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version. See

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	See COPYING for more information.
*/

#include "help.h"

static const char

    *ConstGraphStr[] = {    "Step-by-step iteration",
                            "Orbit diagram for var. x",
                            "Orbit diagram for var. c",
                            "Step-by-step iteration",
                            "Step-by-step inverse iteration",
                            "Orbit diagram for var. z (Julia)",
                            "Orbit diagram for var. c (Mandelbrot)"
    };

/*
**  Search for the highest string in an array of strings.
*/

static int GetHighestStrLen(char *Str[], int First, int Last)
{
    int     i, length = 0;

    for(i = First; i <= Last; i++)
        if(gui_strlen(Str[i]) > length) length = gui_strlen(Str[i]);

    return(length);
}

/*
**	This function draws a box on screen with information, it waits for a key
**	which is returned by the function.
**
**  Char **Text         -   Lines with the text.
**  int MaxItem         -   Number of items - 1.
*/

int InfoBox(char **Text, int MaxItem)
{
	int         x, y, w, h, i, ch, OldTextMode;
	BITMAP      *Bitmap, *BitmapHelp;

    w = GetHighestStrLen(Text, 0, MaxItem) + 12;
    if(w > SCREEN_W) w = SCREEN_W;
    h = (MaxItem + 1) * text_height(font) + 12;

    Bitmap = create_bitmap(w, h);

    BitmapHelp = create_bitmap(w, h);
    clear_to_color(BitmapHelp, makecol(255, 255, 255));

    OldTextMode = text_mode(-1);

    x = (SCREEN_W - w) / 2;
	y = (SCREEN_H - h) / 2;

	rect(BitmapHelp, 2, 2, w - 2, h - 2, makecol(0, 0, 0));

	for(i = 0; i <= MaxItem; i++) {
	    textout(BitmapHelp, font, Text[i], 6, 6 + i * text_height(font),
        makecol(0, 0, 0));
	}

    blit(screen, Bitmap, x, y, 0, 0, w, h);

    blit(BitmapHelp, screen, 0, 0, x, y, w, h);
    
	ch = readkey(); 

    blit(Bitmap, screen, 0, 0, x, y, w, h);

    text_mode(OldTextMode);
    
    destroy_bitmap(BitmapHelp);
    destroy_bitmap(Bitmap);
	return(ch);
}

void StatusBar(int Mode, int RealGraph, int ComplexGraph, char *ValueStr)
{
    BITMAP          *Bitmap;
    int             SLGraphMenuWidth, SLGraphMaxItemLength, i, TempGraph = -1;
    char            **GraphStr = GetItemStrings("SLGRAPH", &SLGraphMenuWidth, 
                    &SLGraphMaxItemLength, 7);

    if(Mode == 0) return;
    if(GraphStr == NULL) GraphStr = (char **) ConstGraphStr;
     
    Bitmap = create_bitmap(SCREEN_W, 20);
    clear_bitmap(Bitmap);

    /* draw a line between the image and the beginning of the statusline */

    hline(Bitmap, 0, 1, SCREEN_W, 15);

    /* Draw the used colorpalette */

    for(i = 0; i <= 15; i++)
        rectfill(Bitmap, SCREEN_W - i * 8, 8, SCREEN_W - (i * 8 + 5), 17, i);

    rect(Bitmap, SCREEN_W - 127, 6, SCREEN_W - 1, 19, 15);

    /* Print the name of the current Graph */

    if(RealGraph >= 0 && ComplexGraph < 0)
        TempGraph = RealGraph;
    else if(RealGraph < 0 && ComplexGraph >= 0)
        TempGraph = ComplexGraph + 3;
    else
        TempGraph = -1;

    if(TempGraph >= 0) {
        rect(Bitmap, SCREEN_W - 132 - gui_strlen(GraphStr[TempGraph]), 6,
        SCREEN_W - 130, 19, 15);
        textout(Bitmap, font, GraphStr[TempGraph], SCREEN_W - 130 -
        gui_strlen(GraphStr[TempGraph]), 6 + (14 - text_height(font)) / 2, 15);
    }

    /* print additional info such as iteration-step or iteration-values */

    if(ValueStr != NULL) {
        rect(Bitmap, SCREEN_W - 137 - (gui_strlen(GraphStr[TempGraph]) +
        gui_strlen(ValueStr)), 6, SCREEN_W - 135 -
        gui_strlen(GraphStr[TempGraph]), 19, 15);
        textout(Bitmap, font, ValueStr, SCREEN_W - 135 -
        (gui_strlen(GraphStr[TempGraph]) + gui_strlen(ValueStr)),
        6 + (14 - text_height(font)) / 2, 15);
    }

    acquire_screen();
    blit(Bitmap, screen, 0, 0, 0, SCREEN_H - 20, SCREEN_W, 20);
    release_screen();
    vsync();
    
    destroy_bitmap(Bitmap);
}
