/*
	This file is part of XFuniter.

	misc.c V2.2.3 - some misc. routines.

	Copyright (C) 1995-2003 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen).
    
	See README for contact information.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version. See

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	See COPYING for more information.
*/

#include "misc.h"

double max(double a, double b) { return((a > b) ? (a) : (b)); }
double min(double a, double b) { return((a < b) ? (a) : (b)); }
    
/*
**	WriteEPS
**
**	Write a bitmap to a Postscript file.
**	EPS = Encapsulated PostScript
**
**  Bitmap      - Pointer to a bitmap.  
**  w           - Bitmap width.
**  h           - Bitmap height.
**	fp			- FILE *, pointer naar bestandsinformatie.
**	Mode		- int, 0 = portrait, 1 = landscape
*/

int WriteEPS(BITMAP *Bitmap, int w, int h, FILE *fp, int Mode)
{
	int 	xs, x, y, c, pp;

	/* Write comment-header */

	fputs("%!PS-Adobe-3.0 EPSF\n", fp);
	fputs("%%Creator: Funiter by Stijn Wolters\n", fp);
	fputs("%%Pages: 1\n", fp);
	if(Mode == LANDSCAPE)
		fputs("%%BoundingBox: 36 78 521 720\n", fp);
	else /*if(Mode == PORTRAIT)*/
		fputs("%%BoundingBox: 32 64 570 472\n", fp);

	fputs("%%EndComments\n", fp);

	/* Create dictionary and write gfx status */

	fputs("gsave\n", fp);
	fputs("20 dict begin\n", fp);
	fputs("gsave\n", fp);
	fputs("2 setlinewidth\n", fp);

	/*
	**	Line drawing function, parameters:
	**  - graylevel (real) 0..1
	**	- xbegin, xend, y
	*/

	fputs("/l { setgray moveto lineto stroke } bind def\n", fp);

	/* translation */

	if(Mode == LANDSCAPE)
		fputs("40 80 translate\n", fp);
	else /*if(Mode == PORTRAIT)*/ {
		fputs("0.84 0.84 scale\n", fp);
		fputs("-90 rotate\n", fp);
		fputs("-560 40 translate\n", fp);
	}

	/* Encode the image */

	xs = x = w - 1;
	for(y = h - 1; y >= 0; y--) {
		do {
			c = getpixel(Bitmap, x, y);
			pp = c;
			do {
				x--;
				c = getpixel(Bitmap, x, y);
			} while(c == pp && x > 0);
			if(pp == 0)
				pp = 15;
			else if(pp == 15)
				pp = 0;
			if(pp < 15)
				fprintf(fp, "\n%d %d %d %d %g l",
			    y, x, y, xs, (double) pp / 15.0);
			if(x == 0) {
				xs = x = w - 1;
				break;
			}
			else
				xs = x;
		} while(x >= 0);
	}
	fputs("\nshowpage\n", fp);
	fputs("grestore\n", fp);
	fputs("end\n", fp);
	fputs("%%Trailer", fp);

	return 0;
}

