/*
	This file is part of XFuniter.

	settings.c V2.2.3 - settings.

	Copyright (C) 1995-2003 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen)

	See README for contact information.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version. See

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	See COPYING for more information.
*/

#include "settings.h"


TSettings *CreateSettings(void)
{
	TSettings *Settings;

	if((Settings = (TSettings *) malloc(sizeof(TSettings))) == NULL)
		return NULL;

	Settings = SetDefaultSettings(Settings);

	return(Settings);
}

void FreeSettings(TSettings *Settings)
{
	if(Settings != NULL) free(Settings);
}

TSettings *SetDefaultSettings(TSettings *Settings)
{
    int         i;
    
    /* Get entire default palette */
    
    get_palette(Settings->Palette);
    
    /* Default colors */
    
    Settings->Palette[ 0].b = 0x00; 
    Settings->Palette[ 0].g = 0x00; 
    Settings->Palette[ 0].r = 0x00;
    
    Settings->Palette[ 1].b = 0x00; 
    Settings->Palette[ 1].g = 0x00; 
    Settings->Palette[ 1].r = 0xA8;
    
    Settings->Palette[ 2].b = 0x54; 
    Settings->Palette[ 2].g = 0x54; 
    Settings->Palette[ 2].r = 0xFC;
    
    Settings->Palette[ 3].b = 0xA8; 
    Settings->Palette[ 3].g = 0x00; 
    Settings->Palette[ 3].r = 0xA8;
    
    Settings->Palette[ 4].b = 0xFC; 
    Settings->Palette[ 4].g = 0x54; 
    Settings->Palette[ 4].r = 0xFC;
    
    Settings->Palette[ 5].b = 0x00; 
    Settings->Palette[ 5].g = 0x54; 
    Settings->Palette[ 5].r = 0xA8;
    
    Settings->Palette[ 6].b = 0x54; 
    Settings->Palette[ 6].g = 0xFC; 
    Settings->Palette[ 6].r = 0xFC;
    
    Settings->Palette[ 7].b = 0x00; 
    Settings->Palette[ 8].g = 0xA8; 
    Settings->Palette[ 8].r = 0x00;
    
    Settings->Palette[ 8].b = 0x54; 
    Settings->Palette[ 7].g = 0xFC; 
    Settings->Palette[ 7].r = 0x54;
    
    Settings->Palette[ 9].b = 0xA8; 
    Settings->Palette[ 9].g = 0xA8; 
    Settings->Palette[ 9].r = 0x00;
    
    Settings->Palette[10].b = 0xFC; 
    Settings->Palette[10].g = 0x54; 
    Settings->Palette[10].r = 0x54;
    
    Settings->Palette[11].b = 0xFC; 
    Settings->Palette[11].g = 0xFC; 
    Settings->Palette[11].r = 0x54; 
    
    Settings->Palette[12].b = 0xA8; 
    Settings->Palette[12].g = 0x00; 
    Settings->Palette[12].r = 0x00;
    
    Settings->Palette[13].b = 0xA8; 
    Settings->Palette[13].g = 0xA8; 
    Settings->Palette[13].r = 0xA8;
    
    Settings->Palette[14].b = 0x54; 
    Settings->Palette[14].g = 0x54; 
    Settings->Palette[14].r = 0x54;
    
    Settings->Palette[15].b = 0xFC; 
    Settings->Palette[15].g = 0xFC; 
    Settings->Palette[15].r = 0xFC;
    
    for(i = 0; i <= 15; i++) {
        Settings->Palette[i].b >>= 2; 
        Settings->Palette[i].g >>= 2; 
        Settings->Palette[i].r >>= 2;
    }
    
    /* General settings */
    
	Settings->GEN_MenuStyle = TRUE;
	Settings->GEN_Fixedpoint = TRUE;
	Settings->GEN_ParConnect = TRUE;

	/* Layout settings (what you see / and how it appears on screen) */

	Settings->LAY_Statusline = TRUE;

	/* Coordinates - Sub-section in the Layout settings */

	Settings->COO_Status = TRUE;
	Settings->COO_Grid = FALSE;
	Settings->COO_Calibrate = TRUE;

	/* Step by step iteration - Sub-section in the Layout settings */

	Settings->SSI_Text = TRUE;
	Settings->SSI_Lines = TRUE;
	Settings->SSI_LineWidth = 2;
	Settings->SSI_FontSize = 4;
	Settings->SSI_Accuracy = 8;

	/* Colors */

	Settings->COL_Inside = 0;
	Settings->COL_Outside = 15;
	Settings->COL_Grid = 15;
	Settings->COL_Function = 4;
	Settings->COL_XYLine = 7;
	Settings->COL_Iter1 = 6;
	Settings->COL_Iter2 = 5;
	Settings->COL_Max = 15;

    for(i = 0; i <= 15; i++) Settings->COL_List[i] = i;

    set_palette(Settings->Palette);
    set_palette_range(Settings->Palette, 0, 15, FALSE);
	return(Settings);
}

/*
**  Load Settings.
*/

int LoadSettings(FILE *fp, TSettings *Settings)
{
    int             i, r, g, b;
    
    fscanf(fp, "%d,%d,%d\n", &Settings->GEN_MenuStyle, 
    &Settings->GEN_Fixedpoint, &Settings->GEN_ParConnect);
        
    fscanf(fp, "%d\n", &Settings->LAY_Statusline);
    
    fscanf(fp, "%d,%d,%d\n", &Settings->COO_Status, &Settings->COO_Grid,
    &Settings->COO_Calibrate);

    fscanf(fp, "%d,%d,%d,%d,%d\n", &Settings->SSI_Text, &Settings->SSI_Lines,
    &Settings->SSI_LineWidth, &Settings->SSI_FontSize, &Settings->SSI_Accuracy);
    
    fscanf(fp, "%d,%d,%d,%d,%d,%d,%d,%d\n", &Settings->COL_Inside, 
    &Settings->COL_Outside, &Settings->COL_Grid, &Settings->COL_Function,
    &Settings->COL_XYLine, &Settings->COL_Iter1, &Settings->COL_Iter2, 
    &Settings->COL_Max);
    
    /*for(i = 0; i <= 15; i++) fscanf(fp, "%d\n", &Settings->COL_List[i]);*/
    
    for(i = 0; i <= 15; i++) {
        fscanf(fp, "%3d,%3d,%3d\n", &b, &g, &r);
        Settings->Palette[i].b = (unsigned char) b; 
        Settings->Palette[i].g = (unsigned char) g; 
        Settings->Palette[i].r = (unsigned char) r;
    }

    set_palette(Settings->Palette);
    set_palette_range(Settings->Palette, 0, 15, FALSE);
    return 0;
}

/*
**  Save Settings.
*/

int SaveSettings(FILE *fp, TSettings *Settings)
{
    int             i;
    
    fprintf(fp, "%d,%d,%d\n", Settings->GEN_MenuStyle, Settings->GEN_Fixedpoint,
    Settings->GEN_ParConnect);
        
    fprintf(fp, "%d\n", Settings->LAY_Statusline);
    
    fprintf(fp, "%d,%d,%d\n", Settings->COO_Status, Settings->COO_Grid,
    Settings->COO_Calibrate);

    fprintf(fp, "%d,%d,%d,%d,%d\n", Settings->SSI_Text, Settings->SSI_Lines,
    Settings->SSI_LineWidth, Settings->SSI_FontSize, Settings->SSI_Accuracy);
    
    fprintf(fp, "%d,%d,%d,%d,%d,%d,%d,%d\n", Settings->COL_Inside, 
    Settings->COL_Outside, Settings->COL_Grid, Settings->COL_Function,
    Settings->COL_XYLine, Settings->COL_Iter1, Settings->COL_Iter2, 
    Settings->COL_Max);

    for(i = 0; i <= 15; i++) 
        fprintf(fp, "%3d,%3d,%3d\n", Settings->Palette[i].b, 
        Settings->Palette[i].g, Settings->Palette[i].r);
    
    return 0;
}

