/*
	This file is part of XFuniter.

	texts.h V2.2.3 - header file with most of the menu texts.

	Copyright (C) 1995-2003 Stijn Wolters.
    Original idea: Ernic Kamerich (University of Nijmegen).
    
	See README for contact information.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version. See

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	See COPYING for more information.
*/

#ifndef PROGRAM_TEXTS
    #define PROGRAM_TEXTS
    
    static /*const*/ char

    LicenseText[] = 
	    
        "Please read this document carefully before using this software:\n"
        "\n"
        "XFuniter V2.2.2 Copyright (C) 1995-2003 Stijn Wolters.\n"
        "Original idea: Ernic Kamerich (University of Nijmegen).\n"
        "\n"
	    "See README for contact information.\n"
        "\n"
	    "This program is free software; you can redistribute it and/or modify "
	    "it under the terms of the GNU General Public License as published by "
	    "the Free Software Foundation; either version 2 of the License, or "
	    "(at your option) any later version.\n"
        "\n"
	    "This program is distributed in the hope that it will be useful, "
	    "but WITHOUT ANY WARRANTY; without even the implied warranty of "
	    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
	    "GNU General Public License for more details.\n"
        "\n"
	    "You should have received a copy of the GNU General Public License "
	    "along with this program; if not, write to the Free Software "
	    "Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 "  
        "USA"
        "\n"
	    "See COPYING for more information.\n"
    ,

    /*
    **  Menu texts.
    */
    
    *MainMenuStr[] = {

        "Fu&nctiontype",
        "&Graph",
        "Diagra&m",
        "F&unction",
        "&Parameters",
        "&Draw",
        "&Settings",
        "&File",
        "&About",
        "&Quit",
        "",
        "&Start"
    },
    
    *FnTypeMenuStr[] = {

        "Functiontype:",
        "from &R to R",
        "from &C to C",
    },
    FnTypeHkStr[] = "rc",
    
    *GraphMenuStr[] = {

        "Graph:",
        "&Step by step iteration",
        "Step by step &inverse iteration",
        "Orbit diagram for variable &x",
        "Orbit diagram for variable &c",

         /* In case of complex experiment x should become z */

        "Orbit diagram for variable &z",
    },
    GraphHkStr[] = "sixcz",

    *DiagramMenuStr[] = {

        "Diagram:",
        "Select a shape to start with:",

        /* Real: Step: Diagrams (2 t/m 5) */

        "&Webdiagram",
        "&Iteration values",
        "&Stepdiagram",
        "&Combination of web- and stepdiagram",

        /* Complex: Step: Shapes (6 t/m 9) */

        "&Point",
        "&Line",
        "&Rectangle",
        "&Circle",

        /* Complex: Orbits: Diagrams (10 t/m 13) */

        "&Filled-in",
        "&Escape time",
        "&Boundary trace",
        "&Inverse iteration method",
    },
    DiagramHkStr[] = "wiscplrcfebi",

    *ColMenuStr[] = {

        "Select coloring method:",
        "Color depends on &startingpoint",
        "Color depends on &iteration steps",
        "&All iteration steps the same color"
    },
    ColHkStr[] = "sia",

    *FnMenuStr[] = {
        
        "Function:",
        
        "x -> x^2 + c",
        
        "x -> frac(cx)",
        
		"x -> c * cos(x)",
        
		"x -> cx(1 - x)",
        
		"x -> -cx^3 + (c + 1) x^2",
        
		"x -> c(1 - |2x - 1|)",
        
		"User defined",
        
		"User defined (Escapevalue test)"
    },							

    *ParMenuStr[] = {

        "Parameters:",
        "Value for parameter c            :",
        "1st starting value for iteration :",
        "2nd starting value for iteration :",
        "Estimated lowest value           :",
        "Estimated highest value          :",
        "Y-coordinate (lowest)            :",
        "Y-coordinate (highest)           :",
        "Escape value                     :",
        "Number of steps/iteration        :",
        "Total number of iterations       :",
        "Number of skipped iterationsteps :",

        /* Differences: Real: Step: index: 3, 4 and 9 */

        "Lowest value for c               :",
        "Highest value for c              :",
        "Function N times iterated        :",

        /* Differences: Real: Orbits x: index: 3 and 4 */

        "Lowest value for x               :",
        "Highest value for x              :",

        /* Differences: Real: Orbits c: index: 3 and 4 */

        "Lowest value for c               :",
        "Highest value for c              :",

        /*
        **  Differences: Complex: Step: index: 1 and 2
        **               Complex: Orbits: index 1 and 2
        */

	    "Real part of c                   :",
	    "Imaginary part of c              :",

        /* Differences: Complex: Step: index: 3 to 6 */

        "Min. for real part of values     :",
	    "Max. for real part of values     :",
	    "Min. for imaginary part of values:",
	    "Max. for imaginary part of values:",

        /* Differences: Complex: Orbits c: index 1 and 2 */

	    "Real part of z                   :",
	    "Imaginary part of z              :"
    },

    *AboutMenuStr[] = {
        
        "About Funiter"
    },
    
    /*
    **  Help texts.
    */
    
    F1KeyStr[] = "[ F1 ] = Help.",

    *ZoomHelpStr[] = {

		"ENTER    - Select area (zoom)    ",
		"ESCAPE   - Abort selection       ",
		"PGUP     - Smaller rect          ",
		"PGDN     - Larger rect           ",
		"0..9     - Skip n pixels (faster)",
        "ENTER    - Continue selection    "
    },

    *RealStepHelpStr[] = {

		"ENTER    - Iterate         ",
		"DELETE   - Erase screen    ",
		"ESCAPE   - To central menu "
    },

    /*
    **  Central menu's.
    */
    
    *RJSubMenuStr[] = {

        "<W>     - Webdiagram                ",
		"<I>     - Iteration values          ",
		"<S>     - Stepdiagram               ",
		"<C>     - Combination: Web & Step   ",
		"ESCAPE  - Previous menu             "
    };
    
#endif
